!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_replace
  use cubetools_structure
  use cube_types
  use cubetools_keyword_arg
  use cubeadm_cubeid_types
  use cubemain_messaging
  !
  public :: replace
  public :: cubemain_replace_command
  private
  !
  character(len=*), parameter :: keyvalues(1) = &
       ['NaN'] ! We could also add +- inf
  !
  integer(kind=code_k), parameter :: valisreal = -1
  integer(kind=code_k), parameter :: valisnan = 1
  !
  type :: replace_comm_t
     type(option_t),      pointer :: comm
     type(option_t),      pointer :: value
     type(keyword_arg_t), pointer :: ival_arg
     type(keyword_arg_t), pointer :: oval_arg
   contains
     procedure, public  :: register     => cubemain_replace_register
     procedure, private :: parse        => cubemain_replace_parse
     procedure, private :: parse_values => cubemain_replace_parse_values
     procedure, private :: main         => cubemain_replace_main
  end type replace_comm_t
  type(replace_comm_t) :: replace
  !
  integer(kind=4), parameter :: icube = 1
  type replace_user_t
     type(cubeid_user_t)   :: cubeids
     character(len=argu_l) :: ival   ! Value to be replaced 
     character(len=argu_l) :: oval   ! Value to replace with
   contains
     procedure, private :: toprog => cubemain_replace_user_toprog
  end type replace_user_t
  type replace_prog_t
     type(cube_t), pointer :: cube       ! Input cube
     type(cube_t), pointer :: replace    ! Output cube
     integer(kind=code_k)  :: ivaliskey  ! Value to replace is NaN ?
     real(kind=sign_k)     :: ival       ! Value to be replaced
     real(kind=sign_k)     :: oval       ! Value to replace with
     integer(kind=pixe_k)  :: nl,nm      ! Image size
     integer(kind=chan_k)  :: nc         ! Spectrum size
     procedure(cubemain_replace_prog_image_loop_nan), pointer :: loop => null()
   contains
     procedure, private :: header => cubemain_replace_prog_header
     procedure, private :: data   => cubemain_replace_prog_data
  end type replace_prog_t
  !
contains
  !
  subroutine cubemain_replace_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(replace_user_t) :: user
    character(len=*), parameter :: rname='REPLACE>COMMAND'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call replace%parse(line,user,error)
    if (error) return
    call replace%main(user,error)
    if (error) continue
  end subroutine cubemain_replace_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_replace_register(replace,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_comm_t), intent(inout) :: replace
    logical,               intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(keyword_arg_t) :: keyarg
    !
    character(len=*), parameter :: comm_abstract = &
         'Replace a value in a cube by another value'
    character(len=*), parameter :: comm_help = &
         strg_id
    character(len=*), parameter :: rname='REPLACE>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'REPLACE','[cube]',&
         comm_abstract,&
         comm_help,&
         cubemain_replace_command,&
         replace%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         'Cube with values to be replaced',  &
         strg_id,&
         code_arg_optional,  &
         [flag_cube], &
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'VALUE','ival oval',&
         'Define value to be replaced and its replacement',&
         strg_id,&
         replace%value,error)
    if (error) return
    call keyarg%register( &
         'ival',  &
         'Value to be replaced', &
         strg_id,&
         code_arg_mandatory, &
         keyvalues,  &
         flexible,  &
         replace%ival_arg,  &
         error)
    if (error) return
    call keyarg%register( &
         'oval',  &
         'Value to replace with', &
         strg_id,&
         code_arg_mandatory, &
         keyvalues,  &
         flexible,  &
         replace%oval_arg,  &
         error)
    if (error) return
    !
  end subroutine cubemain_replace_register
  !
  subroutine cubemain_replace_parse(replace,line,user,error)
    use cubetools_parse
    !----------------------------------------------------------------------
    ! REPLACE cubname
    ! /UNIT name
    ! /EFFICIENCIES Beff [Feff]
    !----------------------------------------------------------------------
    class(replace_comm_t), intent(in)    :: replace
    character(len=*),      intent(in)    :: line
    type(replace_user_t),  intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='REPLACE>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,replace%comm,user%cubeids,error)
    if (error) return
    call replace%parse_values(line,user,error)
    if (error) return
  end subroutine cubemain_replace_parse
  !
  subroutine cubemain_replace_parse_values(replace,line,user,error)
    !----------------------------------------------------------------------
    ! /VALUE ival oval
    !----------------------------------------------------------------------
    class(replace_comm_t), intent(in)    :: replace
    character(len=*),      intent(in)    :: line
    type(replace_user_t),  intent(inout) :: user
    logical,               intent(inout) :: error
    !
    logical :: present
    character(len=*), parameter :: rname='REPLACE>PARSE>UNIT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call replace%value%present(line,present,error)
    if (error) return
    if (present) then
       call cubetools_getarg(line,replace%value,1,user%ival,mandatory,error)
       if(error) return
       call cubetools_getarg(line,replace%value,2,user%oval,mandatory,error)
       if(error) return       
    else
       call cubemain_message(seve%e,rname,'Option /VALUE is obligatory')
       error = .true.
       return
    endif
  end subroutine cubemain_replace_parse_values
  !
  subroutine cubemain_replace_main(replace,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_comm_t), intent(in)    :: replace
    type(replace_user_t),  intent(in)    :: user
    logical,               intent(inout) :: error
    !
    type(replace_prog_t) :: prog
    character(len=*), parameter :: rname='REPLACE>MAIN'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubemain_replace_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_replace_user_toprog(user,prog,error)
    use cubetools_unit
    use cubetools_nan
    use cubetools_user2prog
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_user_t), intent(in)    :: user
    type(replace_prog_t),  intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    integer(kind=code_k) :: ikey
    character(len=mess_l) :: mess
    character(len=argu_l) :: argu
    type(unit_user_t) :: nounit
    character(len=*), parameter :: rname='REPLACE>USER>TOPROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(replace%comm,icube,user%cubeids,code_access_imaset_or_speset,  &
      code_read,prog%cube,error)
    if (error) return
    !
    prog%nl = prog%cube%head%arr%n%l
    prog%nm = prog%cube%head%arr%n%m
    prog%nc = prog%cube%head%arr%n%c
    !
    call cubetools_unit_get(strg_star,code_unit_unk,nounit,error)
    if (error) return
    !
    if (user%ival.eq."=") then
       call cubemain_message(seve%e,rname,'= syntax not supported for value to be replaced')
       error =  .true.
       return
    endif
    if (user%oval.eq."=") then
       call cubemain_message(seve%e,rname,'= syntax not supported for replacing value')
       error =  .true.
       return
    endif
    !
    call cubetools_keyword_user2prog(replace%ival_arg,user%ival,ikey,argu,error)
    if (error)  return
    if (argu.eq.strg_unresolved) then
       call cubetools_user2prog_resolve_star(user%ival,nounit,gr4nan,prog%ival,error)
       if (error) return
       if (user%ival.eq.strg_star) then
          prog%ivaliskey = valisnan
       else
          prog%ivaliskey = valisreal
       endif
    else
       select case(argu)
       case('NAN')
          prog%ival = gr4nan
          prog%ivaliskey = valisnan
       case default
          call cubemain_message(seve%e,rname,"Unknown key value: "//argu)
          error =  .true.
          return
       end select
    endif
    call cubetools_keyword_user2prog(replace%oval_arg,user%oval,ikey,argu,error)
    if (error)  return
    if (argu.eq.strg_unresolved) then
       call cubetools_user2prog_resolve_star(user%oval,nounit,gr4nan,prog%oval,error)
       if (error) return
    else
       select case(argu)
       case('NAN')
          prog%oval = gr4nan
       case default
          call cubemain_message(seve%e,rname,"Unknown key value: "//argu)
          error =  .true.
          return
       end select
    endif
    ! User feedback
    write(mess,'(2(a,1pg14.7))') 'Replacing ',prog%ival,' with ',prog%oval
    call cubemain_message(seve%i,rname,mess)
    !
    select case (prog%cube%order())
    case (code_cube_imaset)
       if (prog%ivaliskey.eq.valisnan) then
          prog%loop => cubemain_replace_prog_image_loop_nan
       else
          prog%loop => cubemain_replace_prog_image_loop_real
       endif
    case (code_cube_speset)
       if (prog%ivaliskey.eq.valisnan) then
          prog%loop => cubemain_replace_prog_spectrum_loop_nan
       else
          prog%loop => cubemain_replace_prog_spectrum_loop_real
       end if
    case default
       call cubemain_message(seve%e,rname,'Unsupported file access')
       error = .true.
       return
    end select
  end subroutine cubemain_replace_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_replace_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='REPLACE>PROG>HEADER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%cube,[flag_replace,flag_cube],prog%replace,error)
    if (error) return
    !
  end subroutine cubemain_replace_prog_header
  !
  subroutine cubemain_replace_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='REPLACE>PROG>DATA'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error)  exit
       !$OMP TASK SHARED(prog) FIRSTPRIVATE(iter,error)
       if (.not.error) then
          call prog%loop(iter%first,iter%last,error)
       endif
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubemain_replace_prog_data
  !
  subroutine cubemain_replace_prog_image_loop_nan(prog,first,last,error)
    use cubetools_nan
    use cubeadm_entryloop
    use cubemain_image_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: first
    integer(kind=entr_k),  intent(in)    :: last
    logical,               intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    integer(kind=pixe_k) :: il,im
    type(image_t) :: inimg, ouimg
    character(len=*), parameter :: rname='REPLACE>PROG>IMAGE>LOOP>NAN'
    !
    call inimg%init(prog%cube,error)
    if (error) return
    call ouimg%reallocate('ouimg',prog%nl,prog%nm,error)
    if (error) return
    !
    do ie = first,last
       call cubeadm_entryloop_iterate(ie,error)
       if(error) return
       call inimg%get(prog%cube,ie,error)
       if (error) return
       do im=1,prog%nm
          do il=1,prog%nl
             if (ieee_is_nan(inimg%z(il,im))) then
                ouimg%z(il,im) = prog%oval
             else
                ouimg%z(il,im) = inimg%z(il,im)
             endif
          end do
       end do
       call ouimg%put(prog%replace,ie,error)
       if (error) return
    enddo ! ie
  end subroutine cubemain_replace_prog_image_loop_nan
  !
  subroutine cubemain_replace_prog_image_loop_real(prog,first,last,error)
    use cubeadm_entryloop
    use cubemain_image_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: first
    integer(kind=entr_k),  intent(in)    :: last
    logical,               intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    integer(kind=pixe_k) :: il,im
    type(image_t) :: inimg, ouimg
    character(len=*), parameter :: rname='REPLACE>PROG>IMAGE>LOOP>REAL'
    !
    call inimg%init(prog%cube,error)
    if (error) return
    call ouimg%reallocate('out',prog%nl,prog%nm,error)
    if (error) return
    !
    do ie = first,last
       call cubeadm_entryloop_iterate(ie,error)
       if(error) return
       call inimg%get(prog%cube,ie,error)
       if (error) return
       do im=1,prog%nm
          do il=1,prog%nl
             if (inimg%z(il,im).eq.prog%ival) then
                ouimg%z(il,im) = prog%oval
             else
                ouimg%z(il,im) = inimg%z(il,im)
             endif
          end do
       end do
       call ouimg%put(prog%replace,ie,error)
       if (error) return
    enddo ! ie
  end subroutine cubemain_replace_prog_image_loop_real
  !
  subroutine cubemain_replace_prog_spectrum_loop_nan(prog,first,last,error)
    use cubeadm_entryloop
    use cubemain_spectrum_real
    use cubetools_nan
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: first
    integer(kind=entr_k),  intent(in)    :: last
    logical,               intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    integer(kind=chan_k) :: ic
    type(spectrum_t) :: inspec,ouspec
    character(len=*), parameter :: rname='REPLACE>PROG>SPECTRUM>LOOP>NAN'
    !
    call inspec%reassociate_and_init(prog%cube,error)
    if (error) return
    call ouspec%reallocate('out spectrum',prog%nc,error)
    if (error) return
    !
    do ie = first,last
       call cubeadm_entryloop_iterate(ie,error)
       if(error) return
       call inspec%get(prog%cube,ie,error)
       if (error) return
       do ic=1,prog%nc
          if (ieee_is_nan(inspec%t(ic))) then
             ouspec%t(ic) = prog%oval
          else
             ouspec%t(ic) = inspec%t(ic)
          endif
       end do
       call ouspec%put(prog%replace,ie,error)
       if (error) return
    enddo ! ie
  end subroutine cubemain_replace_prog_spectrum_loop_nan
  !
  subroutine cubemain_replace_prog_spectrum_loop_real(prog,first,last,error)
    use cubeadm_entryloop
    use cubemain_spectrum_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(replace_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: first
    integer(kind=entr_k),  intent(in)    :: last
    logical,               intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    integer(kind=chan_k) :: ic
    type(spectrum_t) :: inspec,ouspec
    character(len=*), parameter :: rname='REPLACE>PROG>SPECTRUM>LOOP>REAL'
    !
    call inspec%reassociate_and_init(prog%cube,error)
    if (error) return
    call ouspec%reallocate('out spectrum',prog%nc,error)
    if (error) return
    !
    do ie = first,last
       call cubeadm_entryloop_iterate(ie,error)
       if(error) return
       call inspec%get(prog%cube,ie,error)
       if (error) return
       do ic=1,prog%nc
          if (inspec%t(ic).eq.prog%ival) then
             ouspec%t(ic) = prog%oval
          else
             ouspec%t(ic) = inspec%t(ic)
          endif
       end do
       call ouspec%put(prog%replace,ie,error)
       if (error) return
    enddo ! ie
  end subroutine cubemain_replace_prog_spectrum_loop_real
  !
end module cubemain_replace
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
