subroutine rmask_to_list(rmask,m,list,n)
  !---------------------------------------------------
  ! @ public
  !   Get list of positions from a Real mask.
  !---------------------------------------------------
  integer, intent(in) :: m  ! Number of entries
  real, intent(in) :: rmask(m)  ! Mask values
  integer, intent(out) :: n  ! Number of TRUE values
  integer, intent(out) :: list(m) ! Position of entries 
  ! 
  integer i,j
  !
  j = 0
  do i=1,m
    if (rmask(i).gt.0) then
      j = j+1
      list(j) = i
    endif
  enddo
  n = j
  do i=n+1,m
    list(i) = 0
  enddo
end subroutine rmask_to_list
!
subroutine lmask_to_list(lmask,m,list,n)
  !---------------------------------------------------
  ! @ public
  !   Get list of positions from a Logical mask.
  !---------------------------------------------------
  integer, intent(in) :: m  ! Number of entries
  logical, intent(in) :: lmask(m)  ! Mask values
  integer, intent(out) :: n  ! Number of TRUE values
  integer, intent(out) :: list(m) ! Position of entries 
  ! 
  integer i,j
  !
  j = 0
  do i=1,m
    if (lmask(i)) then
      j = j+1
      list(j) = i
    endif
  enddo
  n = j
  do i=n+1,m
    list(i) = 0
  enddo
end subroutine lmask_to_list
!
subroutine get_listsize (mask,m,n)
  !---------------------------------------------------
  ! @ public
  !   Count number of TRUE values
  !---------------------------------------------------
  integer, intent(in) :: m  ! Number of entries
  integer, intent(out) :: n ! Number of TRUE values
  logical, intent(in) :: mask(m)  ! Mask values
  !
  integer i
  !
  n = 0
  do i=1,m
    if (mask(i)) n = n+1
  enddo
end subroutine get_listsize
!
subroutine get_listindex(mask,m,list,n)
  !---------------------------------------------------
  ! @ public
  !   Get list of positions in mask.
  !---------------------------------------------------
  integer, intent(in) :: m  ! Number of entries
  integer, intent(in) :: n  ! Number of TRUE values
  logical, intent(in) :: mask(m)  ! Mask values
  integer, intent(out) :: list(n) ! Position of entries 
  ! 
  integer i,j
  !
  j = 0
  do i=1,m
    if (mask(i)) then
      j = j+1
      list(j) = i
    endif
  enddo
  do i=j+1,n
    list(i) = 0
  enddo
end subroutine get_listindex
!
subroutine set_weight(nx,ny,np,weight,primary,mask,   &
     &    wsear,wrest,wmin)
  use gbl_message
  !---------------------------------------------------
  ! @ public
  !   Set the mosaic weights
  !---------------------------------------------------
  integer, intent(in) :: nx  ! X size
  integer, intent(in) :: ny  ! Y size 
  integer, intent(in) :: np  ! Number of pointings
  real, intent(out) ::  weight(nx,ny)     ! Weight map
  real, intent(in) ::  primary(np,nx,ny)  ! Primary beams
  real, intent(in) ::  wsear              ! Search threshold
  real, intent(in) ::  wrest              ! Restore threshold   
  real, intent(in) ::  wmin               ! Minimum beal value  
  logical, intent(inout) ::  mask(nx,ny)  ! Search mask
  !
  real wr,ws2,wr2
  integer i,j,ip
  character(len=80) :: chain
  !
  write(chain,'(A,1pg10.3,1x,1pg10.3,1x,1pg10.3)') &
      &   'Thresholds ',wsear,wrest,wmin
  call map_message(seve%i,'CLEAN',chain)
  wr2 = wrest                  !*WREST
  ws2 = wsear
  !
  ! Compute the "weigt" function 1/N
  do j=1,ny
    do i=1,nx
      wr = 0.0
      do ip=1,np
        if (primary(ip,i,j).gt.wmin) then
          wr = wr+primary(ip,i,j)*primary(ip,i,j)
        endif
      enddo
      ! Cut the search mask
      if (wr.le.ws2) mask(i,j) = .false.
      ! Cut the restore area if it is not a search area also
      if (wr.le.wr2 .and. .not.mask(i,j)) wr = 0.0
      ! Convert to the 1/N function
      if (wr.ne.0.0) then
        weight(i,j) = 1.0/sqrt(wr)
      else
        weight(i,j) = 0.0
      endif
    enddo
  enddo
end subroutine set_weight
!
subroutine cmplx_mul (out,in,n)
  use gildas_def
  !----------------------------------------------
  ! @ no-interface
  !   Complex multiplication
  !-----------------------------------------------
  integer(kind=size_length), intent(in) :: n     !
  real, intent(out) :: out(2,n)                  !
  real, intent(in) :: in(2,n)                    !
  ! Local
  integer(kind=size_length) :: i
  real ar,ai
  do i=1,n
    ar = in(1,i)*out(1,i)-in(2,i)*out(2,i)
    ai = in(1,i)*out(2,i)+in(2,i)*out(1,i)
    out(1,i) = ar
    out(2,i) = ai
  enddo
end subroutine cmplx_mul
!
subroutine check_box(nx,ny,blc,trc)
  !----------------------------------------------
  ! @ public
  !   Define default search box corners
  !-----------------------------------------------
  integer, intent(in) :: nx,ny
  integer, intent(out) :: blc(2)
  integer, intent(out) :: trc(2)
  !
  ! Check inner quarter if not specified
  if (blc(1).eq.0) then
    blc(1) = nx/4+1
  else
    blc(1) = max(blc(1),1)
  endif
  if (blc(2).eq.0) then
    blc(2) = ny/4+1
  else
    blc(2) = max(blc(2),1)
  endif
  if (trc(1).eq.0) then
    trc(1) = 3*nx/4
  else
    trc(1) = min(trc(1),nx)
  endif
  if (trc(2).eq.0) then
    trc(2) = 3*ny/4
  else
    trc(2) = min(trc(2),ny)
  endif
end subroutine check_box
