/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.thread.AtomicIntegerAdapter;
import org.testng.internal.thread.ExecutorAdapter;
import org.testng.internal.thread.IAtomicInteger;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IThreadFactory;
import org.testng.internal.thread.TestNGThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadUtil {
    private static final String THREAD_NAME = "TestNG";

    public static boolean isTestNGThread() {
        return Thread.currentThread().getName().contains(THREAD_NAME);
    }

    public static final void execute(List<? extends Runnable> tasks, int threadPoolSize, long timeout, boolean triggerAtOnce) {
        CountDownLatch startGate = new CountDownLatch(1);
        CountDownLatch endGate = new CountDownLatch(tasks.size());
        Utils.log("TestRunner", 2, "Starting executor timeOut:" + timeout + "ms" + " workers:" + tasks.size() + " threadPoolSize:" + threadPoolSize);
        ThreadPoolExecutor pooledExecutor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, timeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread result = new Thread(r);
                result.setName(ThreadUtil.THREAD_NAME);
                return result;
            }
        });
        for (Runnable runnable : tasks) {
            try {
                pooledExecutor.execute(new CountDownLatchedRunnable(runnable, endGate, triggerAtOnce ? null : startGate));
            }
            catch (RejectedExecutionException reex) {}
        }
        try {
            startGate.countDown();
            endGate.await();
            pooledExecutor.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ThreadUtil.log(2, "Error waiting for concurrent executors to finish " + e.getMessage());
        }
    }

    public static final String currentThreadInfo() {
        Thread thread = Thread.currentThread();
        return String.valueOf(thread.getName() + "@" + thread.hashCode());
    }

    public static final IExecutor createExecutor(int threadCount, String threadFactoryName) {
        return new ExecutorAdapter(threadCount, ThreadUtil.createFactory(threadFactoryName));
    }

    public static final IAtomicInteger createAtomicInteger(int initialValue) {
        return new AtomicIntegerAdapter(initialValue);
    }

    private static final IThreadFactory createFactory(String name) {
        return new ThreadFactoryImpl(name);
    }

    private static void log(int level, String msg) {
        Utils.log("ThreadUtil:" + ThreadUtil.currentThreadInfo(), level, msg);
    }

    private static class CountDownLatchedRunnable
    implements Runnable {
        private final Runnable m_task;
        private final CountDownLatch m_startGate;
        private final CountDownLatch m_endGate;

        public CountDownLatchedRunnable(Runnable task, CountDownLatch endGate, CountDownLatch startGate) {
            this.m_task = task;
            this.m_startGate = startGate;
            this.m_endGate = endGate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (null != this.m_startGate) {
                try {
                    this.m_startGate.await();
                }
                catch (InterruptedException iex) {
                    ThreadUtil.log(2, "Cannot wait for startup gate when executing " + this.m_task + "; thread was already interrupted " + iex.getMessage());
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            try {
                this.m_task.run();
                Object var3_2 = null;
                this.m_endGate.countDown();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_endGate.countDown();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadFactoryImpl
    implements IThreadFactory,
    ThreadFactory {
        private String m_methodName;
        private List<Thread> m_threads = Lists.newArrayList();

        public ThreadFactoryImpl(String name) {
            this.m_methodName = name;
        }

        @Override
        public Thread newThread(Runnable run) {
            TestNGThread result = new TestNGThread(run, this.m_methodName);
            this.m_threads.add(result);
            return result;
        }

        @Override
        public Object getThreadFactory() {
            return this;
        }

        @Override
        public List<Thread> getThreads() {
            return this.m_threads;
        }
    }
}

