/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;

public final class JsBooleanLiteral
extends JsLiteral.JsValueLiteral {
    private final boolean value;

    public JsBooleanLiteral(boolean value) {
        this.value = value;
    }

    public static boolean isTrue(@NotNull JsExpression expression2) {
        return expression2 instanceof JsBooleanLiteral && ((JsBooleanLiteral)expression2).getValue();
    }

    public static boolean isFalse(@NotNull JsExpression expression2) {
        return expression2 instanceof JsBooleanLiteral && !((JsBooleanLiteral)expression2).getValue();
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitBoolean(this);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        v.visit(this, ctx);
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsBooleanLiteral deepCopy() {
        return new JsBooleanLiteral(this.value).withMetadataFrom(this);
    }
}

