/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;

public class DefaultPluginRequest
implements PluginRequestInternal {
    private final PluginId id;
    private final String version;
    private final boolean apply;
    private final Integer lineNumber;
    private final String scriptDisplayName;
    private final ModuleVersionSelector artifact;
    private final PluginRequestInternal originalRequest;

    public DefaultPluginRequest(PluginId id, String version, boolean apply, Integer lineNumber, ScriptSource scriptSource) {
        this(id, version, apply, lineNumber, scriptSource.getDisplayName(), null);
    }

    public DefaultPluginRequest(String id, String version, boolean apply, Integer lineNumber, String scriptDisplayName) {
        this(DefaultPluginId.of(id), version, apply, lineNumber, scriptDisplayName, null);
    }

    public DefaultPluginRequest(PluginId id, String version, boolean apply, Integer lineNumber, String scriptDisplayName, ModuleVersionSelector artifact) {
        this(id, version, apply, lineNumber, scriptDisplayName, artifact, null);
    }

    public DefaultPluginRequest(PluginId id, String version, boolean apply, Integer lineNumber, String scriptDisplayName, ModuleVersionSelector artifact, PluginRequestInternal originalRequest) {
        this.id = id;
        this.version = version;
        this.apply = apply;
        this.lineNumber = lineNumber;
        this.scriptDisplayName = scriptDisplayName;
        this.artifact = artifact;
        this.originalRequest = originalRequest != null ? originalRequest : this;
    }

    public PluginId getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public ModuleVersionSelector getModule() {
        return this.artifact;
    }

    public boolean isApply() {
        return this.apply;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getScriptDisplayName() {
        return this.scriptDisplayName;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[id: '").append(this.id).append("'");
        if (this.version != null) {
            b.append(", version: '").append(this.version).append("'");
        }
        if (this.artifact != null) {
            b.append(", artifact: '").append(this.artifact).append("'");
        }
        if (!this.apply) {
            b.append(", apply: false");
        }
        b.append("]");
        return b.toString();
    }

    public String getDisplayName() {
        return this.toString();
    }

    public PluginRequestInternal getOriginalRequest() {
        return this.originalRequest;
    }
}

