/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Checksum;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.internal.LimitedDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFileUtils {
    public static FileInputStream openInputStream(File file) {
        try {
            return FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Problems opening file input stream for file: " + file, e);
        }
    }

    public static void touch(File file) {
        try {
            if (!file.createNewFile()) {
                GFileUtils.touchExisting(file);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void touchExisting(File file) {
        if (!file.setLastModified(System.currentTimeMillis())) {
            throw new UncheckedIOException("Could not update time stamp for " + file);
        }
    }

    public static void moveFile(File source, File destination) {
        try {
            FileUtils.moveFile((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void moveExistingFile(File source, File destination) {
        boolean rename = source.renameTo(destination);
        if (!rename) {
            GFileUtils.moveFile(source, destination);
        }
    }

    public static void copyFile(File source, File destination) {
        try {
            FileUtils.copyFile((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyDirectory(File source, File destination) {
        try {
            FileUtils.copyDirectory((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void moveDirectory(File source, File destination) {
        try {
            FileUtils.moveDirectory((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void moveExistingDirectory(File source, File destination) {
        boolean rename = source.renameTo(destination);
        if (!rename) {
            GFileUtils.moveDirectory(source, destination);
        }
    }

    public static String readFile(File file) {
        return GFileUtils.readFile(file, Charset.defaultCharset().name());
    }

    public static String readFile(File file, String encoding) {
        try {
            return FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String readFileQuietly(File file) {
        try {
            return GFileUtils.readFile(file);
        }
        catch (Exception e) {
            return "Unable to read file '" + file + "' due to: " + e.toString();
        }
    }

    public static void writeFile(String content, File destination) {
        GFileUtils.writeFile(content, destination, Charset.defaultCharset().name());
    }

    public static void writeFile(String content, File destination, String encoding) {
        try {
            FileUtils.writeStringToFile((File)destination, (String)content, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Collection<File> listFiles(File directory, String[] extensions, boolean recursive) {
        return FileUtils.listFiles((File)directory, (String[])extensions, (boolean)recursive);
    }

    public static List<String> toPaths(Collection<File> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        return paths;
    }

    public static void copyURLToFile(URL source, File destination) {
        try {
            FileUtils.copyURLToFile((URL)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void deleteDirectory(File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void cleanDirectory(File directory) {
        try {
            FileUtils.cleanDirectory((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean deleteQuietly(@Nullable File file) {
        return FileUtils.deleteQuietly((File)file);
    }

    public static boolean deleteFileQuietly(@Nullable File file) {
        if (file != null) {
            return file.delete();
        }
        return false;
    }

    public static String tail(File file, int maxLines) throws TailReadingException {
        String string;
        BufferedReader reader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            LimitedDescription description = new LimitedDescription(maxLines);
            String line = reader.readLine();
            while (line != null) {
                description.append(line);
                line = reader.readLine();
            }
            string = description.toString();
            Object var8_8 = null;
        }
        catch (Exception e) {
            try {
                throw new TailReadingException(e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                IOUtils.closeQuietly((Reader)fileReader);
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    public static void writeStringToFile(File file, String data) {
        try {
            FileUtils.writeStringToFile((File)file, (String)data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void forceDelete(File file) {
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Checksum checksum(File file, Checksum checksum) {
        try {
            return FileUtils.checksum((File)file, (Checksum)checksum);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File parentMkdirs(File child) {
        File parent = child.getParentFile();
        GFileUtils.mkdirs(parent);
        return parent;
    }

    public static void mkdirs(File dir) {
        if ((dir = dir.getAbsoluteFile()).isDirectory()) {
            return;
        }
        if (dir.exists() && !dir.isDirectory()) {
            throw new UncheckedIOException(String.format("Cannot create directory '%s' as it already exists, but is not a directory", dir));
        }
        LinkedList<File> toCreate = new LinkedList<File>();
        File parent = dir.getParentFile();
        while (!parent.exists()) {
            toCreate.add(parent);
            parent = parent.getParentFile();
        }
        Collections.reverse(toCreate);
        for (File parentDirToCreate : toCreate) {
            if (parentDirToCreate.isDirectory()) continue;
            File parentDirToCreateParent = parentDirToCreate.getParentFile();
            if (!parentDirToCreateParent.isDirectory()) {
                throw new UncheckedIOException(String.format("Cannot create parent directory '%s' when creating directory '%s' as '%s' is not a directory", parentDirToCreate, dir, parentDirToCreateParent));
            }
            if (parentDirToCreate.mkdir() || parentDirToCreate.isDirectory()) continue;
            throw new UncheckedIOException(String.format("Failed to create parent directory '%s' when creating directory '%s'", parentDirToCreate, dir));
        }
        if (!dir.mkdir() && !dir.isDirectory()) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", dir));
        }
    }

    public static class TailReadingException
    extends RuntimeException {
        public TailReadingException(Throwable throwable) {
            super(throwable);
        }
    }
}

