/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerServer;
import org.gradle.workers.internal.TransportableActionExecutionSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerProtocol;

public abstract class AbstractClassLoaderWorker
implements Worker {
    private final WorkerProtocol worker;

    public AbstractClassLoaderWorker(ServiceRegistry serviceRegistry) {
        this.worker = new DefaultWorkerServer(serviceRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultWorkResult executeInClassLoader(ActionExecutionSpec spec, ClassLoader workerClassLoader) {
        ClassLoader previousContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(workerClassLoader);
            TransportableActionExecutionSpec transportableSpec = TransportableActionExecutionSpec.from(spec);
            ActionExecutionSpec effectiveSpec = transportableSpec.deserialize(workerClassLoader);
            DefaultWorkResult defaultWorkResult = this.worker.execute(effectiveSpec);
            return defaultWorkResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextLoader);
        }
    }
}

