/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractCollectionProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.state.Managed;

public class DefaultListProperty<T>
extends AbstractCollectionProperty<T, List<T>>
implements ListProperty<T> {
    public DefaultListProperty(Class<T> elementType) {
        super(List.class, elementType);
    }

    @Override
    public Class<?> publicType() {
        return ListProperty.class;
    }

    @Override
    public Managed.Factory managedFactory() {
        return new Managed.Factory(){

            @Nullable
            public <S> S fromState(Class<S> type, Object state) {
                if (!type.isAssignableFrom(ListProperty.class)) {
                    return null;
                }
                DefaultListProperty property = new DefaultListProperty(DefaultListProperty.this.getElementType());
                property.set((List)state);
                return type.cast(property);
            }
        };
    }

    @Override
    protected List<T> fromValue(Collection<T> values) {
        return ImmutableList.copyOf(values);
    }

    @Override
    public ListProperty<T> empty() {
        super.empty();
        return this;
    }

    @Override
    public ListProperty<T> convention(Iterable<? extends T> elements) {
        super.convention(elements);
        return this;
    }

    @Override
    public ListProperty<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        super.convention(provider);
        return this;
    }
}

