/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;

public class ClassDependentsAccumulator {
    private final Set<String> dependenciesToAll = Sets.newHashSet();
    private final Map<String, Set<String>> dependents = new HashMap<String, Set<String>>();
    private final ImmutableMap.Builder<String, IntSet> classesToConstants = ImmutableMap.builder();
    private final Set<String> seenClasses = Sets.newHashSet();
    private String fullRebuildCause;

    public void addClass(ClassAnalysis classAnalysis) {
        this.addClass(classAnalysis.getClassName(), classAnalysis.isDependencyToAll(), classAnalysis.getClassDependencies(), classAnalysis.getConstants());
    }

    public void addClass(String className, boolean dependencyToAll, Iterable<String> classDependencies, IntSet constants) {
        if (this.seenClasses.contains(className)) {
            return;
        }
        this.seenClasses.add(className);
        if (!constants.isEmpty()) {
            this.classesToConstants.put((Object)className, (Object)constants);
        }
        if (dependencyToAll) {
            this.dependenciesToAll.add(className);
            this.dependents.remove(className);
        }
        for (String dependency : classDependencies) {
            if (dependency.equals(className) || this.dependenciesToAll.contains(dependency)) continue;
            this.addDependency(dependency, className);
        }
    }

    private Set<String> rememberClass(String className) {
        HashSet d = this.dependents.get(className);
        if (d == null) {
            d = Sets.newHashSet();
            this.dependents.put(className, d);
        }
        return d;
    }

    @VisibleForTesting
    Map<String, DependentsSet> getDependentsMap() {
        if (this.dependenciesToAll.isEmpty() && this.dependents.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String string : this.dependenciesToAll) {
            builder.put((Object)string, (Object)DependentsSet.dependencyToAll());
        }
        for (Map.Entry entry : this.dependents.entrySet()) {
            builder.put((Object)((String)entry.getKey()), (Object)DependentsSet.dependentClasses((Set)entry.getValue()));
        }
        return builder.build();
    }

    @VisibleForTesting
    Map<String, IntSet> getClassesToConstants() {
        return this.classesToConstants.build();
    }

    private void addDependency(String dependency, String dependent) {
        Set<String> dependents = this.rememberClass(dependency);
        dependents.add(dependent);
    }

    public void fullRebuildNeeded(String fullRebuildCause) {
        this.fullRebuildCause = fullRebuildCause;
    }

    public ClassSetAnalysisData getAnalysis() {
        return new ClassSetAnalysisData((Set<String>)ImmutableSet.copyOf(this.seenClasses), this.getDependentsMap(), this.getClassesToConstants(), this.fullRebuildCause);
    }

    private static <K, V> Map<K, Set<V>> asMap(Multimap<K, V> multimap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object key : multimap.keySet()) {
            builder.put(key, (Object)ImmutableSet.copyOf((Collection)multimap.get(key)));
        }
        return builder.build();
    }
}

