/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.collections.ArchiveFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.GeneratedSingletonFileTree;
import org.gradle.api.internal.file.collections.LocalFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

public class FileTreeAdapter
extends AbstractFileTree
implements FileCollectionContainer {
    private final MinimalFileTree tree;

    public FileTreeAdapter(MinimalFileTree tree) {
        this.tree = tree;
    }

    public FileTreeAdapter(MinimalFileTree tree, Factory<PatternSet> patternSetFactory) {
        super(patternSetFactory);
        this.tree = tree;
    }

    public MinimalFileTree getTree() {
        return this.tree;
    }

    @Override
    public String getDisplayName() {
        return this.tree.getDisplayName();
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        context.add(this.tree);
    }

    @Override
    protected Collection<DirectoryFileTree> getAsFileTrees() {
        if (this.tree instanceof FileSystemMirroringFileTree) {
            FileSystemMirroringFileTree mirroringTree = (FileSystemMirroringFileTree)this.tree;
            if (this.visitAll()) {
                return Collections.singletonList(mirroringTree.getMirror());
            }
            return Collections.emptyList();
        }
        if (this.tree instanceof LocalFileTree) {
            LocalFileTree fileTree = (LocalFileTree)this.tree;
            return fileTree.getLocalContents();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert %s to local file system directories.", this.tree));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        if (this.tree instanceof Buildable) {
            context.add((Object)this.tree);
        }
    }

    @Override
    public boolean contains(File file) {
        if (this.tree instanceof RandomAccessFileCollection) {
            RandomAccessFileCollection randomAccess = (RandomAccessFileCollection)((Object)this.tree);
            return randomAccess.contains(file);
        }
        if (this.tree instanceof GeneratedSingletonFileTree) {
            return ((GeneratedSingletonFileTree)this.tree).getFileWithoutCreating().equals(file);
        }
        if (this.tree instanceof FileSystemMirroringFileTree) {
            return ((FileSystemMirroringFileTree)this.tree).getMirror().contains(file);
        }
        return super.contains(file);
    }

    @Override
    public FileTree matching(PatternFilterable patterns) {
        if (this.tree instanceof PatternFilterableFileTree) {
            PatternFilterableFileTree filterableTree = (PatternFilterableFileTree)this.tree;
            return new FileTreeAdapter(filterableTree.filter(patterns), (Factory<PatternSet>)this.patternSetFactory);
        }
        return super.matching(patterns);
    }

    public FileTree visit(FileVisitor visitor) {
        this.tree.visit(visitor);
        return this;
    }

    @Override
    public void visitStructure(FileCollectionStructureVisitor visitor) {
        if (this.tree instanceof GeneratedSingletonFileTree) {
            GeneratedSingletonFileTree singletonFileTree = (GeneratedSingletonFileTree)this.tree;
            if (visitor.prepareForVisit(singletonFileTree) == FileCollectionStructureVisitor.VisitType.NoContents) {
                visitor.visitCollection(singletonFileTree, Collections.emptyList());
            } else {
                visitor.visitFileTree(singletonFileTree.getFile(), singletonFileTree.getPatterns(), this);
            }
            return;
        }
        if (visitor.prepareForVisit(OTHER) == FileCollectionStructureVisitor.VisitType.NoContents) {
            return;
        }
        if (this.tree instanceof DirectoryFileTree) {
            DirectoryFileTree directoryFileTree = (DirectoryFileTree)this.tree;
            visitor.visitFileTree(directoryFileTree.getDir(), directoryFileTree.getPatterns(), this);
        } else if (this.tree instanceof SingletonFileTree) {
            SingletonFileTree singletonFileTree = (SingletonFileTree)this.tree;
            visitor.visitFileTree(singletonFileTree.getFile(), singletonFileTree.getPatterns(), this);
        } else if (this.tree instanceof ArchiveFileTree) {
            ArchiveFileTree archiveFileTree = (ArchiveFileTree)this.tree;
            File backingFile = archiveFileTree.getBackingFile();
            if (backingFile != null) {
                visitor.visitFileTreeBackedByFile(backingFile, this);
            } else {
                visitor.visitGenericFileTree(this);
            }
        } else {
            visitor.visitGenericFileTree(this);
        }
    }
}

