/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.resolve.FirProvider;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerStage;
import org.jetbrains.kotlin.fir.symbols.ConeCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeSymbol;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckVisibility;", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/symbols/ConeSymbol;", "resolve"})
public final class CheckVisibility
extends CheckerStage {
    public static final CheckVisibility INSTANCE;

    private final FqName packageFqName(@NotNull ConeSymbol $this$packageFqName) {
        FqName fqName2;
        ConeSymbol coneSymbol = $this$packageFqName;
        if (coneSymbol instanceof ConeClassLikeSymbol) {
            FqName fqName3 = ((ConeClassLikeSymbol)$this$packageFqName).getClassId().getPackageFqName();
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"classId.packageFqName");
        } else if (coneSymbol instanceof ConeCallableSymbol) {
            fqName2 = ((ConeCallableSymbol)$this$packageFqName).getCallableId().getPackageName();
        } else {
            String string = "No package fq name for " + $this$packageFqName;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return fqName2;
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CheckerSink sink, @NotNull CallInfo callInfo, @NotNull Continuation<? super Unit> $completion) {
        FirBasedSymbol<?> symbol2 = candidate2.getSymbol();
        Object declaration2 = symbol2.getFir();
        if (declaration2 instanceof FirMemberDeclaration && !((FirMemberDeclaration)declaration2).getVisibility().isPublicAPI()) {
            boolean visible;
            boolean bl;
            Visibility visibility = ((FirMemberDeclaration)declaration2).getVisibility();
            if (Intrinsics.areEqual((Object)visibility, (Object)JavaVisibilities.PACKAGE_VISIBILITY)) {
                bl = Intrinsics.areEqual((Object)this.packageFqName(symbol2), (Object)callInfo.getContainingFile().getPackageFqName());
            } else if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PRIVATE) || Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PRIVATE_TO_THIS)) {
                if (Intrinsics.areEqual((Object)declaration2.getSession(), (Object)callInfo.getSession())) {
                    FirSession $this$service$iv = callInfo.getSession();
                    boolean $i$f$service = false;
                    FirProvider provider = (FirProvider)$this$service$iv.getService(Reflection.getOrCreateKotlinClass(FirProvider.class));
                    FirBasedSymbol<?> firBasedSymbol = symbol2;
                    FirFile candidateFile = firBasedSymbol instanceof ConeCallableSymbol ? provider.getFirCallableContainerFile((ConeCallableSymbol)((Object)symbol2)) : (firBasedSymbol instanceof ConeClassLikeSymbol ? provider.getFirClassifierContainerFile(((ConeClassLikeSymbol)((Object)symbol2)).getClassId()) : null);
                    bl = Intrinsics.areEqual((Object)candidateFile, (Object)callInfo.getContainingFile());
                } else {
                    bl = false;
                }
            } else {
                bl = visible = Intrinsics.areEqual((Object)visibility, (Object)Visibilities.INTERNAL) ? Intrinsics.areEqual((Object)declaration2.getSession(), (Object)callInfo.getSession()) : true;
            }
            if (!visible) {
                return sink.yieldApplicability(CandidateApplicability.HIDDEN, $completion);
            }
        }
        return Unit.INSTANCE;
    }

    private CheckVisibility() {
    }

    static {
        CheckVisibility checkVisibility;
        INSTANCE = checkVisibility = new CheckVisibility();
    }
}

