/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableBiMap;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactoryKt;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UnsignedErrorValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.UnsignedValueConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ParseUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ff\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u000e\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001lB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J(\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J*\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001c\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001e\u0018\u00010\u001d2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0002J*\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J&\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J&\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00032\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010*2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u001e\u00103\u001a\u0004\u0018\u00010*2\n\u00104\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003J*\u00106\u001a\u0004\u0018\u00010\u00172\u0006\u00107\u001a\u00020*2\u0006\u00101\u001a\u00020*2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0013H\u0002J(\u0010;\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010:\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002J\"\u0010=\u001a\u0004\u0018\u00010\u00172\u0006\u00107\u001a\u00020*2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0013H\u0002J\u001a\u0010>\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0017\u0018\u00010-2\u0006\u0010?\u001a\u00020\u0003H\u0002J\u001a\u0010@\u001a\u00020\u00112\u0006\u00108\u001a\u0002092\b\u00101\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010E\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u001e2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\u001e2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010I\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010J\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010K\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020L2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010M\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020N2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010O\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020P2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010Q\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020R2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010S\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020T2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010U\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020V2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010W\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010X\u001a\u00020Y2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020[2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\\\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020]2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010^\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020_2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010`\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020a2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016Jd\u0010f\u001a\b\u0012\u0004\u0012\u0002Hg0\u001d\"\u0004\b\u0000\u0010g*\b\u0012\u0004\u0012\u0002Hg0\u001f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010h\u001a\u00020\u00112\b\b\u0002\u0010i\u001a\u00020\u00112\b\b\u0002\u0010j\u001a\u00020\u00112\b\b\u0002\u0010J\u001a\u00020\u00112\b\b\u0002\u0010I\u001a\u00020\u00112\b\b\u0002\u0010k\u001a\u00020\u0011H\u0002J&\u0010f\u001a\b\u0012\u0004\u0012\u0002Hg0\u001d\"\u0004\b\u0000\u0010g*\b\u0012\u0004\u0012\u0002Hg0\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/types/KotlinType;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "stringExpressionEvaluator", "org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1;", "canBeUsedInAnnotation", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkAccessibilityOfUnsignedTypes", "createCompileTimeConstant", "value", "", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "expectedType", "createConstant", "createConstantValueForArrayFunctionCall", "Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "createConstantValueForUnsignedTypeConstructor", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createIntegerCompileTimeConstant", "", "createOperationArgument", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "parameterType", "compileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "createOperationArgumentForFirstParameter", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createOperationArgumentForReceiver", "resolvedCall", "evaluate", "evaluateBinaryAndCheck", "receiver", "name", "", "callExpression", "evaluateCall", "receiverExpression", "evaluateUnaryAndCheck", "getCompileTimeType", "c", "isDivisionByZero", "isPropertyCompileTimeConstant", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "isPureConstant", "isStandaloneOnlyConstant", "resolveArguments", "valueArguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "usesNonConstValAsConstant", "usesVariableAsConstant", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitCollectionLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "wrap", "T", "isPure", "isUnsigned", "isUnsignedLong", "isConvertableConstVal", "OperationArgument", "frontend"})
final class ConstantExpressionEvaluatorVisitor
extends KtVisitor<CompileTimeConstant<?>, KotlinType> {
    private final LanguageVersionSettings languageVersionSettings;
    private final KotlinBuiltIns builtIns;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final BindingTrace trace;

    @Nullable
    public final CompileTimeConstant<?> evaluate(@NotNull KtExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression2, bindingContext);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        KtVisitor ktVisitor = this;
        KotlinType kotlinType2 = expectedType;
        if (kotlinType2 == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
            kotlinType2 = simpleType2;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression2.accept(ktVisitor, kotlinType2);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression2, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable KotlinType expectedType) {
        boolean isIntegerConstant;
        Serializable serializable;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        String string = expression2.getText();
        if (string == null) {
            return null;
        }
        String text2 = string;
        ASTNode aSTNode = expression2.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"expression.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.node.elementType");
        IElementType nodeElementType = iElementType;
        if (Intrinsics.areEqual((Object)nodeElementType, (Object)KtNodeTypes.NULL)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, new NullValue(), false, false, false, false, false, false, false, 127, null);
        }
        IElementType iElementType2 = nodeElementType;
        if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
            serializable = ParseUtilsKt.parseNumericLiteral(text2, nodeElementType);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
            serializable = Boolean.valueOf(ParseUtilsKt.parseBoolean(text2));
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
            serializable = CompileTimeConstantChecker.parseChar(expression2);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression2);
        }
        if (serializable == null) {
            return null;
        }
        Serializable result2 = serializable;
        if (result2 instanceof Double) {
            double d = ((Number)result2).doubleValue();
            boolean bl = false;
            if (Double.isInfinite(d)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression2)));
            }
            if (Intrinsics.areEqual((Object)result2, (Object)0.0) && !TypeConversionUtil.isFPZero(text2)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression2)));
            }
        }
        if (result2 instanceof Float) {
            float f = ((Number)result2).floatValue();
            boolean bl = false;
            if (Float.isInfinite(f)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression2)));
            }
            if (Intrinsics.areEqual((Object)result2, (Object)Float.valueOf(0.0f)) && !TypeConversionUtil.isFPZero(text2)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression2)));
            }
        }
        boolean isUnsignedLong = (isIntegerConstant = Intrinsics.areEqual((Object)nodeElementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) && ParseUtilsKt.hasUnsignedLongSuffix(text2);
        boolean isUnsigned = isUnsignedLong || ParseUtilsKt.hasUnsignedSuffix(text2);
        boolean isTyped = isUnsigned || ParseUtilsKt.hasLongSuffix(text2);
        return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, !isTyped, isUnsigned, isUnsignedLong, false, false, false));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression2);
        if (deparenthesizedExpression != null && Intrinsics.areEqual((Object)deparenthesizedExpression, (Object)expression2) ^ true) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@NotNull KtLabeledExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @Nullable KotlinType expectedType) {
        CompileTimeConstant<?> compileTimeConstant;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        int canBeUsedInAnnotation = 1;
        boolean usesVariableAsConstant = false;
        int usesNonConstantVariableAsConstant = 0;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
        int n2 = ktStringTemplateEntryArray.length;
        for (n = 0; n < n2; ++n) {
            KtStringTemplateEntry entry;
            KtStringTemplateEntry ktStringTemplateEntry = entry = ktStringTemplateEntryArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntry, (String)"entry");
            TypedCompileTimeConstant<String> constant = this.stringExpressionEvaluator.evaluate(ktStringTemplateEntry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.getCanBeUsedInAnnotations()) {
                canBeUsedInAnnotation = 0;
            }
            if (constant.getUsesVariableAsConstant()) {
                usesVariableAsConstant = true;
            }
            if (constant.getUsesNonConstValAsConstant()) {
                usesNonConstantVariableAsConstant = 1;
            }
            sb.append(constant.getConstantValue().getValue());
        }
        if (!interupted) {
            boolean bl = false;
            n = usesNonConstantVariableAsConstant;
            boolean bl2 = usesVariableAsConstant;
            n2 = canBeUsedInAnnotation;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            compileTimeConstant = this.createConstant(sb.toString(), expectedType, new CompileTimeConstant.Parameters(n2 != 0, bl5, bl4, bl3, bl2, n != 0, bl));
        } else {
            compileTimeConstant = null;
        }
        return compileTimeConstant;
    }

    private final boolean isStandaloneOnlyConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        if (compileTimeConstant == null) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(compileTimeConstant);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left");
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression, expectedType);
        if (compileTimeConstant != null && expectedType != null && !TypeUtils.noExpectedType(expectedType)) {
            KotlinType kotlinType2;
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (compileTimeConstant2 instanceof TypedCompileTimeConstant) {
                kotlinType2 = ((TypedCompileTimeConstant)compileTimeConstant).getType();
            } else if (compileTimeConstant2 instanceof IntegerValueTypeConstant) {
                kotlinType2 = ((IntegerValueTypeConstant)compileTimeConstant).getType(expectedType);
            } else {
                throw (Throwable)new IllegalStateException("Unexpected compileTimeConstant class: " + compileTimeConstant.getClass().getCanonicalName());
            }
            KotlinType constantType = kotlinType2;
            if (!TypeUtilsKt.isSubtypeOf(constantType, expectedType)) {
                return null;
            }
        }
        return compileTimeConstant;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@NotNull KtBinaryExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left ?: return null");
        KtExpression leftExpression = ktExpression;
        IElementType iElementType = expression2.getOperationToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.operationToken");
        IElementType operationToken = iElementType;
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BOOLEAN_OPERATIONS;
        Intrinsics.checkExpressionValueIsNotNull(immutableBiMap, (String)"OperatorConventions.BOOLEAN_OPERATIONS");
        Map map2 = immutableBiMap;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (map3.containsKey(operationToken)) {
            boolean bl2;
            SimpleType simpleType2 = this.builtIns.getBooleanType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.booleanType");
            SimpleType booleanType = simpleType2;
            CompileTimeConstant<?> compileTimeConstant = this.evaluate(leftExpression, booleanType);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> leftConstant = compileTimeConstant;
            KtExpression ktExpression2 = expression2.getRight();
            if (ktExpression2 == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right ?: return null");
            KtExpression rightExpression = ktExpression2;
            CompileTimeConstant<?> compileTimeConstant2 = this.evaluate(rightExpression, booleanType);
            if (compileTimeConstant2 == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = compileTimeConstant2;
            Object leftValue = leftConstant.getValue(booleanType);
            Object rightValue = rightConstant.getValue(booleanType);
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            IElementType iElementType2 = operationToken;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.ANDAND)) {
                bl2 = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.OROR)) {
                bl2 = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl2;
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, false, false, false, leftConstant.getUsesVariableAsConstant() || rightConstant.getUsesVariableAsConstant(), leftConstant.getUsesNonConstValAsConstant() || rightConstant.getUsesNonConstValAsConstant(), false));
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
        return this.evaluateCall(ktOperationReferenceExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        ResolvedCall resolvedCall2 = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"trace.bindingContext[COL\u2026xpression] ?: return null");
        ResolvedCall resolvedCall3 = resolvedCall2;
        return this.createConstantValueForArrayFunctionCall(resolvedCall3);
    }

    /*
     * WARNING - void declaration
     */
    private final CompileTimeConstant<?> evaluateCall(KtExpression callExpression, KtExpression receiverExpression, KotlinType expectedType) {
        KtElement ktElement = callExpression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!KotlinBuiltIns.isUnderKotlinPackage(resolvedCall3.getResultingDescriptor())) {
            return null;
        }
        Name name = resolvedCall3.getResultingDescriptor().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"resolvedCall.resultingDescriptor.name");
        Name resultingDescriptorName = name;
        OperationArgument operationArgument = this.createOperationArgumentForReceiver(resolvedCall3, receiverExpression);
        if (operationArgument == null) {
            return null;
        }
        OperationArgument argumentForReceiver = operationArgument;
        if (this.isStandaloneOnlyConstant(argumentForReceiver.getExpression())) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall3.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultingDescriptorName.asString()");
            Object object = this.evaluateUnaryAndCheck(argumentForReceiver, string, callExpression);
            if (object == null) {
                return null;
            }
            Object result2 = object;
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, !isNumberConversionMethod && isArgumentPure, false, false, usesVariableAsConstant, usesNonConstValAsConstant, false));
        }
        if (argumentsEntrySet.size() == 1) {
            CompileTimeConstant compileTimeConstant;
            void parameter;
            ResolvedValueArgument argument;
            Map.Entry canBeUsedInAnnotation;
            Map.Entry usesVariableAsConstant = canBeUsedInAnnotation = (Map.Entry)CollectionsKt.first((Iterable)argumentsEntrySet);
            boolean usesNonConstValAsConstant = false;
            ValueParameterDescriptor result2 = (ValueParameterDescriptor)usesVariableAsConstant.getKey();
            usesVariableAsConstant = canBeUsedInAnnotation;
            usesNonConstValAsConstant = false;
            ResolvedValueArgument resolvedValueArgument = argument = (ResolvedValueArgument)usesVariableAsConstant.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"argument");
            void v8 = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"parameter");
            OperationArgument operationArgument2 = this.createOperationArgumentForFirstParameter(resolvedValueArgument, (ValueParameterDescriptor)v8);
            if (operationArgument2 == null) {
                return null;
            }
            OperationArgument argumentForParameter = operationArgument2;
            if (this.isStandaloneOnlyConstant(argumentForParameter.getExpression())) {
                return null;
            }
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultingDescriptorName.asString()");
            if (this.isDivisionByZero(string, argumentForParameter.getValue())) {
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)receiverExpression, KtExpression.class);
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KtExpression parentExpression = ktExpression;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((KtExpression)((PsiElement)parentExpression)));
                if (ConstantExpressionEvaluatorKt.isIntegerType(argumentForReceiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(argumentForParameter.getValue()) || !this.languageVersionSettings.supportsFeature(LanguageFeature.DivisionByZeroInConstantExpressions)) {
                    return ConstantExpressionEvaluatorVisitor.wrap$default(this, ErrorValue.Companion.create("Division by zero"), false, false, false, false, false, false, false, 127, null);
                }
            }
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resultingDescriptorName.asString()");
            Object object = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string2, callExpression);
            if (object == null) {
                return null;
            }
            Object result3 = object;
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(argumentForParameter.getExpression());
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(argumentForParameter.getExpression());
            boolean usesVariableAsConstant2 = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(argumentForParameter.getExpression());
            boolean usesNonConstValAsConstant2 = this.usesNonConstValAsConstant(argumentForReceiver.getExpression()) || this.usesNonConstValAsConstant(argumentForParameter.getExpression());
            CompileTimeConstant.Parameters parameters2 = new CompileTimeConstant.Parameters(canBeUsedInAnnotation2, areArgumentsPure, false, false, usesVariableAsConstant2, usesNonConstValAsConstant2, false);
            Name name2 = resultingDescriptorName;
            if (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.COMPARE_TO)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForCompareTo(result3, callExpression);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else if (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForEquals(result3, callExpression);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else {
                compileTimeConstant = this.createConstant(result3, expectedType, parameters2);
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean usesVariableAsConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesVariableAsConstant() : false;
    }

    private final boolean usesNonConstValAsConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesNonConstValAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getCanBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.isPure() : false;
    }

    private final Object evaluateUnaryAndCheck(OperationArgument receiver, String name, KtExpression callExpression) {
        return ConstantExpressionEvaluatorKt.access$evaluateUnaryAndCheck(name, receiver.getCtcType(), receiver.getValue(), (Function0)new Function0<Unit>(this, callExpression){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;
            final /* synthetic */ KtExpression $callExpression;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$getStrictParentOfType$iv;
                PsiElement psiElement = this.$callExpression;
                DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
                BindingTrace bindingTrace = ConstantExpressionEvaluatorVisitor.access$getTrace$p(this.this$0);
                boolean $i$f$getStrictParentOfType = false;
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtExpression.class, true);
                KtExpression ktExpression2 = ktExpression;
                if (ktExpression2 == null) {
                    ktExpression2 = this.$callExpression;
                }
                bindingTrace.report(diagnosticFactory0.on((KtExpression)((PsiElement)ktExpression2)));
            }
            {
                this.this$0 = constantExpressionEvaluatorVisitor;
                this.$callExpression = ktExpression;
                super(0);
            }
        });
    }

    private final Object evaluateBinaryAndCheck(OperationArgument receiver, OperationArgument parameter, String name, KtExpression callExpression) {
        return ConstantExpressionEvaluatorKt.access$evaluateBinaryAndCheck(name, receiver.getCtcType(), receiver.getValue(), parameter.getCtcType(), parameter.getValue(), (Function0)new Function0<Unit>(this, callExpression){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;
            final /* synthetic */ KtExpression $callExpression;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$getStrictParentOfType$iv;
                PsiElement psiElement = this.$callExpression;
                DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
                BindingTrace bindingTrace = ConstantExpressionEvaluatorVisitor.access$getTrace$p(this.this$0);
                boolean $i$f$getStrictParentOfType = false;
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtExpression.class, true);
                KtExpression ktExpression2 = ktExpression;
                if (ktExpression2 == null) {
                    ktExpression2 = this.$callExpression;
                }
                bindingTrace.report(diagnosticFactory0.on((KtExpression)((PsiElement)ktExpression2)));
            }
            {
                this.this$0 = constantExpressionEvaluatorVisitor;
                this.$callExpression = ktExpression;
                super(0);
            }
        });
    }

    private final boolean isDivisionByZero(String name, Object parameter) {
        return ConstantExpressionEvaluatorKt.access$getDIVISION_OPERATION_NAMES$p().contains(name) && ConstantExpressionEvaluatorKt.access$isZero(parameter);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@NotNull KtUnaryExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.baseExpression ?: return null");
        KtExpression leftExpression = ktExpression;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.operationReference");
        return this.evaluateCall(ktSimpleNameExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable KotlinType expectedType) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassDescriptor)declarationDescriptor));
            if (classId == null) {
                return null;
            }
            ClassId enumClassId = classId;
            Name name = enumDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"enumDescriptor.name");
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, new EnumValue(enumClassId, name), false, false, false, false, false, false, false, 127, null);
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 != null && (callableDescriptor = resolvedCall2.getResultingDescriptor()) instanceof VariableDescriptor) {
            if (callableDescriptor instanceof PropertyDescriptor && ((PropertyDescriptor)callableDescriptor).getModality() != Modality.FINAL) {
                return null;
            }
            boolean isConvertableConstVal = ((VariableDescriptor)callableDescriptor).isConst() && ImplicitIntegerCoercion.INSTANCE.isEnabledForConstVal((VariableDescriptor)callableDescriptor) && ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer() instanceof IntValue;
            ConstantValue<?> constantValue = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            return constantValue != null ? this.wrap(constantValue, new CompileTimeConstant.Parameters(this.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor), false, false, false, true, !((VariableDescriptor)callableDescriptor).isConst(), isConvertableConstVal)) : null;
        }
        return null;
    }

    private final boolean isPropertyCompileTimeConstant(VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            return false;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor2)) {
            KotlinType kotlinType2 = descriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.type");
            return ConstUtilKt.canBeUsedForConstVal(kotlinType2);
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, @Nullable KotlinType expectedType) {
        CompileTimeConstant<?> result2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression selectorExpression = expression2.getSelectorExpression();
        if (selectorExpression instanceof KtCallExpression) {
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof KtSimpleNameExpression)) {
                return null;
            }
            KtExpression receiverExpression = expression2.getReceiverExpression();
            return this.evaluateCall(calleeExpression, receiverExpression, expectedType);
        }
        if (selectorExpression instanceof KtSimpleNameExpression && (result2 = this.evaluateCall(selectorExpression, expression2.getReceiverExpression(), expectedType)) != null) {
            return result2;
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@NotNull KtCallExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call2 = resolvedCall2;
        CallableDescriptor resultingDescriptor = call2.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayFunctionCall(call2)) {
            return this.createConstantValueForArrayFunctionCall(call2);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            TypedCompileTimeConstant typedCompileTimeConstant;
            ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)resultingDescriptor).getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"resultingDescriptor.constructedClass");
            ClassDescriptor classDescriptor3 = classDescriptor2;
            if (DescriptorUtils.isAnnotationClass(classDescriptor3)) {
                AnnotationDescriptorImpl descriptor2 = new AnnotationDescriptorImpl(classDescriptor3.getDefaultType(), this.constantExpressionEvaluator.resolveAnnotationArguments$frontend(call2, this.trace), SourceElement.NO_SOURCE);
                typedCompileTimeConstant = ConstantExpressionEvaluatorVisitor.wrap$default(this, new AnnotationValue(descriptor2), false, false, false, false, false, false, false, 127, null);
            } else {
                typedCompileTimeConstant = InlineClassesUtilsKt.isInlineClass(classDescriptor3) && UnsignedTypes.INSTANCE.isUnsignedClass(classDescriptor3) ? this.createConstantValueForUnsignedTypeConstructor(call2, (ConstructorDescriptor)resultingDescriptor, classDescriptor3) : null;
            }
            return typedCompileTimeConstant;
        }
        return null;
    }

    private final TypedCompileTimeConstant<?> createConstantValueForUnsignedTypeConstructor(ResolvedCall<?> call2, ConstructorDescriptor constructorDescriptor, ClassDescriptor classDescriptor2) {
        boolean bl = InlineClassesUtilsKt.isInlineClass(classDescriptor2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ConstantExpressionEvaluatorVisitor$createConstantValueForUnsignedTypeConstructor$22 = false;
            String $i$a$-assert-ConstantExpressionEvaluatorVisitor$createConstantValueForUnsignedTypeConstructor$22 = "Unsigned type should be an inline class type, but it is: " + classDescriptor2;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ConstantExpressionEvaluatorVisitor$createConstantValueForUnsignedTypeConstructor$22));
        }
        if (!constructorDescriptor.isPrimary()) {
            return null;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = call2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"call.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = map2;
        if (valueArguments.size() > 1) {
            return null;
        }
        Annotated annotated = InlineClassesUtilsKt.underlyingRepresentation(classDescriptor2);
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)annotated, (String)"classDescriptor.underlyi\u2026on()?.type ?: return null");
        Annotated underlyingType = annotated;
        Object object = (ResolvedValueArgument)CollectionsKt.singleOrNull((Iterable)valueArguments.values());
        if (object == null || (object = object.getArguments()) == null || (object = (ValueArgument)CollectionsKt.singleOrNull((List)object)) == null) {
            return null;
        }
        Object argument = object;
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(argumentExpression, (KotlinType)underlyingType);
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2 == null || (compileTimeConstant2 = compileTimeConstant2.toConstantValue((KotlinType)underlyingType)) == null) {
            return null;
        }
        CompileTimeConstant<?> evaluatedArgument = compileTimeConstant2;
        SimpleType simpleType2 = classDescriptor2.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"classDescriptor.defaultType");
        UnsignedValueConstant<?> unsignedValueConstant = ConstantValueFactory.INSTANCE.createUnsignedValue((ConstantValue<?>)((Object)evaluatedArgument), simpleType2);
        if (unsignedValueConstant == null) {
            return null;
        }
        UnsignedValueConstant<?> unsignedValue = unsignedValueConstant;
        return this.wrap((ConstantValue)unsignedValue, compileTimeConstant.getParameters());
    }

    /*
     * WARNING - void declaration
     */
    private final TypedCompileTimeConstant<List<ConstantValue<?>>> createConstantValueForArrayFunctionCall(ResolvedCall<?> call2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor;
        Object object;
        block10: {
            boolean bl7;
            Iterable $this$any$iv;
            boolean $i$f$any;
            List arguments2;
            block9: {
                Collection collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$flatMapTo$iv$iv;
                Object obj = call2.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(obj, (String)"call.resultingDescriptor");
                KotlinType kotlinType2 = obj.getReturnType();
                if (kotlinType2 == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"call.resultingDescriptor.returnType ?: return null");
                KotlinType returnType2 = kotlinType2;
                KotlinType kotlinType3 = this.builtIns.getArrayElementType(returnType2);
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"builtIns.getArrayElementType(returnType)");
                KotlinType componentType = kotlinType3;
                Iterable $this$flatMap$iv = call2.getValueArguments().values();
                boolean $i$f$flatMap22 = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ResolvedValueArgument it = (ResolvedValueArgument)element$iv$iv;
                    boolean bl8 = false;
                    ResolvedValueArgument resolvedValueArgument = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"it");
                    List<ValueArgument> list2 = resolvedValueArgument.getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.arguments");
                    Iterable list$iv$iv = this.resolveArguments(list2, componentType);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                arguments2 = (List)destination$iv$iv;
                List evaluatedArguments = CollectionsKt.filterNotNull((Iterable)arguments2);
                Iterable $i$f$flatMap22 = evaluatedArguments;
                object = ConstantValueFactory.INSTANCE;
                constantExpressionEvaluatorVisitor = this;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CompileTimeConstant bl8 = (CompileTimeConstant)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl9 = false;
                    ConstantValue constantValue = it.toConstantValue(componentType);
                    collection.add(constantValue);
                }
                collection = (List)destination$iv$iv2;
                $this$map$iv = evaluatedArguments;
                bl6 = false;
                bl5 = false;
                bl4 = false;
                bl3 = false;
                object = ((ConstantValueFactory)object).createArrayValue((List<? extends ConstantValue<?>>)collection, returnType2);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CompileTimeConstant it = (CompileTimeConstant)element$iv;
                        boolean bl10 = false;
                        if (!it.getUsesVariableAsConstant()) continue;
                        bl7 = true;
                        break block9;
                    }
                    bl7 = false;
                }
            }
            bl2 = bl7;
            $this$any$iv = arguments2;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CompileTimeConstant it = (CompileTimeConstant)element$iv;
                    boolean bl11 = false;
                    if (!(it == null || it.getUsesNonConstValAsConstant())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean bl12 = bl;
        return ConstantExpressionEvaluatorVisitor.wrap$default(constantExpressionEvaluatorVisitor, (ConstantValue)object, bl3, bl4, bl5, bl6, bl2, bl12, false, 79, null);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KotlinType kotlinType2 = this.trace.getType(expression2);
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"trace.getType(expression)!!");
        KotlinType kClassType = kotlinType2;
        if (KotlinTypeKt.isError(kClassType)) {
            return null;
        }
        ClassifierDescriptor descriptor2 = kClassType.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor) || !KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            return null;
        }
        Object object = (TypeProjection)CollectionsKt.singleOrNull(kClassType.getArguments());
        if (object == null || (object = object.getType()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"kClassType.arguments.sin\u2026ll()?.type ?: return null");
        Object type2 = object;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitTypeParametersInClassLiteralsInAnnotationArguments) && ConstantExpressionEvaluator.Companion.isTypeParameterOrArrayOfTypeParameter$frontend((KotlinType)type2)) {
            return null;
        }
        ConstantValue<?> constantValue = KClassValue.Companion.create((KotlinType)type2);
        return constantValue != null ? ConstantExpressionEvaluatorVisitor.wrap$default(this, constantValue, false, false, false, false, false, false, false, 127, null) : null;
    }

    private final List<CompileTimeConstant<?>> resolveArguments(List<? extends ValueArgument> valueArguments, KotlinType expectedType) {
        boolean bl = false;
        ArrayList constants = new ArrayList();
        for (ValueArgument valueArgument : valueArguments) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            constants.add(this.evaluate(argumentExpression, expectedType));
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitKtElement(@NotNull KtElement element, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(ResolvedCall<?> resolvedCall2, KtExpression expression2) {
        KotlinType kotlinType2 = ConstantExpressionEvaluatorKt.access$getReceiverExpressionType(resolvedCall2);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType receiverExpressionType = kotlinType2;
        CompileTimeType<? extends Object> compileTimeType = this.getCompileTimeType(receiverExpressionType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = compileTimeType;
        return this.createOperationArgument(expression2, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(ResolvedValueArgument argument, ValueParameterDescriptor parameter) {
        KotlinType kotlinType2 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"parameter.type");
        CompileTimeType<? extends Object> compileTimeType = this.getCompileTimeType(kotlinType2);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType<? extends Object> argumentCompileTimeType = compileTimeType;
        List<ValueArgument> list2 = argument.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"argument.arguments");
        List<ValueArgument> arguments2 = list2;
        if (arguments2.size() != 1) {
            return null;
        }
        KtExpression ktExpression = ((ValueArgument)CollectionsKt.first(arguments2)).getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType kotlinType3 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"parameter.type");
        return this.createOperationArgument(argumentExpression, kotlinType3, argumentCompileTimeType);
    }

    private final CompileTimeType<? extends Object> getCompileTimeType(KotlinType c) {
        KotlinType kotlinType2 = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getIntType()) ? ConstantExpressionEvaluatorKt.getINT() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getByteType()) ? ConstantExpressionEvaluatorKt.getBYTE() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getShortType()) ? ConstantExpressionEvaluatorKt.getSHORT() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getLongType()) ? ConstantExpressionEvaluatorKt.getLONG() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getDoubleType()) ? ConstantExpressionEvaluatorKt.getDOUBLE() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getFloatType()) ? ConstantExpressionEvaluatorKt.getFLOAT() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getCharType()) ? ConstantExpressionEvaluatorKt.getCHAR() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getBooleanType()) ? ConstantExpressionEvaluatorKt.getBOOLEAN() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getStringType()) ? ConstantExpressionEvaluatorKt.getSTRING() : (Intrinsics.areEqual((Object)kotlinType2, (Object)this.builtIns.getAnyType()) ? ConstantExpressionEvaluatorKt.getANY() : null)))))))));
    }

    private final OperationArgument createOperationArgument(KtExpression expression2, KotlinType parameterType, CompileTimeType<?> compileTimeType) {
        CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(expression2, this.trace, parameterType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2 instanceof TypedCompileTimeConstant && !TypeUtilsKt.isSubtypeOf(((TypedCompileTimeConstant)compileTimeConstant2).getType(), parameterType)) {
            return null;
        }
        Object obj = compileTimeConstant2.getValue(parameterType);
        if (obj == null) {
            return null;
        }
        Object evaluationResult = obj;
        return new OperationArgument(evaluationResult, compileTimeType, expression2);
    }

    private final CompileTimeConstant<?> createConstant(Object value, KotlinType expectedType, CompileTimeConstant.Parameters parameters2) {
        if (parameters2.isPure() || parameters2.isUnsignedNumberLiteral()) {
            KotlinType kotlinType2 = expectedType;
            if (kotlinType2 == null) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
                kotlinType2 = simpleType2;
            }
            return this.createCompileTimeConstant(value, parameters2, kotlinType2);
        }
        ConstantValue<?> constantValue = ConstantValueFactory.INSTANCE.createConstantValue(value);
        return constantValue != null ? this.wrap(constantValue, parameters2) : null;
    }

    private final CompileTimeConstant<?> createCompileTimeConstant(Object value, CompileTimeConstant.Parameters parameters2, KotlinType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Object object = value;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            Object object2 = value;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            compileTimeConstant = this.createIntegerCompileTimeConstant(((Number)object2).longValue(), parameters2, expectedType);
        } else {
            ConstantValue<?> constantValue = ConstantValueFactory.INSTANCE.createConstantValue(value);
            compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
        }
        return compileTimeConstant;
    }

    private final CompileTimeConstant<?> createIntegerCompileTimeConstant(long value, CompileTimeConstant.Parameters parameters2, KotlinType expectedType) {
        long l;
        long l2;
        if (parameters2.isUnsignedNumberLiteral() && !this.checkAccessibilityOfUnsignedTypes()) {
            return new UnsignedErrorValueTypeConstant(value, parameters2);
        }
        if (parameters2.isUnsignedLongNumberLiteral()) {
            return this.wrap(new ULongValue(value), parameters2);
        }
        if (TypeUtils.noExpectedType(expectedType) || KotlinTypeKt.isError(expectedType)) {
            return CompileTimeConstantKt.createIntegerValueTypeConstant(value, this.constantExpressionEvaluator.getModule$frontend(), parameters2, this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference));
        }
        ConstantValue<?> integerValue = ConstantValueFactory.INSTANCE.createIntegerConstantValue(value, expectedType, parameters2.isUnsignedNumberLiteral());
        if (integerValue != null) {
            return this.wrap(integerValue, parameters2);
        }
        return this.wrap(parameters2.isUnsignedNumberLiteral() ? (ConstantValue)((l2 = value) == ConstantValueFactoryKt.fromUIntToLong((int)value) ? (UnsignedValueConstant)new UIntValue((int)value) : (UnsignedValueConstant)new ULongValue(value)) : (ConstantValue)((l = value) == (long)((int)value) ? (IntegerValueConstant)new IntValue((int)value) : (IntegerValueConstant)new LongValue(value)), parameters2);
    }

    private final boolean checkAccessibilityOfUnsignedTypes() {
        ModuleDescriptor moduleDescriptor = this.constantExpressionEvaluator.getModule$frontend();
        ClassId classId = KotlinBuiltIns.FQ_NAMES.uInt;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"KotlinBuiltIns.FQ_NAMES.uInt");
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor uInt = classDescriptor2;
        SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(uInt, this.languageVersionSettings);
        return accessibility instanceof SinceKotlinAccessibility.Accessible;
    }

    private final <T> TypedCompileTimeConstant<T> wrap(@NotNull ConstantValue<? extends T> $this$wrap, CompileTimeConstant.Parameters parameters2) {
        return new TypedCompileTimeConstant<T>($this$wrap, this.constantExpressionEvaluator.getModule$frontend(), parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(@NotNull ConstantValue<? extends T> $this$wrap, boolean canBeUsedInAnnotation, boolean isPure, boolean isUnsigned, boolean isUnsignedLong, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant, boolean isConvertableConstVal) {
        return this.wrap($this$wrap, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, isPure, isUnsigned, isUnsignedLong, usesVariableAsConstant, usesNonConstValAsConstant, isConvertableConstVal));
    }

    static /* synthetic */ TypedCompileTimeConstant wrap$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, ConstantValue constantValue, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl8 = bl = !(constantValue instanceof NullValue);
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        if ((n & 0x10) != 0) {
            bl5 = false;
        }
        if ((n & 0x20) != 0) {
            bl6 = false;
        }
        if ((n & 0x40) != 0) {
            bl7 = false;
        }
        return constantExpressionEvaluatorVisitor.wrap(constantValue, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public ConstantExpressionEvaluatorVisitor(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.trace = trace;
        this.languageVersionSettings = this.constantExpressionEvaluator.getLanguageVersionSettings$frontend();
        this.builtIns = this.constantExpressionEvaluator.getModule$frontend().getBuiltIns();
        this.stringExpressionEvaluator = new KtVisitor(this){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;

            private final TypedCompileTimeConstant<String> createStringConstant(CompileTimeConstant<?> compileTimeConstant) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
                ConstantValue<?> constantValue = compileTimeConstant.toConstantValue(simpleType2);
                if (ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constantValue)) {
                    return null;
                }
                ConstantValue<?> constantValue2 = constantValue;
                if (constantValue2 instanceof ErrorValue || constantValue2 instanceof EnumValue) {
                    return null;
                }
                return ConstantExpressionEvaluatorVisitor.access$wrap(this.this$0, constantValue2 instanceof NullValue ? new StringValue("null") : new StringValue(constantValue.stringTemplateValue()), compileTimeConstant.getParameters());
            }

            @Nullable
            public final TypedCompileTimeConstant<String> evaluate(@NotNull KtStringTemplateEntry entry) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                return (TypedCompileTimeConstant)entry.accept(this, null);
            }

            @Nullable
            public TypedCompileTimeConstant<String> visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data) {
                TypedCompileTimeConstant<String> typedCompileTimeConstant;
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                KtExpression ktExpression = entry.getExpression();
                if (ktExpression == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"entry.expression ?: return null");
                KtExpression expression2 = ktExpression;
                CompileTimeConstant<?> compileTimeConstant = this.this$0.evaluate(expression2, ConstantExpressionEvaluatorVisitor.access$getBuiltIns$p(this.this$0).getStringType());
                if (compileTimeConstant != null) {
                    CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
                    boolean bl = false;
                    boolean bl2 = false;
                    CompileTimeConstant<?> it = compileTimeConstant2;
                    boolean bl3 = false;
                    typedCompileTimeConstant = this.createStringConstant(it);
                } else {
                    typedCompileTimeConstant = null;
                }
                return typedCompileTimeConstant;
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                String string = entry.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.text");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, new StringValue(string), false, false, false, false, false, false, false, 127, null);
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                String string = entry.getUnescapedValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.unescapedValue");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, new StringValue(string), false, false, false, false, false, false, false, 127, null);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ BindingTrace access$getTrace$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.trace;
    }

    public static final /* synthetic */ TypedCompileTimeConstant access$wrap(ConstantExpressionEvaluatorVisitor $this, ConstantValue $this$access_u24wrap, CompileTimeConstant.Parameters parameters2) {
        return $this.wrap($this$access_u24wrap, parameters2);
    }

    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.builtIns;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "", "value", "ctcType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getCtcType", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getValue", "()Ljava/lang/Object;", "frontend"})
    private static final class OperationArgument {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<?> ctcType;
        @NotNull
        private final KtExpression expression;

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType<?> getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final KtExpression getExpression() {
            return this.expression;
        }

        public OperationArgument(@NotNull Object value, @NotNull CompileTimeType<?> ctcType, @NotNull KtExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull(ctcType, (String)"ctcType");
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression2;
        }
    }
}

