/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;

class ChecksumHasher
implements FileHasher {
    private final HashFunction hashFunction;

    public ChecksumHasher(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    public HashCode hash(File file) {
        try {
            return this.hashFunction.hashBytes(Files.toByteArray((File)file));
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public HashCode hash(File file, long length, long lastModified) {
        return this.hash(file);
    }
}

