/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.IncrementalChangesContext;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStep
implements Step<IncrementalChangesContext, CurrentSnapshotResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheStep.class);
    private final BuildCacheController buildCache;
    private final BuildCacheCommandFactory commandFactory;
    private final Deleter deleter;
    private final Step<? super IncrementalChangesContext, ? extends CurrentSnapshotResult> delegate;

    public CacheStep(BuildCacheController buildCache, BuildCacheCommandFactory commandFactory, Deleter deleter, Step<? super IncrementalChangesContext, ? extends CurrentSnapshotResult> delegate) {
        this.buildCache = buildCache;
        this.commandFactory = commandFactory;
        this.deleter = deleter;
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(IncrementalChangesContext context) {
        CachingState cachingState = context.getCachingState();
        return cachingState.getDisabledReasons().isEmpty() ? this.executeWithCache(context, cachingState.getKey().get()) : this.executeWithoutCache(context);
    }

    private CurrentSnapshotResult executeWithCache(IncrementalChangesContext context, BuildCacheKey cacheKey) {
        UnitOfWork work = context.getWork();
        return (CurrentSnapshotResult)Try.ofFailable(() -> work.isAllowedToLoadFromCache() ? this.buildCache.load(this.commandFactory.createLoad(cacheKey, (CacheableEntity)work)) : Optional.empty()).map(successfulLoad -> successfulLoad.map(cacheHit -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Loaded cache entry for {} with cache key {}", (Object)work.getDisplayName(), (Object)cacheKey.getHashCode());
            }
            this.cleanLocalState(work);
            final OriginMetadata originMetadata = cacheHit.getOriginMetadata();
            final ImmutableSortedMap finalOutputs = cacheHit.getResultingSnapshots();
            return new CurrentSnapshotResult(){

                @Override
                public Try<ExecutionOutcome> getOutcome() {
                    return Try.successful((Object)((Object)ExecutionOutcome.FROM_CACHE));
                }

                @Override
                public OriginMetadata getOriginMetadata() {
                    return originMetadata;
                }

                @Override
                public boolean isReused() {
                    return true;
                }

                @Override
                public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFinalOutputs() {
                    return finalOutputs;
                }
            };
        }).orElseGet(() -> this.executeAndStoreInCache(cacheKey, context))).getOrMapFailure(loadFailure -> {
            throw new RuntimeException(String.format("Failed to load cache entry for %s", work.getDisplayName()), (Throwable)loadFailure);
        });
    }

    private void cleanLocalState(UnitOfWork work) {
        work.visitLocalState(localStateFile -> {
            try {
                this.deleter.deleteRecursively(localStateFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", work.getDisplayName(), localStateFile), ex);
            }
        });
    }

    private CurrentSnapshotResult executeAndStoreInCache(BuildCacheKey cacheKey, IncrementalChangesContext context) {
        CurrentSnapshotResult executionResult = this.executeWithoutCache(context);
        executionResult.getOutcome().ifSuccessfulOrElse(outcome -> this.store(context.getWork(), cacheKey, executionResult), failure -> LOGGER.debug("Not storing result of {} in cache because the execution failed", (Object)context.getWork().getDisplayName()));
        return executionResult;
    }

    private void store(UnitOfWork work, BuildCacheKey cacheKey, CurrentSnapshotResult result) {
        try {
            this.buildCache.store(this.commandFactory.createStore(cacheKey, (CacheableEntity)work, result.getFinalOutputs(), result.getOriginMetadata().getExecutionTime()));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stored cache entry for {} with cache key {}", (Object)work.getDisplayName(), (Object)cacheKey.getHashCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to store cache entry for %s", work.getDisplayName()), e);
        }
    }

    private CurrentSnapshotResult executeWithoutCache(IncrementalChangesContext context) {
        return this.delegate.execute(context);
    }
}

