/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.isolated;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.logging.text.TreeFormatter;

public class IsolationScheme<IMPLEMENTATION, PARAMS> {
    private final Class<IMPLEMENTATION> interfaceType;
    private final Class<PARAMS> paramsType;
    private final Class<? extends PARAMS> noParamsType;

    public IsolationScheme(Class<IMPLEMENTATION> interfaceType, Class<PARAMS> paramsType, Class<? extends PARAMS> noParamsType) {
        this.interfaceType = interfaceType;
        this.paramsType = paramsType;
        this.noParamsType = noParamsType;
    }

    @Nullable
    public <T extends IMPLEMENTATION, P extends PARAMS> Class<P> parameterTypeFor(Class<T> implementationType) {
        return this.parameterTypeFor(implementationType, 0);
    }

    @Nullable
    public <T extends IMPLEMENTATION, P extends PARAMS> Class<P> parameterTypeFor(Class<T> implementationType, int typeArgumentIndex) {
        if (implementationType == this.interfaceType) {
            return null;
        }
        ParameterizedType superType = (ParameterizedType)TypeToken.of(implementationType).getSupertype(this.interfaceType).getType();
        Class parametersType = (Class)Cast.uncheckedNonnullCast((Object)TypeToken.of((Type)superType.getActualTypeArguments()[typeArgumentIndex]).getRawType());
        if (parametersType == this.paramsType) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not create the parameters for ");
            formatter.appendType(implementationType);
            formatter.append((CharSequence)": must use a sub-type of ");
            formatter.appendType((Type)parametersType);
            formatter.append((CharSequence)" as the parameters type. Use ");
            formatter.appendType(this.noParamsType);
            formatter.append((CharSequence)" as the parameters type for implementations that do not take parameters.");
            throw new IllegalArgumentException(formatter.toString());
        }
        if (parametersType == this.noParamsType) {
            return null;
        }
        return parametersType;
    }
}

