/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.OptimizationMethodVisitor;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Transformer", "backend"})
public final class PopBackwardPropagationTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        if (!OptimizationMethodVisitor.Companion.canBeOptimizedUsingSourceInterpreter(methodNode)) {
            return;
        }
        new Transformer(methodNode).transform();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0002G$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010$\u001a\u00020\u00062\u0014\b\u0004\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020'0&H\u0082\bJ\u001d\u0010(\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010)\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020\u001fH\u0002J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0019H\u0002J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020\u0019H\u0002J\u0018\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002012\u0006\u0010,\u001a\u00020\u0019H\u0002J\b\u00107\u001a\u00020'H\u0002J%\u00108\u001a\u00020'2\u0016\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f0\u000eH\u0002\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010;\u001a\u00020/H\u0002J\u001a\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020\u00192\b\u0010>\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010?\u001a\u00020\u0006H\u0002J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/H\u0002J \u0010A\u001a\u00020B2\b\u0010,\u001a\u0004\u0018\u00010\u00192\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0006\u0010D\u001a\u00020'J\u0012\u0010E\u001a\u00020'*\b\u0012\u0004\u0012\u00020\u00190FH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0018\u001a(\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00190\u0019 \u0017*\u0014\u0012\u000e\b\u0001\u0012\n \u0017*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\"j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0006`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "INSERT_POP1_AFTER", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer$Transformation;", "INSERT_POP2_AFTER", "REPLACE_WITH_NOP", "REPLACE_WITH_POP1", "REPLACE_WITH_POP2", "dontTouchInsnIndices", "Ljava/util/BitSet;", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/SourceValue;", "getFrames", "()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "frames$delegate", "Lkotlin/Lazy;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "insns", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "[Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "removableNops", "Ljava/util/HashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/InsnNode;", "Lkotlin/collections/HashSet;", "transformations", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "Transformation", "body", "Lkotlin/Function1;", "", "analyzeMethodBody", "computeTransformations", "createRemovableNopInsn", "getInputTop", "insn", "insertPopAfterTransformation", "size", "", "isDontTouch", "", "isTransformableCheckcastOperand", "it", "resultType", "", "isTransformablePopOperand", "postprocessNops", "postprocessStackHazards", "([Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "propagatePopBackwards", "poppedValueSize", "removeUnneededNopsInRange", "begin", "end", "replaceWithNopTransformation", "replaceWithPopTransformation", "throwIncorrectBytecode", "", "frame", "transform", "markAsDontTouch", "", "HazardsTrackingInterpreter", "backend"})
    private static final class Transformer {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final Transformation REPLACE_WITH_NOP;
        private final Transformation REPLACE_WITH_POP1;
        private final Transformation REPLACE_WITH_POP2;
        private final Transformation INSERT_POP1_AFTER;
        private final Transformation INSERT_POP2_AFTER;
        private final InsnList insnList;
        private final AbstractInsnNode[] insns;
        private final BitSet dontTouchInsnIndices;
        private final HashMap<AbstractInsnNode, Transformation> transformations;
        private final HashSet<InsnNode> removableNops;
        private final Lazy frames$delegate;
        @NotNull
        private final MethodNode methodNode;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Transformer.class), "frames", "getFrames()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;"))};
        }

        private final Frame<SourceValue>[] getFrames() {
            Lazy lazy = this.frames$delegate;
            Transformer transformer = this;
            KProperty kProperty = $$delegatedProperties[0];
            boolean bl = false;
            return (Frame[])lazy.getValue();
        }

        public final void transform() {
            boolean bl;
            block3: {
                Intrinsics.checkExpressionValueIsNotNull((Object)this.insns, (String)"insns");
                AbstractInsnNode[] $this$none$iv = this.insns;
                boolean $i$f$none = false;
                AbstractInsnNode[] abstractInsnNodeArray = $this$none$iv;
                int n = abstractInsnNodeArray.length;
                for (int i = 0; i < n; ++i) {
                    AbstractInsnNode element$iv;
                    AbstractInsnNode it = element$iv = abstractInsnNodeArray[i];
                    boolean bl2 = false;
                    AbstractInsnNode abstractInsnNode = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"it");
                    if (!(PopBackwardPropagationTransformerKt.isPop(abstractInsnNode) || PopBackwardPropagationTransformerKt.isPurePush(it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
            this.computeTransformations();
            Iterator<Map.Entry<AbstractInsnNode, Transformation>> iterator2 = this.transformations.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<AbstractInsnNode, Transformation> entry;
                Map.Entry<AbstractInsnNode, Transformation> entry2 = entry = iterator2.next();
                boolean bl3 = false;
                AbstractInsnNode insn = entry2.getKey();
                entry2 = entry;
                bl3 = false;
                Transformation transformation = entry2.getValue();
                AbstractInsnNode abstractInsnNode = insn;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insn");
                transformation.apply(abstractInsnNode);
            }
            this.postprocessNops();
        }

        private final Frame<SourceValue>[] analyzeMethodBody() {
            Frame<V>[] frames2 = new Analyzer(new HazardsTrackingInterpreter()).analyze("fake", this.methodNode);
            Intrinsics.checkExpressionValueIsNotNull(frames2, (String)"frames");
            this.postprocessStackHazards(frames2);
            return frames2;
        }

        /*
         * WARNING - void declaration
         */
        private final void postprocessStackHazards(Frame<SourceValue>[] frames2) {
            AbstractInsnNode[] insns2 = this.methodNode.instructions.toArray();
            int n = 0;
            int n2 = frames2.length;
            while (n < n2) {
                void i;
                if (frames2[i] == null) {
                } else {
                    AbstractInsnNode insn;
                    AbstractInsnNode abstractInsnNode = insn = insns2[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insn");
                    switch (abstractInsnNode.getOpcode()) {
                        case 88: {
                            SourceValue it;
                            List<SourceValue> top2;
                            Frame<SourceValue> frame;
                            if (StackTransformationUtilsKt.peekWords(frame, 2) == null) {
                                Void void_ = this.throwIncorrectBytecode(insn, frame);
                                throw null;
                            }
                            Iterable $this$forEach$iv = top2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                Set<AbstractInsnNode> set = it.insns;
                                Intrinsics.checkExpressionValueIsNotNull(set, (String)"it.insns");
                                this.markAsDontTouch((Collection<? extends AbstractInsnNode>)set);
                            }
                            break;
                        }
                        case 90: {
                            SourceValue it;
                            List<SourceValue> top2;
                            Frame<SourceValue> frame;
                            if (StackTransformationUtilsKt.peekWords(frame, 1, 1) == null) {
                                Void void_ = this.throwIncorrectBytecode(insn, frame);
                                throw null;
                            }
                            Iterable $this$forEach$iv = top2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                Set<AbstractInsnNode> set = it.insns;
                                Intrinsics.checkExpressionValueIsNotNull(set, (String)"it.insns");
                                this.markAsDontTouch((Collection<? extends AbstractInsnNode>)set);
                            }
                            break;
                        }
                        case 93: {
                            List<SourceValue> top3;
                            SourceValue it;
                            Frame<SourceValue> frame;
                            if (StackTransformationUtilsKt.peekWords(frame, 2, 1) == null) {
                                Void void_ = this.throwIncorrectBytecode(insn, frame);
                                throw null;
                            }
                            Iterable $this$forEach$iv = top3;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                Set<AbstractInsnNode> set = it.insns;
                                Intrinsics.checkExpressionValueIsNotNull(set, (String)"it.insns");
                                this.markAsDontTouch((Collection<? extends AbstractInsnNode>)set);
                            }
                            break;
                        }
                        case 91: {
                            List<SourceValue> top3;
                            SourceValue it;
                            Frame<SourceValue> frame;
                            if (StackTransformationUtilsKt.peekWords(frame, 1, 2) == null) {
                                Void void_ = this.throwIncorrectBytecode(insn, frame);
                                throw null;
                            }
                            Iterable $this$forEach$iv = top3;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                Set<AbstractInsnNode> set = it.insns;
                                Intrinsics.checkExpressionValueIsNotNull(set, (String)"it.insns");
                                this.markAsDontTouch((Collection<? extends AbstractInsnNode>)set);
                            }
                            break;
                        }
                        case 94: {
                            List<SourceValue> top4;
                            SourceValue it;
                            Frame<SourceValue> frame;
                            if (StackTransformationUtilsKt.peekWords(frame, 2, 2) == null) {
                                Void void_ = this.throwIncorrectBytecode(insn, frame);
                                throw null;
                            }
                            Iterable $this$forEach$iv = top4;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                Set<AbstractInsnNode> set = it.insns;
                                Intrinsics.checkExpressionValueIsNotNull(set, (String)"it.insns");
                                this.markAsDontTouch((Collection<? extends AbstractInsnNode>)set);
                            }
                            break;
                        }
                    }
                }
                ++i;
            }
        }

        private final Void throwIncorrectBytecode(AbstractInsnNode insn, Frame<SourceValue> frame) {
            throw (Throwable)((Object)new AssertionError((Object)("Incorrect bytecode at " + this.methodNode.instructions.indexOf(insn) + ": " + UtilKt.getDebugText(insn) + ' ' + frame)));
        }

        private final void markAsDontTouch(@NotNull Collection<? extends AbstractInsnNode> $this$markAsDontTouch) {
            Iterable $this$forEach$iv = $this$markAsDontTouch;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                boolean bl = false;
                this.dontTouchInsnIndices.set(this.insnList.indexOf(it), true);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void computeTransformations() {
            this.transformations.clear();
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.insns, (String)"insns");
            int n2 = this.insns.length;
            while (n < n2) {
                void i;
                if (this.getFrames()[i] != null) {
                    AbstractInsnNode insn;
                    AbstractInsnNode abstractInsnNode = insn = this.insns[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insn");
                    if (abstractInsnNode.getOpcode() == 87) {
                        this.propagatePopBackwards(insn, 0);
                    }
                }
                ++i;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void propagatePopBackwards(AbstractInsnNode insn, int poppedValueSize) {
            if (this.transformations.containsKey(insn)) {
                return;
            }
            if (insn.getOpcode() == 87) {
                AbstractInsnNode abstractInsnNode;
                AbstractInsnNode it;
                Object element$iv2;
                boolean bl;
                Set<AbstractInsnNode> sources;
                SourceValue inputTop = this.getInputTop(insn);
                Set<AbstractInsnNode> set = sources = inputTop.insns;
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"sources");
                Iterable $this$all$iv = set;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        it = (AbstractInsnNode)element$iv2;
                        boolean bl2 = false;
                        AbstractInsnNode abstractInsnNode2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode2, (String)"it");
                        if (this.isDontTouch(abstractInsnNode2)) return;
                        boolean bl3 = true;
                        if (bl3) continue;
                        return;
                    }
                    bl = true;
                }
                if (!bl) return;
                Iterable $this$any$iv = sources;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return;
                    element$iv2 = iterator2.next();
                    it = (AbstractInsnNode)element$iv2;
                    boolean bl4 = false;
                    abstractInsnNode = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"it");
                } while (!this.isTransformablePopOperand(abstractInsnNode));
                boolean bl5 = true;
                if (!bl5) return;
                ((Map)this.transformations).put(insn, this.replaceWithNopTransformation());
                Iterable $this$forEach$iv = sources;
                boolean $i$f$forEach = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    it = (AbstractInsnNode)element$iv2;
                    boolean bl6 = false;
                    AbstractInsnNode abstractInsnNode3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode3, (String)"it");
                    this.propagatePopBackwards(abstractInsnNode3, inputTop.size);
                }
                return;
            }
            if (insn.getOpcode() == 192) {
                AbstractInsnNode it;
                boolean bl;
                String resultType;
                Set<AbstractInsnNode> sources;
                SourceValue inputTop;
                block27: {
                    inputTop = this.getInputTop(insn);
                    sources = inputTop.insns;
                    AbstractInsnNode abstractInsnNode = insn;
                    if (abstractInsnNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
                    }
                    resultType = ((TypeInsnNode)abstractInsnNode).desc;
                    Set<AbstractInsnNode> set = sources;
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"sources");
                    Iterable $this$all$iv = set;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv3 : $this$all$iv) {
                            it = (AbstractInsnNode)element$iv3;
                            boolean bl7 = false;
                            AbstractInsnNode abstractInsnNode4 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode4, (String)"it");
                            if (!this.isDontTouch(abstractInsnNode4)) continue;
                            bl = false;
                            break block27;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    boolean bl8;
                    block28: {
                        Iterable $this$any$iv = sources;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl8 = false;
                        } else {
                            for (Object element$iv3 : $this$any$iv) {
                                it = (AbstractInsnNode)element$iv3;
                                boolean bl9 = false;
                                AbstractInsnNode abstractInsnNode = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"it");
                                String string2 = resultType;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resultType");
                                if (!this.isTransformableCheckcastOperand(abstractInsnNode, string2)) continue;
                                bl8 = true;
                                break block28;
                            }
                            bl8 = false;
                        }
                    }
                    if (bl8) {
                        ((Map)this.transformations).put(insn, this.replaceWithNopTransformation());
                        Iterable $this$forEach$iv = sources;
                        boolean $i$f$forEach = false;
                        Iterator element$iv = $this$forEach$iv.iterator();
                        while (element$iv.hasNext()) {
                            Object element$iv3;
                            element$iv3 = element$iv.next();
                            it = (AbstractInsnNode)element$iv3;
                            boolean bl10 = false;
                            AbstractInsnNode abstractInsnNode = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"it");
                            this.propagatePopBackwards(abstractInsnNode, inputTop.size);
                        }
                        return;
                    }
                }
                ((Map)this.transformations).put(insn, this.insertPopAfterTransformation(poppedValueSize));
                return;
            }
            if (BoxingInterpreterKt.isPrimitiveBoxing(insn)) {
                int boxedValueSize = this.getInputTop((AbstractInsnNode)insn).size;
                ((Map)this.transformations).put(insn, this.replaceWithPopTransformation(boxedValueSize));
                return;
            }
            if (PopBackwardPropagationTransformerKt.isPurePush(insn)) {
                ((Map)this.transformations).put(insn, this.replaceWithNopTransformation());
                return;
            }
            if (PopBackwardPropagationTransformerKt.isPrimitiveTypeConversion(insn)) {
                AbstractInsnNode it;
                boolean bl;
                Set<AbstractInsnNode> sources;
                SourceValue inputTop;
                block29: {
                    inputTop = this.getInputTop(insn);
                    Set<AbstractInsnNode> set = sources = inputTop.insns;
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"sources");
                    Iterable $this$all$iv = set;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (AbstractInsnNode)element$iv;
                            boolean bl11 = false;
                            AbstractInsnNode abstractInsnNode = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"it");
                            if (!this.isDontTouch(abstractInsnNode)) continue;
                            bl = false;
                            break block29;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ((Map)this.transformations).put(insn, this.replaceWithNopTransformation());
                    Iterable $this$forEach$iv = sources;
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv;
                        element$iv = iterator3.next();
                        it = (AbstractInsnNode)element$iv;
                        boolean bl12 = false;
                        AbstractInsnNode abstractInsnNode = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"it");
                        this.propagatePopBackwards(abstractInsnNode, inputTop.size);
                    }
                    return;
                }
                ((Map)this.transformations).put(insn, this.replaceWithPopTransformation(poppedValueSize));
                return;
            }
            ((Map)this.transformations).put(insn, this.insertPopAfterTransformation(poppedValueSize));
        }

        private final void postprocessNops() {
            InsnList insnList = this.insnList;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"insnList");
            AbstractInsnNode node = insnList.getFirst();
            boolean hasRemovableNops = false;
            while (node != null) {
                if ((node = node.getNext()) == null) {
                    break;
                }
                while (node != null && !(node instanceof LabelNode)) {
                    if (CollectionsKt.contains((Iterable)this.removableNops, (Object)node)) {
                        hasRemovableNops = true;
                    }
                    node = node.getNext();
                }
                AbstractInsnNode end = node;
                if (hasRemovableNops) {
                    AbstractInsnNode begin;
                    this.removeUnneededNopsInRange(begin, end);
                }
                hasRemovableNops = false;
            }
        }

        private final void removeUnneededNopsInRange(AbstractInsnNode begin, AbstractInsnNode end) {
            AbstractInsnNode node = begin;
            boolean keepNop = true;
            while (node != null && Intrinsics.areEqual((Object)node, (Object)end) ^ true) {
                if (CollectionsKt.contains((Iterable)this.removableNops, (Object)node) && !keepNop) {
                    InsnList insnList = this.insnList;
                    Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"insnList");
                    node = LabelNormalizationMethodTransformerKt.removeNodeGetNext(insnList, node);
                    continue;
                }
                if (UtilKt.isMeaningful(node)) {
                    keepNop = false;
                }
                node = node.getNext();
            }
        }

        private final Transformation replaceWithPopTransformation(int size) {
            Transformation transformation;
            switch (size) {
                case 1: {
                    transformation = this.REPLACE_WITH_POP1;
                    break;
                }
                case 2: {
                    transformation = this.REPLACE_WITH_POP2;
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError((Object)("Unexpected pop value size: " + size)));
                }
            }
            return transformation;
        }

        private final Transformation insertPopAfterTransformation(int size) {
            Transformation transformation;
            switch (size) {
                case 1: {
                    transformation = this.INSERT_POP1_AFTER;
                    break;
                }
                case 2: {
                    transformation = this.INSERT_POP2_AFTER;
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError((Object)("Unexpected pop value size: " + size)));
                }
            }
            return transformation;
        }

        private final Transformation replaceWithNopTransformation() {
            return this.REPLACE_WITH_NOP;
        }

        private final InsnNode createRemovableNopInsn() {
            InsnNode insnNode = new InsnNode(0);
            boolean bl = false;
            boolean bl2 = false;
            InsnNode $this$apply = insnNode;
            boolean bl3 = false;
            this.removableNops.add($this$apply);
            return insnNode;
        }

        private final SourceValue getInputTop(AbstractInsnNode insn) {
            int i = this.insnList.indexOf(insn);
            Frame<SourceValue> frame = this.getFrames()[i];
            if (frame == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected dead instruction #" + i)));
            }
            Frame<SourceValue> frame2 = frame;
            SourceValue sourceValue = StackTransformationUtilsKt.top(frame2);
            if (sourceValue == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Instruction #" + i + " has empty stack on input")));
            }
            return sourceValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isTransformableCheckcastOperand(AbstractInsnNode it, String resultType) {
            if (!BoxingInterpreterKt.isPrimitiveBoxing(it)) return false;
            AbstractInsnNode abstractInsnNode = it;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
            }
            if (!Intrinsics.areEqual((Object)((MethodInsnNode)abstractInsnNode).owner, (Object)resultType)) return false;
            return true;
        }

        private final boolean isTransformablePopOperand(AbstractInsnNode insn) {
            return insn.getOpcode() == 192 || BoxingInterpreterKt.isPrimitiveBoxing(insn) || PopBackwardPropagationTransformerKt.isPurePush(insn);
        }

        private final boolean isDontTouch(AbstractInsnNode insn) {
            return this.dontTouchInsnIndices.get(this.insnList.indexOf(insn));
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public Transformer(@NotNull MethodNode methodNode) {
            Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
            this.methodNode = methodNode;
            Transformer transformer = this;
            Transformer transformer2 = this;
            boolean $i$f$Transformation = false;
            HashSet hashSet = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).set(it, Transformer.access$createRemovableNopInsn(this.this$0));
                }
            };
            transformer2.REPLACE_WITH_NOP = hashSet;
            Transformer this_$iv = this;
            transformer2 = this;
            $i$f$Transformation = false;
            hashSet = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).set(it, new InsnNode(87));
                }
            };
            transformer2.REPLACE_WITH_POP1 = hashSet;
            this_$iv = this;
            transformer2 = this;
            $i$f$Transformation = false;
            hashSet = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).set(it, new InsnNode(88));
                }
            };
            transformer2.REPLACE_WITH_POP2 = hashSet;
            this_$iv = this;
            transformer2 = this;
            $i$f$Transformation = false;
            hashSet = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).insert(it, new InsnNode(87));
                }
            };
            transformer2.INSERT_POP1_AFTER = hashSet;
            this_$iv = this;
            transformer2 = this;
            $i$f$Transformation = false;
            hashSet = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).insert(it, new InsnNode(88));
                }
            };
            transformer2.INSERT_POP2_AFTER = hashSet;
            this.insnList = this.methodNode.instructions;
            this.insns = this.insnList.toArray();
            this.dontTouchInsnIndices = new BitSet(this.insns.length);
            transformer2 = this;
            boolean bl = false;
            hashSet = new HashMap();
            transformer2.transformations = hashSet;
            transformer2 = this;
            bl = false;
            hashSet = new HashSet();
            transformer2.removableNops = hashSet;
            this.frames$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Frame<SourceValue>[]>(this){
                final /* synthetic */ Transformer this$0;

                @NotNull
                public final Frame<SourceValue>[] invoke() {
                    return Transformer.access$analyzeMethodBody(this.this$0);
                }
                {
                    this.this$0 = transformer;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ InsnList access$getInsnList$p(Transformer $this) {
            return $this.insnList;
        }

        public static final /* synthetic */ InsnNode access$createRemovableNopInsn(Transformer $this) {
            return $this.createRemovableNopInsn();
        }

        public static final /* synthetic */ Frame[] access$analyzeMethodBody(Transformer $this) {
            return $this.analyzeMethodBody();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer$Transformation;", "", "apply", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "backend"})
        private static interface Transformation {
            public void apply(@NotNull AbstractInsnNode var1);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\rH\u0016J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer$HazardsTrackingInterpreter;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/SourceInterpreter;", "(Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer;)V", "binaryOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/SourceValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value1", "value2", "copyOperation", "value", "naryOperation", "values", "", "ternaryOperation", "value3", "unaryOperation", "backend"})
        private final class HazardsTrackingInterpreter
        extends SourceInterpreter {
            @Override
            @NotNull
            public SourceValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends SourceValue> values2) {
                Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                Intrinsics.checkParameterIsNotNull(values2, (String)"values");
                for (SourceValue sourceValue : values2) {
                    Set<AbstractInsnNode> set = sourceValue.insns;
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"value.insns");
                    Transformer.this.markAsDontTouch(set);
                }
                Value value2 = super.naryOperation(insn, (List)values2);
                Intrinsics.checkExpressionValueIsNotNull((Object)value2, (String)"super.naryOperation(insn, values)");
                return value2;
            }

            @Override
            @NotNull
            public SourceValue copyOperation(@NotNull AbstractInsnNode insn, @NotNull SourceValue value2) {
                Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                Set<AbstractInsnNode> set = value2.insns;
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"value.insns");
                Transformer.this.markAsDontTouch(set);
                SourceValue sourceValue = super.copyOperation(insn, value2);
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceValue, (String)"super.copyOperation(insn, value)");
                return sourceValue;
            }

            @Override
            @NotNull
            public SourceValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull SourceValue value2) {
                Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                if (insn.getOpcode() != 192 && !PopBackwardPropagationTransformerKt.isPrimitiveTypeConversion(insn)) {
                    Set<AbstractInsnNode> set = value2.insns;
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"value.insns");
                    Transformer.this.markAsDontTouch(set);
                }
                SourceValue sourceValue = super.unaryOperation(insn, value2);
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceValue, (String)"super.unaryOperation(insn, value)");
                return sourceValue;
            }

            @Override
            @NotNull
            public SourceValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull SourceValue value1, @NotNull SourceValue value2) {
                Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                Intrinsics.checkParameterIsNotNull((Object)value1, (String)"value1");
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value2");
                Set<AbstractInsnNode> set = value1.insns;
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"value1.insns");
                Transformer.this.markAsDontTouch(set);
                Set<AbstractInsnNode> set2 = value2.insns;
                Intrinsics.checkExpressionValueIsNotNull(set2, (String)"value2.insns");
                Transformer.this.markAsDontTouch(set2);
                SourceValue sourceValue = super.binaryOperation(insn, value1, value2);
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceValue, (String)"super.binaryOperation(insn, value1, value2)");
                return sourceValue;
            }

            @Override
            @NotNull
            public SourceValue ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull SourceValue value1, @NotNull SourceValue value2, @NotNull SourceValue value3) {
                Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
                Intrinsics.checkParameterIsNotNull((Object)value1, (String)"value1");
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value2");
                Intrinsics.checkParameterIsNotNull((Object)value3, (String)"value3");
                Set<AbstractInsnNode> set = value1.insns;
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"value1.insns");
                Transformer.this.markAsDontTouch(set);
                Set<AbstractInsnNode> set2 = value2.insns;
                Intrinsics.checkExpressionValueIsNotNull(set2, (String)"value2.insns");
                Transformer.this.markAsDontTouch(set2);
                Set<AbstractInsnNode> set3 = value3.insns;
                Intrinsics.checkExpressionValueIsNotNull(set3, (String)"value3.insns");
                Transformer.this.markAsDontTouch(set3);
                SourceValue sourceValue = super.ternaryOperation(insn, value1, value2, value3);
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceValue, (String)"super.ternaryOperation(i\u2026, value1, value2, value3)");
                return sourceValue;
            }

            public HazardsTrackingInterpreter() {
                super(458752);
            }
        }
    }
}

