/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.vfs.AdditiveCacheLocations;

public class SplitClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache,
Closeable {
    private final AdditiveCacheLocations additiveCacheLocations;
    private final ClasspathEntrySnapshotCache globalCache;
    private final ClasspathEntrySnapshotCache localCache;

    public SplitClasspathEntrySnapshotCache(AdditiveCacheLocations additiveCacheLocations, ClasspathEntrySnapshotCache globalCache, ClasspathEntrySnapshotCache localCache) {
        this.additiveCacheLocations = additiveCacheLocations;
        this.globalCache = globalCache;
        this.localCache = localCache;
    }

    @Override
    public ClasspathEntrySnapshot get(File file, HashCode hash) {
        if (this.additiveCacheLocations.isInsideAdditiveCache(file.getPath())) {
            return this.globalCache.get(file, hash);
        }
        return this.localCache.get(file, hash);
    }

    public ClasspathEntrySnapshot get(File entry, Factory<ClasspathEntrySnapshot> factory) {
        if (this.additiveCacheLocations.isInsideAdditiveCache(entry.getPath())) {
            return (ClasspathEntrySnapshot)this.globalCache.get(entry, factory);
        }
        return (ClasspathEntrySnapshot)this.localCache.get(entry, factory);
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable((Object[])new Object[]{this.localCache}).stop();
    }
}

