/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.file.FileWatcherCallback;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractEventDrivenFileWatcherRegistry
implements FileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventDrivenFileWatcherRegistry.class);
    private final FileWatcher watcher;
    private final AtomicInteger numberOfReceivedEvents = new AtomicInteger();
    private final AtomicBoolean unknownEventEncountered = new AtomicBoolean();
    private final AtomicReference<Throwable> errorWhileReceivingFileChanges = new AtomicReference();

    public AbstractEventDrivenFileWatcherRegistry(Set<Path> roots, FileWatcherCreator watcherCreator, FileWatcherRegistry.ChangeHandler handler) {
        this.watcher = this.createWatcher(roots, watcherCreator, handler);
    }

    private FileWatcher createWatcher(Set<Path> roots, FileWatcherCreator watcherCreator, final FileWatcherRegistry.ChangeHandler handler) {
        FileWatcher watcher = watcherCreator.createWatcher(new FileWatcherCallback(){

            public void pathChanged(FileWatcherCallback.Type type, String path) {
                AbstractEventDrivenFileWatcherRegistry.this.handleEvent(type, path, handler);
            }

            public void reportError(Throwable ex) {
                LOGGER.error("Error while receiving file changes", ex);
                AbstractEventDrivenFileWatcherRegistry.this.errorWhileReceivingFileChanges.compareAndSet(null, ex);
                handler.handleLostState();
            }
        });
        roots.stream().map(Path::toFile).forEach(arg_0 -> ((FileWatcher)watcher).startWatching(arg_0));
        return watcher;
    }

    private void handleEvent(FileWatcherCallback.Type type, String path, FileWatcherRegistry.ChangeHandler handler) {
        if (type == FileWatcherCallback.Type.UNKNOWN) {
            this.unknownEventEncountered.set(true);
            handler.handleLostState();
        } else {
            this.numberOfReceivedEvents.incrementAndGet();
            handler.handleChange(AbstractEventDrivenFileWatcherRegistry.convertType(type), Paths.get(path, new String[0]));
        }
    }

    private static FileWatcherRegistry.Type convertType(FileWatcherCallback.Type type) {
        switch (type) {
            case CREATED: {
                return FileWatcherRegistry.Type.CREATED;
            }
            case MODIFIED: {
                return FileWatcherRegistry.Type.MODIFIED;
            }
            case REMOVED: {
                return FileWatcherRegistry.Type.REMOVED;
            }
            case INVALIDATE: {
                return FileWatcherRegistry.Type.INVALIDATE;
            }
        }
        throw new AssertionError();
    }

    public FileWatcherRegistry.FileWatchingStatistics getStatistics() {
        return new FileWatcherRegistry.FileWatchingStatistics(this.unknownEventEncountered.get(), this.numberOfReceivedEvents.get(), this.errorWhileReceivingFileChanges.get());
    }

    public void close() throws IOException {
        this.watcher.close();
    }

    protected static interface FileWatcherCreator {
        public FileWatcher createWatcher(FileWatcherCallback var1);
    }
}

