/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.MutationGuards;
import org.gradle.api.internal.collections.DefaultDomainObjectCollectionFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.provider.DefaultProviderFactory;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.WorkerSharedGlobalScopeServices;
import org.gradle.internal.service.scopes.WorkerSharedProjectScopeServices;
import org.gradle.internal.service.scopes.WorkerSharedUserHomeScopeServices;
import org.gradle.internal.state.ManagedFactoryRegistry;
import org.gradle.process.internal.ExecFactory;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DefaultActionExecutionSpecFactory;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.FlatClassLoaderStructure;
import org.gradle.workers.internal.FlatClassLoaderWorker;
import org.gradle.workers.internal.IsolatableSerializerRegistry;
import org.gradle.workers.internal.IsolatedClassloaderWorker;
import org.gradle.workers.internal.TransportableActionExecutionSpec;
import org.gradle.workers.internal.WorkerDaemonMessageSerializer;
import org.gradle.workers.internal.WorkerProtocol;

public class WorkerDaemonServer
implements WorkerProtocol {
    private final ServiceRegistry internalServices;
    private final LegacyTypesSupport legacyTypesSupport;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private final InstantiatorFactory instantiatorFactory;
    private ClassLoader workerClassLoader;

    @Inject
    public WorkerDaemonServer(ServiceRegistry parentServices, RequestArgumentSerializers argumentSerializers) {
        this.internalServices = WorkerDaemonServer.createWorkerDaemonServices(parentServices);
        this.legacyTypesSupport = (LegacyTypesSupport)this.internalServices.get(LegacyTypesSupport.class);
        this.actionExecutionSpecFactory = (ActionExecutionSpecFactory)this.internalServices.get(ActionExecutionSpecFactory.class);
        this.instantiatorFactory = (InstantiatorFactory)this.internalServices.get(InstantiatorFactory.class);
        argumentSerializers.add(WorkerDaemonMessageSerializer.create());
    }

    static ServiceRegistry createWorkerDaemonServices(ServiceRegistry parent) {
        return ServiceRegistryBuilder.builder().displayName("worker daemon services").parent(parent).provider((Object)new WorkerSharedGlobalScopeServices()).provider((Object)new WorkerDaemonServices()).build();
    }

    @Override
    public DefaultWorkResult execute(TransportableActionExecutionSpec<?> spec) {
        DefaultWorkResult defaultWorkResult;
        WorkerProjectServices internalServices = new WorkerProjectServices(spec.getBaseDir(), this.internalServices);
        try {
            WorkerProtocol worker = this.getIsolatedClassloaderWorker(spec.getClassLoaderStructure(), (ServiceRegistry)internalServices);
            defaultWorkResult = worker.execute(spec);
        }
        catch (Throwable throwable) {
            try {
                try {
                    internalServices.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                return new DefaultWorkResult(true, t);
            }
        }
        internalServices.close();
        return defaultWorkResult;
    }

    private WorkerProtocol getIsolatedClassloaderWorker(ClassLoaderStructure classLoaderStructure, ServiceRegistry workServices) {
        if (classLoaderStructure instanceof FlatClassLoaderStructure) {
            return new FlatClassLoaderWorker(this.getClass().getClassLoader(), workServices, this.actionExecutionSpecFactory, this.instantiatorFactory);
        }
        return new IsolatedClassloaderWorker(this.getWorkerClassLoader(classLoaderStructure), workServices, this.actionExecutionSpecFactory, this.instantiatorFactory, true);
    }

    private ClassLoader getWorkerClassLoader(ClassLoaderStructure classLoaderStructure) {
        if (this.workerClassLoader == null) {
            this.workerClassLoader = IsolatedClassloaderWorker.createIsolatedWorkerClassloader(classLoaderStructure, this.getClass().getClassLoader(), this.legacyTypesSupport);
        }
        return this.workerClassLoader;
    }

    public String toString() {
        return "WorkerDaemonServer{}";
    }

    static class WorkerProjectServices
    extends DefaultServiceRegistry {
        public WorkerProjectServices(File baseDir, ServiceRegistry ... parents) {
            super("worker file services for " + baseDir.getAbsolutePath(), parents);
            this.addProvider(new WorkerSharedProjectScopeServices(baseDir));
        }

        protected Instantiator createInstantiator(InstantiatorFactory instantiatorFactory) {
            return instantiatorFactory.decorateLenient((ServiceLookup)this);
        }

        protected ExecFactory createExecFactory(ExecFactory execFactory, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Instantiator instantiator, ObjectFactory objectFactory) {
            return execFactory.forContext(fileResolver, fileCollectionFactory, instantiator, objectFactory);
        }

        protected DefaultResourceHandler.Factory createResourceHandlerFactory() {
            ResourceHandler resourceHandler = new ResourceHandler(){

                public ReadableResource gzip(Object path) {
                    throw new UnsupportedOperationException();
                }

                public ReadableResource bzip2(Object path) {
                    throw new UnsupportedOperationException();
                }

                public TextResourceFactory getText() {
                    throw new UnsupportedOperationException();
                }
            };
            return fileOperations -> resourceHandler;
        }

        FileHasher createFileHasher() {
            return new FileHasher(){

                public HashCode hash(File file) {
                    throw new UnsupportedOperationException();
                }

                public HashCode hash(File file, long length, long lastModified) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class WorkerDaemonServices
    extends WorkerSharedUserHomeScopeServices {
        private WorkerDaemonServices() {
        }

        ProviderFactory createProviderFactory() {
            return new DefaultProviderFactory();
        }

        IsolatableSerializerRegistry createIsolatableSerializerRegistry(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ManagedFactoryRegistry managedFactoryRegistry) {
            return new IsolatableSerializerRegistry(classLoaderHierarchyHasher, managedFactoryRegistry);
        }

        ActionExecutionSpecFactory createActionExecutionSpecFactory(IsolatableFactory isolatableFactory, IsolatableSerializerRegistry serializerRegistry) {
            return new DefaultActionExecutionSpecFactory(isolatableFactory, serializerRegistry);
        }

        ClassLoaderHierarchyHasher createClassLoaderHierarchyHasher() {
            return new ClassLoaderHierarchyHasher(){

                @Nullable
                public HashCode getClassLoaderHash(@Nonnull ClassLoader classLoader) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        DomainObjectCollectionFactory createDomainObjectCollectionFactory(InstantiatorFactory instantiatorFactory, ServiceRegistry services) {
            return new DefaultDomainObjectCollectionFactory(instantiatorFactory, services, CollectionCallbackActionDecorator.NOOP, MutationGuards.identity());
        }
    }
}

