/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.watch;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;

public interface FileWatcherRegistry
extends Closeable {
    public FileWatchingStatistics getStatistics();

    @Override
    public void close() throws IOException;

    public static class FileWatchingStatistics {
        private final boolean unknownEventEncountered;
        private final int numberOfReceivedEvents;
        private final Throwable errorWhileReceivingFileChanges;

        public Optional<Throwable> getErrorWhileReceivingFileChanges() {
            return Optional.ofNullable(this.errorWhileReceivingFileChanges);
        }

        public FileWatchingStatistics(boolean unknownEventEncountered, int numberOfReceivedEvents, @Nullable Throwable errorWhileReceivingFileChanges) {
            this.unknownEventEncountered = unknownEventEncountered;
            this.numberOfReceivedEvents = numberOfReceivedEvents;
            this.errorWhileReceivingFileChanges = errorWhileReceivingFileChanges;
        }

        public boolean isUnknownEventEncountered() {
            return this.unknownEventEncountered;
        }

        public int getNumberOfReceivedEvents() {
            return this.numberOfReceivedEvents;
        }
    }

    public static enum Type {
        CREATED,
        MODIFIED,
        REMOVED,
        INVALIDATE;

    }

    public static interface ChangeHandler {
        public void handleChange(Type var1, Path var2);

        public void handleLostState();
    }
}

