/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElementTypeHolderEP;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubSerializer;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public abstract class IStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    private static volatile boolean ourInitializedStubs;
    private static volatile Set<String> ourLazyExternalIds;
    private static final Logger LOG;

    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            IStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
        if (!this.isLazilyRegistered()) {
            IStubElementType.checkNotInstantiatedTooLate();
        }
    }

    public static void checkNotInstantiatedTooLate() {
        if (ourInitializedStubs) {
            LOG.error("All stub element types should be created before index initialization is complete.\nPlease add the class containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + Arrays.toString(StubElementTypeHolderEP.EP_NAME.getExtensions()));
        }
    }

    private boolean isLazilyRegistered() {
        try {
            return ourLazyExternalIds.contains(this.getExternalId());
        }
        catch (Throwable e) {
            return false;
        }
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    static {
        ourLazyExternalIds = Collections.emptySet();
        LOG = Logger.getInstance("#com.intellij.psi.stubs.IStubElementType");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/com/intellij/psi/stubs/IStubElementType", "<init>"));
    }
}

