/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeCheckerContext;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001aJ\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a.\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001c\u0010\u001f\u001a\u00020\u0010*\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\"H\u0002\u001a\u0012\u0010#\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010$\u001a\u00020\u0001*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015\u001a0\u0010%\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a6\u0010&\u001a\u00020\n*\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001aN\u0010'\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001aP\u0010*\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u001aN\u0010-\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010.\u001a\u00020\u0010\u001aN\u0010/\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010.\u001a\u00020\u0010\u001aN\u00100\u001a\u00020\n*\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u0002012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010.\u001a\u00020\u0010\u001a\n\u00102\u001a\u00020\u0001*\u00020\u0001\u00a8\u00063"}, d2={"argumentTypeWithSuspendConversion", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "expectedType", "argumentType", "captureFromTypeParameterUpperBoundIfNeeded", "checkApplicabilityForArgumentType", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/SimpleConstraintSystemConstraintPosition;", "isReceiver", "", "isDispatch", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "captureTypeFromExpressionOrNull", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getExpectedTypeForSAMConversion", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getExpectedTypeWithSAMConversion", "argument", "candidateExpectedType", "hasSupertypeWithGivenClassId", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeCheckerContext;", "isFunctional", "prepareCapturedType", "prepareExpectedType", "resolveArgument", "resolveArgumentExpression", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolvePlainArgumentType", "useNullableArgumentType", "resolvePlainExpressionArgument", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "varargElementType", "resolve"})
public final class ArgumentsKt {
    public static final void resolveArgumentExpression(@NotNull Candidate $this$resolveArgumentExpression, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType2, @Nullable FirTypeRef expectedTypeRef, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveArgumentExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirExpression firExpression2 = argument;
        if ((((firExpression2 instanceof FirFunctionCall ? true : firExpression2 instanceof FirWhenExpression) ? true : firExpression2 instanceof FirTryExpression) ? true : firExpression2 instanceof FirCheckNotNullCall) ? true : firExpression2 instanceof FirElvisExpression) {
            ArgumentsKt.resolveSubCallArgument$default($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)argument), expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
        } else if (firExpression2 instanceof FirSafeCallExpression) {
            FirQualifiedAccess nestedQualifier = ((FirSafeCallExpression)argument).getRegularQualifiedAccess();
            if (nestedQualifier instanceof FirExpression) {
                ArgumentsKt.resolveSubCallArgument($this$resolveArgumentExpression, csBuilder, nestedQualifier, expectedType2, sink, context2, isReceiver, isDispatch, true);
            } else {
                ConeKotlinType coneKotlinType;
                ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getUnit(), new ConeTypeProjection[0], false, null, 4, null), (coneKotlinType = expectedType2) == null ? null : coneKotlinType.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context2);
            }
        } else if (firExpression2 instanceof FirCallableReferenceAccess) {
            if (((FirCallableReferenceAccess)argument).getCalleeReference() instanceof FirResolvedNamedReference) {
                ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument, expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
            } else {
                PostponedArgumentsKt.preprocessCallableReference($this$resolveArgumentExpression, (FirCallableReferenceAccess)argument, expectedType2, context2);
            }
        } else if (firExpression2 instanceof FirAnonymousFunction) {
            PostponedArgumentsKt.preprocessLambdaArgument$default($this$resolveArgumentExpression, csBuilder, (FirAnonymousFunction)argument, expectedType2, expectedTypeRef, context2, false, null, 96, null);
        } else if (firExpression2 instanceof FirWrappedArgumentExpression) {
            ArgumentsKt.resolveArgumentExpression($this$resolveArgumentExpression, csBuilder, ((FirWrappedArgumentExpression)argument).getExpression(), expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        } else if (firExpression2 instanceof FirBlock) {
            ArgumentsKt.resolveBlockArgument($this$resolveArgumentExpression, csBuilder, (FirBlock)argument, expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        } else {
            ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument, expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
        }
    }

    private static final void resolveBlockArgument(Candidate $this$resolveBlockArgument, ConstraintSystemBuilder csBuilder, FirBlock block, ConeKotlinType expectedType2, FirTypeRef expectedTypeRef, CheckerSink sink, ResolutionContext context2, boolean isReceiver, boolean isDispatch) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            FirTypeRef $this$coneType$iv = block.getTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            ConeKotlinType coneKotlinType2 = expectedType2;
            ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, coneKotlinType, coneKotlinType2 == null ? null : coneKotlinType2.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context2);
            return;
        }
        for (FirExpression argument : returnArguments) {
            ArgumentsKt.resolveArgumentExpression($this$resolveBlockArgument, csBuilder, argument, expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        }
    }

    public static final void resolveSubCallArgument(@NotNull Candidate $this$resolveSubCallArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirResolvable argument, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveSubCallArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Candidate candidate2 = CandidateFactoryKt.candidate(argument);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument), expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
            return;
        }
        Candidate candidate3 = candidate2;
        FirBasedSymbol $this$firUnsafe$iv = candidate3.getSymbol();
        boolean $i$f$firUnsafe = false;
        Object fir$iv = $this$firUnsafe$iv.getFir();
        boolean bl = fir$iv instanceof FirTypedDeclaration;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypedDeclaration.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType$default((FirElement)fir$iv, null, 1, null);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ConeKotlinType type2 = context2.getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)((FirElement)fir$iv)).getType();
        ConeKotlinType argumentType = candidate3.getSubstitutor().substituteOrSelf(type2);
        ArgumentsKt.resolvePlainArgumentType($this$resolveSubCallArgument, csBuilder, argumentType, expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolveSubCallArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirResolvable firResolvable, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolveSubCallArgument(candidate2, constraintSystemBuilder, firResolvable, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainExpressionArgument(@NotNull Candidate $this$resolvePlainExpressionArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$resolvePlainExpressionArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (expectedType2 == null) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = argument.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) == null) {
            return;
        }
        ConeKotlinType argumentType = coneKotlinType;
        ArgumentsKt.resolvePlainArgumentType($this$resolvePlainExpressionArgument, csBuilder, argumentType, expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolvePlainExpressionArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirExpression firExpression2, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainExpressionArgument(candidate2, constraintSystemBuilder, firExpression2, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainArgumentType(@NotNull Candidate $this$resolvePlainArgumentType, @NotNull ConstraintSystemBuilder csBuilder, @NotNull ConeKotlinType argumentType, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$resolvePlainArgumentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SimpleConstraintSystemConstraintPosition position = SimpleConstraintSystemConstraintPosition.INSTANCE;
        FirSession session2 = context2.getSession();
        ConeKotlinType capturedType = ArgumentsKt.prepareCapturedType($this$resolvePlainArgumentType, argumentType, context2);
        ConeKotlinType argumentTypeForApplicabilityCheck = null;
        ConeKotlinType coneKotlinType2 = argumentTypeForApplicabilityCheck = useNullableArgumentType ? TypeUtilsKt.withNullability$default(capturedType, ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext(session2), null, 4, null) : capturedType;
        if (expectedType2 != null && (coneKotlinType = ArgumentsKt.argumentTypeWithSuspendConversion(session2, context2.getBodyResolveComponents().getScopeSession(), expectedType2, argumentTypeForApplicabilityCheck)) != null) {
            ConeKotlinType coneKotlinType3 = coneKotlinType;
            boolean bl = false;
            boolean bl2 = false;
            ConeKotlinType it = coneKotlinType3;
            boolean bl3 = false;
            argumentTypeForApplicabilityCheck = it;
            $this$resolvePlainArgumentType.getSubstitutor().substituteOrSelf(argumentTypeForApplicabilityCheck);
            $this$resolvePlainArgumentType.setUsesSuspendConversion(true);
        }
        ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argumentTypeForApplicabilityCheck, expectedType2, position, isReceiver, isDispatch, sink, context2);
    }

    public static /* synthetic */ void resolvePlainArgumentType$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainArgumentType(candidate2, constraintSystemBuilder, coneKotlinType, coneKotlinType2, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType argumentTypeWithSuspendConversion(FirSession session2, ScopeSession scopeSession, ConeKotlinType expectedType2, ConeKotlinType argumentType) {
        if (!(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        if (!InferenceUtilsKt.isSuspendFunctionType(expectedType2, session2) || InferenceUtilsKt.isSuspendFunctionType(argumentType, session2)) {
            return null;
        }
        ConeClassLikeType expectedFunctionalType = InferenceUtilsKt.suspendFunctionTypeToFunctionType(expectedType2, session2);
        if (InferenceUtilsKt.isSubtypeOfFunctionalType(argumentType, session2, expectedFunctionalType)) {
            ConeLookupTagBasedType coneLookupTagBasedType;
            FirFunctionSymbol<?> firFunctionSymbol = InferenceUtilsKt.findContributedInvokeSymbol(argumentType, session2, scopeSession, expectedFunctionalType, false);
            if (firFunctionSymbol == null) {
                coneLookupTagBasedType = null;
            } else {
                void $this$mapTo$iv$iv;
                FirFunctionSymbol<?> firFunctionSymbol2 = firFunctionSymbol;
                boolean bl = false;
                boolean bl2 = false;
                FirFunctionSymbol<?> invokeSymbol2 = firFunctionSymbol2;
                boolean bl3 = false;
                Iterable $this$map$iv = ((FirFunction)invokeSymbol2.getFir()).getValueParameters();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ConeKotlinType coneKotlinType;
                    void it;
                    FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    FirTypeRef $this$coneType$iv = it.getReturnTypeRef();
                    boolean $i$f$getConeType = false;
                    FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                    boolean $i$f$coneTypeUnsafe = false;
                    if (((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType() == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                    }
                    collection.add(coneKotlinType);
                }
                FirTypeRef $this$coneType$iv = ((FirFunction)invokeSymbol2.getFir()).getReturnTypeRef();
                boolean $i$f$getConeType = false;
                FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                if (coneKotlinType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                coneLookupTagBasedType = ResolveUtilsKt.createFunctionalType((List)destination$iv$iv, null, coneKotlinType, true, InferenceUtilsKt.isKFunctionType(argumentType, session2));
            }
            return coneLookupTagBasedType;
        }
        return null;
    }

    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull Candidate $this$prepareCapturedType, @NotNull ConeKotlinType argumentType, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareCapturedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConeKotlinType coneKotlinType = ArgumentsKt.captureTypeFromExpressionOrNull($this$prepareCapturedType, argumentType, context2);
        return coneKotlinType == null ? argumentType : coneKotlinType;
    }

    private static final ConeKotlinType captureTypeFromExpressionOrNull(Candidate $this$captureTypeFromExpressionOrNull, ConeKotlinType argumentType, ResolutionContext context2) {
        if (argumentType instanceof ConeFlexibleType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, ((ConeFlexibleType)argumentType).getLowerBound(), context2);
        }
        if (!(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        Object object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)argumentType, context2.getSession(), null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        ConeTypeProjection[] it = object;
        boolean bl3 = false;
        if (it != argumentType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, (ConeKotlinType)it, context2);
        }
        object = argumentType.getTypeArguments();
        bl = false;
        if (((ConeTypeProjection[])object).length == 0) {
            return null;
        }
        object = context2.getInferenceComponents().getCtx().captureFromArguments((SimpleTypeMarker)((Object)argumentType), CaptureStatus.FROM_EXPRESSION);
        return object instanceof ConeKotlinType ? (ConeKotlinType)object : null;
    }

    private static final void checkApplicabilityForArgumentType(ConstraintSystemBuilder csBuilder, ConeKotlinType argumentType, ConeKotlinType expectedType2, SimpleConstraintSystemConstraintPosition position, boolean isReceiver, boolean isDispatch, CheckerSink sink, ResolutionContext context2) {
        if (expectedType2 == null) {
            return;
        }
        if (isReceiver && isDispatch) {
            if (!ConeTypeUtilsKt.isNullable(expectedType2) && ConeTypeUtilsKt.isMarkedNullable(argumentType)) {
                sink.reportDiagnostic(InapplicableWrongReceiver.INSTANCE);
            }
            return;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType2, position)) {
            if (!isReceiver) {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
                return;
            }
            ConeKotlinType nullableExpectedType = TypeUtilsKt.withNullability$default(expectedType2, ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext(context2.getSession()), null, 4, null);
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportDiagnostic(InapplicableWrongReceiver.INSTANCE);
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
                sink.reportDiagnostic(InapplicableWrongReceiver.INSTANCE);
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull FirExpression argument, @Nullable FirValueParameter parameter, boolean isReceiver, @NotNull CheckerSink sink, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirExpression $this$resultType$iv = argument;
        boolean $i$f$getResultType = false;
        PhaseUtilsKt.ensureResolvedTypeDeclaration($this$resultType$iv.getTypeRef(), context2.getSession());
        ConeKotlinType expectedType2 = ArgumentsKt.prepareExpectedType($this$resolveArgument, context2.getSession(), argument, parameter, context2);
        FirValueParameter firValueParameter = parameter;
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument, $this$resolveArgument.getSystem().getBuilder(), argument, expectedType2, firValueParameter == null ? null : firValueParameter.getReturnTypeRef(), sink, context2, isReceiver, false);
    }

    private static final ConeKotlinType prepareExpectedType(Candidate $this$prepareExpectedType, FirSession session2, FirExpression argument, FirValueParameter parameter, ResolutionContext context2) {
        if (parameter == null) {
            return null;
        }
        ConeKotlinType basicExpectedType = ArgumentsKt.getExpectedTypeForSAMConversion(argument, parameter);
        ConeKotlinType coneKotlinType = ArgumentsKt.getExpectedTypeWithSAMConversion($this$prepareExpectedType, session2, argument, basicExpectedType, context2);
        ConeKotlinType expectedType2 = coneKotlinType == null ? basicExpectedType : coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType2);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(Candidate $this$getExpectedTypeWithSAMConversion, FirSession session2, FirExpression argument, ConeKotlinType candidateExpectedType, ResolutionContext context2) {
        Object object;
        if (InferenceUtilsKt.isBuiltinFunctionalType(candidateExpectedType, session2)) {
            return null;
        }
        Object obj = $this$getExpectedTypeWithSAMConversion.getSymbol().getFir();
        Object object2 = object = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (object == null) {
            return null;
        }
        FirFunction firFunction = object;
        if (!context2.getBodyResolveComponents().getSamResolver().shouldRunSamConversionForFunction(firFunction)) {
            return null;
        }
        if (!ArgumentsKt.isFunctional(argument, session2)) {
            return null;
        }
        object = context2.getBodyResolveComponents().getSamResolver().getFunctionTypeForPossibleSamType(candidateExpectedType);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$getExpectedTypeWithSAMConversion_u24lambda_u2d4 = object;
        boolean bl3 = false;
        $this$getExpectedTypeWithSAMConversion.setUsesSAM(true);
        return object;
    }

    public static final boolean isFunctional(@NotNull FirExpression $this$isFunctional, @NotNull FirSession session2) {
        boolean bl;
        FirExpression firExpression2;
        FirExpression firExpression3;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isFunctional, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Object object2 = object = $this$isFunctional instanceof FirWrappedArgumentExpression ? (FirWrappedArgumentExpression)$this$isFunctional : null;
        FirExpression firExpression4 = firExpression3 = object == null ? $this$isFunctional : ((firExpression2 = ((FirWrappedArgumentExpression)object).getExpression()) == null ? $this$isFunctional : firExpression2);
        if (firExpression3 instanceof FirAnonymousFunction ? true : firExpression3 instanceof FirCallableReferenceAccess) {
            bl = true;
        } else {
            FirTypeRef $this$coneTypeSafe$iv = $this$isFunctional.getTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl2 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            bl = Intrinsics.areEqual((Object)((object = coneKotlinType) == null ? null : Boolean.valueOf(InferenceUtilsKt.isBuiltinFunctionalType((ConeKotlinType)object, session2))), (Object)true);
        }
        return bl;
    }

    @NotNull
    public static final ConeKotlinType getExpectedTypeForSAMConversion(@NotNull FirExpression $this$getExpectedTypeForSAMConversion, @NotNull FirValueParameter parameter) {
        ConeKotlinType coneKotlinType;
        FirTypeRef $this$coneType$iv;
        boolean shouldUnwrapVarargType;
        Intrinsics.checkNotNullParameter((Object)$this$getExpectedTypeForSAMConversion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        FirExpression firExpression2 = $this$getExpectedTypeForSAMConversion;
        boolean bl = firExpression2 instanceof FirSpreadArgumentExpression ? !((FirSpreadArgumentExpression)$this$getExpectedTypeForSAMConversion).isSpread() : (shouldUnwrapVarargType = firExpression2 instanceof FirNamedArgumentExpression ? ((FirNamedArgumentExpression)$this$getExpectedTypeForSAMConversion).getExpression() instanceof FirConstExpression : true);
        if (parameter.isVararg() && shouldUnwrapVarargType) {
            $this$coneType$iv = parameter.getReturnTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            coneKotlinType = ArgumentsKt.varargElementType(coneKotlinType2);
        } else {
            $this$coneType$iv = parameter.getReturnTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType varargElementType(@NotNull ConeKotlinType $this$varargElementType) {
        Intrinsics.checkNotNullParameter((Object)$this$varargElementType, (String)"<this>");
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$varargElementType);
        return coneKotlinType == null ? $this$varargElementType : coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType2, @NotNull FirSession session2) {
        Object v1;
        ConeTypeCheckerContext context2;
        block8: {
            void $this$singleOrNull$iv;
            void $this$mapTo$iv$iv;
            ConeTypeParameterType coneTypeParameterType;
            Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
            Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypesKt.upperBoundIfFlexible(expectedType2));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeKotlinType coneKotlinType = ConeTypesKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType2 = coneTypeParameterType = coneKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneKotlinType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            FirTypeParameter typeParameter = (FirTypeParameter)simplifiedArgumentType.getLookupTag().getTypeParameterSymbol().getFir();
            context2 = SessionUtilsKt.getTypeCheckerContext(session2);
            Iterable $this$map$iv = typeParameter.getBounds();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ConeKotlinType coneKotlinType2;
                void it;
                FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void $this$coneType$iv = it;
                boolean $i$f$getConeType = false;
                void $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeUnsafe = false;
                if (((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType() == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                collection.add(coneKotlinType2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                if (!ArgumentsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context2)) continue;
                if (found$iv) {
                    v1 = null;
                    break block8;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        ConeKotlinType coneKotlinType = v1;
        if (coneKotlinType == null) {
            return argumentType;
        }
        ConeKotlinType chosenSupertype = coneKotlinType;
        ConeKotlinType coneKotlinType3 = (ConeKotlinType)context2.captureFromExpression(chosenSupertype);
        if (coneKotlinType3 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType3;
        return argumentType instanceof ConeDefinitelyNotNullType ? ((coneKotlinType3 = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, capturedType)) == null ? capturedType : coneKotlinType3) : capturedType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, ConeTypeCheckerContext context2) {
        boolean bl = false;
        boolean bl2 = false;
        ConeTypeCheckerContext $this$hasSupertypeWithGivenClassId_u24lambda_u2d7 = context2;
        boolean bl3 = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u2d7.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, (Function1<? super TypeConstructorMarker, Boolean>)((Function1)new Function1<TypeConstructorMarker, Boolean>(classId){
            final /* synthetic */ ClassId $classId;
            {
                this.$classId = $classId;
                super(1);
            }

            public final boolean invoke(@NotNull TypeConstructorMarker it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof ConeClassLikeLookupTag && Intrinsics.areEqual((Object)((ConeClassLikeLookupTag)it).getClassId(), (Object)this.$classId);
            }
        }));
    }
}

