/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class GradleModuleMetadataCompatibilityConverter {
    private static final Attribute<String> USAGE_STRING_ATTRIBUTE = Attribute.of((String)Usage.USAGE_ATTRIBUTE.getName(), String.class);
    private static final Attribute<String> LIBRARY_ELEMENTS_STRING_ATTRIBUTE = Attribute.of((String)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE.getName(), String.class);
    private final ImmutableAttributesFactory attributesFactory;
    private final NamedObjectInstantiator instantiator;

    public GradleModuleMetadataCompatibilityConverter(ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator instantiator) {
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator;
    }

    public void process(MutableModuleComponentResolveMetadata metaDataFromResource) {
        this.handleAttributeCompatibility(metaDataFromResource);
        this.handleMavenSnapshotCompatibility(metaDataFromResource);
    }

    private void handleMavenSnapshotCompatibility(MutableModuleComponentResolveMetadata metaDataFromResource) {
        if (metaDataFromResource.getId() instanceof MavenUniqueSnapshotComponentIdentifier) {
            MavenUniqueSnapshotComponentIdentifier uniqueIdentifier = (MavenUniqueSnapshotComponentIdentifier)metaDataFromResource.getId();
            for (MutableComponentVariant mutableComponentVariant : metaDataFromResource.getMutableVariants()) {
                List invalidFiles = null;
                for (ComponentVariant.File file : mutableComponentVariant.getFiles()) {
                    if (!file.getUri().contains("SNAPSHOT")) continue;
                    if (invalidFiles == null) {
                        invalidFiles = Lists.newArrayListWithExpectedSize((int)2);
                    }
                    invalidFiles.add(file);
                }
                if (invalidFiles == null) continue;
                for (ComponentVariant.File file : invalidFiles) {
                    mutableComponentVariant.removeFile(file);
                    mutableComponentVariant.addFile(file.getName(), file.getUri().replace("SNAPSHOT", uniqueIdentifier.getTimestamp()));
                }
            }
        }
    }

    private void handleAttributeCompatibility(MutableModuleComponentResolveMetadata metaDataFromResource) {
        for (MutableComponentVariant mutableComponentVariant : metaDataFromResource.getMutableVariants()) {
            String attributeValue;
            ImmutableAttributes attributes = mutableComponentVariant.getAttributes();
            ImmutableAttributes updatedAttributes = ImmutableAttributes.EMPTY;
            if (attributes.contains(USAGE_STRING_ATTRIBUTE) && (attributeValue = (String)attributes.getAttribute(USAGE_STRING_ATTRIBUTE)).endsWith("-jars")) {
                updatedAttributes = this.attributesFactory.concat(updatedAttributes, USAGE_STRING_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot(attributeValue.replace("-jars", ""), this.instantiator));
            }
            if (!updatedAttributes.isEmpty() && !attributes.contains(LIBRARY_ELEMENTS_STRING_ATTRIBUTE)) {
                updatedAttributes = this.attributesFactory.concat(updatedAttributes, LIBRARY_ELEMENTS_STRING_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("jar", this.instantiator));
            }
            if (updatedAttributes.isEmpty()) continue;
            updatedAttributes = this.attributesFactory.concat(attributes, updatedAttributes);
            mutableComponentVariant.setAttributes(updatedAttributes);
        }
    }
}

