/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithStaticLibrary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppStaticLibrary
extends DefaultCppBinary
implements CppStaticLibrary,
ConfigurableComponentWithStaticLibrary,
ConfigurableComponentWithLinkUsage,
ConfigurableComponentWithRuntimeUsage,
SoftwareComponentInternal {
    private final RegularFileProperty linkFile;
    private final Property<Task> linkFileProducer;
    private final Property<CreateStaticLibrary> createTaskProperty;
    private final Property<Configuration> linkElements;
    private final Property<Configuration> runtimeElements;
    private final ConfigurableFileCollection outputs;

    @Inject
    public DefaultCppStaticLibrary(Names names, ObjectFactory objectFactory, Provider<String> baseName, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration implementation, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        super(names, objectFactory, baseName, sourceFiles, componentHeaderDirs, configurations, implementation, targetPlatform, toolChain, platformToolProvider, identity);
        this.linkFile = objectFactory.fileProperty();
        this.linkFileProducer = objectFactory.property(Task.class);
        this.createTaskProperty = objectFactory.property(CreateStaticLibrary.class);
        this.linkElements = objectFactory.property(Configuration.class);
        this.runtimeElements = objectFactory.property(Configuration.class);
        this.outputs = objectFactory.fileCollection();
    }

    @Override
    public ConfigurableFileCollection getOutputs() {
        return this.outputs;
    }

    public RegularFileProperty getLinkFile() {
        return this.linkFile;
    }

    @Override
    public Property<Task> getLinkFileProducer() {
        return this.linkFileProducer;
    }

    @Override
    public Property<CreateStaticLibrary> getCreateTask() {
        return this.createTaskProperty;
    }

    @Override
    public Property<Configuration> getLinkElements() {
        return this.linkElements;
    }

    @Override
    public Property<Configuration> getRuntimeElements() {
        return this.runtimeElements;
    }

    @Override
    @Nullable
    public Linkage getLinkage() {
        return Linkage.STATIC;
    }

    @Override
    public boolean hasRuntimeFile() {
        return false;
    }

    @Override
    public Provider<RegularFile> getRuntimeFile() {
        return Providers.notDefined();
    }

    public Set<? extends UsageContext> getUsages() {
        Configuration linkElements = (Configuration)this.getLinkElements().get();
        Configuration runtimeElements = (Configuration)this.getRuntimeElements().get();
        return Sets.newHashSet((Object[])new DefaultUsageContext[]{new DefaultUsageContext(this.getIdentity().getLinkUsageContext(), (Set<? extends PublishArtifact>)linkElements.getAllArtifacts(), linkElements), new DefaultUsageContext(this.getIdentity().getRuntimeUsageContext(), (Set<? extends PublishArtifact>)runtimeElements.getAllArtifacts(), runtimeElements)});
    }

    @Override
    public AttributeContainer getLinkAttributes() {
        return this.getIdentity().getLinkUsageContext().getAttributes();
    }

    @Override
    public AttributeContainer getRuntimeAttributes() {
        return this.getIdentity().getRuntimeUsageContext().getAttributes();
    }

    public ModuleVersionIdentifier getCoordinates() {
        return this.getIdentity().getCoordinates();
    }
}

