/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import java.util.Collections;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

public class TestMainAction
implements Runnable {
    private final Runnable detector;
    private final TestClassProcessor processor;
    private final TestResultProcessor resultProcessor;
    private final WorkerLeaseService workerLeaseService;
    private final Clock clock;
    private final Object rootTestSuiteId;
    private final String displayName;

    public TestMainAction(Runnable detector, TestClassProcessor processor, TestResultProcessor resultProcessor, WorkerLeaseService workerLeaseService, Clock clock, Object rootTestSuiteId, String displayName) {
        this.detector = detector;
        this.processor = processor;
        this.resultProcessor = new AttachParentTestResultProcessor(resultProcessor);
        this.workerLeaseService = workerLeaseService;
        this.clock = clock;
        this.rootTestSuiteId = rootTestSuiteId;
        this.displayName = displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RootTestSuiteDescriptor suite = new RootTestSuiteDescriptor(this.rootTestSuiteId, this.displayName);
        this.resultProcessor.started(suite, new TestStartEvent(this.clock.getCurrentTime()));
        try {
            this.processor.startProcessing(this.resultProcessor);
            try {
                this.detector.run();
            }
            catch (Throwable throwable) {
                WorkerLeaseRegistry.WorkerLease currentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
                this.workerLeaseService.withoutLocks(Collections.singletonList(currentWorkerLease), new Runnable(){

                    @Override
                    public void run() {
                        TestMainAction.this.processor.stop();
                    }
                });
                throw throwable;
            }
            WorkerLeaseRegistry.WorkerLease currentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
            this.workerLeaseService.withoutLocks(Collections.singletonList(currentWorkerLease), new /* invalid duplicate definition of identical inner class */);
        }
        finally {
            this.resultProcessor.completed(suite.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }

    private static final class RootTestSuiteDescriptor
    extends DefaultTestSuiteDescriptor {
        private RootTestSuiteDescriptor(Object id, String name) {
            super(id, name);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

