/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExternalAnnotationsManager;
import org.jetbrains.kotlin.com.intellij.codeInsight.InferredAnnotationsManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.Processors;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class AnnotationUtil {
    private static final String[] SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(0);
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(1);
        }
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet(annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(4);
        }
        if (listOwner == null) {
            return null;
        }
        List<PsiAnnotation> result2 = AnnotationUtil.findAllAnnotations(listOwner, annotationNames, skipExternal);
        return result2.isEmpty() ? null : result2.get(0);
    }

    @NotNull
    public static List<PsiAnnotation> findAllAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(5);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(6);
        }
        List<PsiAnnotation> ownAnnotations = AnnotationUtil.findOwnAnnotations(listOwner, annotationNames);
        List<PsiAnnotation> nonCodeAnnotations = skipExternal ? null : AnnotationUtil.findNonCodeAnnotations(listOwner, annotationNames);
        SmartList annotations2 = null;
        if (ownAnnotations != null || nonCodeAnnotations != null) {
            annotations2 = new SmartList();
            if (ownAnnotations != null) {
                annotations2.addAll(ownAnnotations);
            }
            if (nonCodeAnnotations != null) {
                annotations2.addAll(nonCodeAnnotations);
            }
        }
        List<PsiAnnotation> list2 = annotations2 == null ? Collections.emptyList() : annotations2;
        if (list2 == null) {
            AnnotationUtil.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Nullable
    private static List<PsiAnnotation> findOwnAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        PsiModifierList list2;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(8);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(9);
        }
        if ((list2 = listOwner.getModifierList()) == null) {
            return null;
        }
        SmartList<PsiAnnotation> result2 = null;
        for (PsiAnnotation annotation2 : list2.getAnnotations()) {
            if (!ContainerUtil.exists(annotationNames, annotation2::hasQualifiedName) || !AnnotationUtil.isApplicableToDeclaration(annotation2, list2)) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiAnnotation>();
            }
            result2.add(annotation2);
        }
        return result2;
    }

    private static boolean isApplicableToDeclaration(PsiAnnotation annotation2, PsiModifierList list2) {
        PsiAnnotation.TargetType[] allTargets = AnnotationTargetUtil.getTargetsForLocation(list2);
        if (allTargets.length == 0) {
            return true;
        }
        PsiAnnotation.TargetType[] nonTypeUse = (PsiAnnotation.TargetType[])Stream.of(allTargets).filter(t -> t != PsiAnnotation.TargetType.TYPE_USE).toArray(PsiAnnotation.TargetType[]::new);
        return AnnotationTargetUtil.findAnnotationTarget(annotation2, nonTypeUse) != null;
    }

    @Nullable
    private static List<PsiAnnotation> findNonCodeAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(10);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(11);
        }
        if (listOwner instanceof PsiLocalVariable) {
            return null;
        }
        Map map = (Map)CachedValuesManager.getCachedValue(listOwner, () -> {
            ConcurrentMap<Collection, List> value2 = ConcurrentFactoryMap.createMap(annotationNames1 -> {
                PsiUtilCore.ensureValid(listOwner);
                Project project = listOwner.getProject();
                SmartList<PsiAnnotation> annotations2 = null;
                ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    List<PsiAnnotation> externalAnnotations = externalAnnotationsManager.findExternalAnnotations(listOwner, annotationName);
                    if (externalAnnotations.isEmpty()) continue;
                    if (annotations2 == null) {
                        annotations2 = new SmartList<PsiAnnotation>();
                    }
                    annotations2.addAll(externalAnnotations);
                }
                InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation2 = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                    if (annotation2 == null) continue;
                    if (annotations2 == null) {
                        annotations2 = new SmartList();
                    }
                    annotations2.add(annotation2);
                }
                return annotations2;
            });
            return CachedValueProvider.Result.create(value2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        return (List)map.get(annotationNames);
    }

    @NotNull
    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(@NotNull T element) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(16);
        }
        List list2 = (List)CachedValuesManager.getCachedValue(element, () -> {
            List<Object> list2;
            LinkedHashSet result2 = new LinkedHashSet();
            if (element instanceof PsiMethod) {
                if (!element.hasModifierProperty("static")) {
                    AnnotationUtil.collectSuperMethods(result2, ((PsiMethod)element).getHierarchicalMethodSignature(), element, JavaPsiFacade.getInstance(element.getProject()).getResolveHelper());
                }
            } else if (element instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)element, false, Processors.cancelableCollectProcessor(result2));
            } else if (element instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result2, (PsiParameter)element);
            }
            if (result2.isEmpty()) {
                list2 = Collections.emptyList();
            } else {
                PsiModifierListOwner[] array = result2.toArray(new PsiModifierListOwner[0]);
                list2 = Arrays.asList(array);
            }
            return CachedValueProvider.Result.create(list2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        if (list2 == null) {
            AnnotationUtil.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames, boolean skipExternal) {
        PsiAnnotation directAnnotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(20);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(21);
        }
        if ((directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames, skipExternal)) != null) {
            return directAnnotation;
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
            PsiAnnotation annotation2 = AnnotationUtil.findAnnotation(superOwner, annotationNames, skipExternal);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    private static void collectSuperParameters(@NotNull Set<? super PsiModifierListOwner> result2, @NotNull PsiParameter parameter) {
        block7: {
            PsiElement scope2;
            Consumer<PsiMethod> forEachSuperMethod;
            block6: {
                PsiElement parent2;
                if (result2 == null) {
                    AnnotationUtil.$$$reportNull$$$0(22);
                }
                if (parameter == null) {
                    AnnotationUtil.$$$reportNull$$$0(23);
                }
                if (!((parent2 = parameter.getParent()) instanceof PsiParameterList)) {
                    return;
                }
                int index2 = ((PsiParameterList)parent2).getParameterIndex(parameter);
                forEachSuperMethod = method -> {
                    PsiParameter[] superParameters = method.getParameterList().getParameters();
                    if (index2 < superParameters.length) {
                        result2.add(superParameters[index2]);
                    }
                };
                scope2 = parent2.getParent();
                if (!(scope2 instanceof PsiLambdaExpression)) break block6;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope2).getFunctionalInterfaceType());
                if (method2 == null) break block7;
                forEachSuperMethod.consume(method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume(superMethod);
                }
                break block7;
            }
            if (scope2 instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope2)) {
                    forEachSuperMethod.consume(superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<? super PsiModifierListOwner> result2, @NotNull HierarchicalMethodSignature signature2, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (result2 == null) {
            AnnotationUtil.$$$reportNull$$$0(24);
        }
        if (signature2 == null) {
            AnnotationUtil.$$$reportNull$$$0(25);
        }
        if (place == null) {
            AnnotationUtil.$$$reportNull$$$0(26);
        }
        if (resolveHelper == null) {
            AnnotationUtil.$$$reportNull$$$0(27);
        }
        for (HierarchicalMethodSignature superSignature : signature2.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result2.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result2, superSignature, place, resolveHelper);
        }
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiAnnotation findAnnotationInTypeHierarchy(@Nullable PsiType type2, @NotNull Set<String> qualifiedNames) {
        if (qualifiedNames == null) {
            AnnotationUtil.$$$reportNull$$$0(28);
        }
        if (type2 == null) {
            return null;
        }
        Ref<Object> result2 = Ref.create(null);
        InheritanceUtil.processSuperTypes(type2, true, eachType -> {
            for (PsiAnnotation annotation2 : eachType.getAnnotations()) {
                String qualifiedName = annotation2.getQualifiedName();
                if (!qualifiedNames.contains(qualifiedName)) continue;
                result2.set(annotation2);
                return false;
            }
            return !(eachType instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly(eachType) instanceof PsiTypeParameter;
        });
        return result2.get();
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2, int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(29);
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(30);
        }
        return annotations2.stream().anyMatch(annotation2 -> AnnotationUtil.isAnnotated(listOwner, annotation2, flags, null));
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, int flags, @Nullable Set<? super PsiMember> processed) {
        block20: {
            block21: {
                Project project;
                PsiModifierList modifierList2;
                if (listOwner == null) {
                    AnnotationUtil.$$$reportNull$$$0(33);
                }
                if (annotationFQN == null) {
                    AnnotationUtil.$$$reportNull$$$0(34);
                }
                if ((modifierList2 = listOwner.getModifierList()) == null) {
                    return false;
                }
                PsiAnnotation annotation2 = modifierList2.findAnnotation(annotationFQN);
                if (annotation2 != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 8)) {
                    PsiType type2 = null;
                    if (listOwner instanceof PsiMethod) {
                        type2 = ((PsiMethod)listOwner).getReturnType();
                    } else if (listOwner instanceof PsiParameter && listOwner.getParent() instanceof PsiParameterList && listOwner.getParent().getParent() instanceof PsiLambdaExpression) {
                        if (((PsiParameter)listOwner).getTypeElement() != null) {
                            type2 = ((PsiParameter)listOwner).getType();
                        }
                    } else if (listOwner instanceof PsiVariable) {
                        type2 = ((PsiVariable)listOwner).getType();
                    }
                    if (type2 != null && type2.hasAnnotation(annotationFQN)) {
                        return true;
                    }
                }
                if (BitUtil.isSet(flags, 2) && ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 4) && InferredAnnotationsManager.getInstance(project = listOwner.getProject()).findInferredAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!BitUtil.isSet(flags, 1)) break block20;
                if (!(listOwner instanceof PsiMethod)) break block21;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet();
                }
                if (!processed.add((PsiMember)method)) {
                    return false;
                }
                for (PsiMethod superMethod : method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, flags, (Set<? super PsiMember>)processed)) continue;
                    return true;
                }
                break block20;
            }
            if (!(listOwner instanceof PsiClass)) break block20;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, flags, (Set<? super PsiMember>)processed)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation2, @Nullable(value="null means 'value'") @Nullable(value="null means 'value'") String attributeName) {
        if (annotation2 == null) {
            AnnotationUtil.$$$reportNull$$$0(53);
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation2.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Objects.equals(name, attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 18: 
            case 20: 
            case 29: 
            case 31: 
            case 33: 
            case 51: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 16: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 30: 
            case 38: 
            case 58: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqn";
                break;
            }
            case 34: 
            case 37: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 44: 
            case 45: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations1";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations2";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAnnotations";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotations";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperAnnotationOwners";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAnnotationMap";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayAttributeValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllAnnotations";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOwnAnnotations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findNonCodeAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuperAnnotationOwners";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInHierarchy";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperParameters";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperMethods";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInTypeHierarchy";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatingApplicable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotatedUsingPatterns";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMethod";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isInsideAnnotation";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 46: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttributeValue";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanAttributeValue";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLongAttributeValue";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredStringAttributeValue";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttribute";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fillValueMap";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotationMap";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isJetbrainsAnnotation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 42: 
            case 59: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

