/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.URandomKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.JsMappingKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheInfo;
import org.jetbrains.kotlin.ir.backend.js.ic.DataKt;
import org.jetbrains.kotlin.ir.backend.js.ic.IcCacheInfo;
import org.jetbrains.kotlin.ir.backend.js.ic.IcKt;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcData;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.impl.IrFileReadersKt;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolverKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\u001ah\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u001a(\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0006\u001a$\u0010\u001d\u001a\u00020\u0001*\u00020\u001e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010 H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!\"\u0013\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"compilerVersion", "Lkotlin/ULong;", "J", "buildCache", "", "cachePath", "", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "mainModule", "Lorg/jetbrains/kotlin/ir/backend/js/MainModule$Klib;", "analyzer", "Lorg/jetbrains/kotlin/analyzer/AbstractAnalyzerWithCompilerReport;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "allDependencies", "Lorg/jetbrains/kotlin/library/resolver/KotlinLibraryResolveResult;", "friendDependencies", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "forceClean", "icCache", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IcCacheInfo;", "checkCaches", "cachePaths", "skipLib", "md5", "Ljava/io/File;", "additional", "", "(Ljava/io/File;Ljava/lang/Iterable;)J", "backend.js"})
public final class FileUtilKt {
    private static final long compilerVersion = URandomKt.nextULong((Random)((Random)Random.Default));

    /*
     * WARNING - void declaration
     */
    public static final boolean buildCache(@NotNull String cachePath, @NotNull Project project, @NotNull MainModule.Klib mainModule, @NotNull AbstractAnalyzerWithCompilerReport analyzer2, @NotNull CompilerConfiguration configuration, @NotNull KotlinLibraryResolveResult allDependencies, @NotNull List<? extends KotlinLibrary> friendDependencies, @NotNull Set<FqName> exportedDeclarations, boolean forceClean, @NotNull IcCacheInfo icCache) {
        CacheInfo oldCacheInfo;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cachePath, (String)"cachePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)analyzer2, (String)"analyzer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)allDependencies, (String)"allDependencies");
        Intrinsics.checkNotNullParameter(friendDependencies, (String)"friendDependencies");
        Intrinsics.checkNotNullParameter(exportedDeclarations, (String)"exportedDeclarations");
        Intrinsics.checkNotNullParameter((Object)icCache, (String)"icCache");
        Iterable $this$mapNotNull$iv = allDependencies.getFullList(KotlinLibraryResolverKt.getTopologicalLibraryOrder());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ULong uLong;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinLibrary it = (KotlinLibrary)element$iv$iv;
            boolean bl2 = false;
            String path2 = it.getLibraryFile().getAbsolutePath();
            if (icCache.getMd5().get(path2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ULong it$iv$iv = uLong;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List dependencyHashes = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)ULong.box-impl((long)compilerVersion));
        long md5 = FileUtilKt.md5(IrFileReadersKt.javaFile(mainModule.getLib().getLibraryFile()), dependencyHashes);
        if (!forceClean && (oldCacheInfo = CacheInfo.Companion.load(cachePath)) != null && md5 == oldCacheInfo.getMd5-s-VKNKU()) {
            return false;
        }
        File icDir = new File(cachePath);
        FilesKt.deleteRecursively((File)icDir);
        icDir.mkdirs();
        SerializedIcData icData = IcKt.prepareSingleLibraryIcCache(project, analyzer2, configuration, mainModule.getLib(), allDependencies, friendDependencies, exportedDeclarations, icCache.getData());
        DataKt.writeTo(icData, new File(cachePath));
        new CacheInfo(cachePath, mainModule.getLib().getLibraryFile().getAbsolutePath(), md5, null).save();
        return true;
    }

    public static /* synthetic */ boolean buildCache$default(String string2, Project project, MainModule.Klib klib, AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport, CompilerConfiguration compilerConfiguration, KotlinLibraryResolveResult kotlinLibraryResolveResult, List list2, Set set, boolean bl, IcCacheInfo icCacheInfo, int n, Object object) {
        if ((n & 0x80) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x100) != 0) {
            bl = false;
        }
        if ((n & 0x200) != 0) {
            icCacheInfo = IcCacheInfo.Companion.getEMPTY();
        }
        return FileUtilKt.buildCache(string2, project, klib, abstractAnalyzerWithCompilerReport, compilerConfiguration, kotlinLibraryResolveResult, list2, set, bl, icCacheInfo);
    }

    private static final long md5(File $this$md5, Iterable<ULong> additional) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        Iterator<ULong> iterator2 = additional.iterator();
        while (iterator2.hasNext()) {
            long ul = iterator2.next().unbox-impl();
            boolean bl = false;
            md5.update(JsMappingKt.toByteArray(ul));
        }
        FileUtilKt.md5$process$default($this$md5, md5, null, 2, null);
        byte[] d = md5.digest();
        byte by = d[0];
        boolean bl = false;
        long l = ULong.constructor-impl((long)by);
        long l2 = 255L;
        boolean bl2 = false;
        l = ULong.constructor-impl((long)(l & l2));
        byte by2 = d[1];
        boolean bl3 = false;
        long l3 = ULong.constructor-impl((long)by2);
        long l4 = 255L;
        boolean bl4 = false;
        l3 = ULong.constructor-impl((long)(l3 & l4));
        int n = 8;
        boolean bl5 = false;
        l3 = ULong.constructor-impl((long)(l3 << n));
        n = 0;
        l = ULong.constructor-impl((long)(l | l3));
        byte by3 = d[2];
        bl3 = false;
        long l5 = ULong.constructor-impl((long)by3);
        long l6 = 255L;
        bl4 = false;
        l5 = ULong.constructor-impl((long)(l5 & l6));
        int n2 = 16;
        bl5 = false;
        l5 = ULong.constructor-impl((long)(l5 << n2));
        n2 = 0;
        l = ULong.constructor-impl((long)(l | l5));
        byte by4 = d[3];
        bl3 = false;
        long l7 = ULong.constructor-impl((long)by4);
        long l8 = 255L;
        bl4 = false;
        l7 = ULong.constructor-impl((long)(l7 & l8));
        int n3 = 24;
        bl5 = false;
        l7 = ULong.constructor-impl((long)(l7 << n3));
        n3 = 0;
        l = ULong.constructor-impl((long)(l | l7));
        byte by5 = d[4];
        bl3 = false;
        long l9 = ULong.constructor-impl((long)by5);
        long l10 = 255L;
        bl4 = false;
        l9 = ULong.constructor-impl((long)(l9 & l10));
        int n4 = 32;
        bl5 = false;
        l9 = ULong.constructor-impl((long)(l9 << n4));
        n4 = 0;
        l = ULong.constructor-impl((long)(l | l9));
        byte by6 = d[5];
        bl3 = false;
        long l11 = ULong.constructor-impl((long)by6);
        long l12 = 255L;
        bl4 = false;
        l11 = ULong.constructor-impl((long)(l11 & l12));
        int n5 = 40;
        bl5 = false;
        l11 = ULong.constructor-impl((long)(l11 << n5));
        n5 = 0;
        l = ULong.constructor-impl((long)(l | l11));
        byte by7 = d[6];
        bl3 = false;
        long l13 = ULong.constructor-impl((long)by7);
        long l14 = 255L;
        bl4 = false;
        l13 = ULong.constructor-impl((long)(l13 & l14));
        int n6 = 48;
        bl5 = false;
        l13 = ULong.constructor-impl((long)(l13 << n6));
        n6 = 0;
        l = ULong.constructor-impl((long)(l | l13));
        byte by8 = d[7];
        bl3 = false;
        long l15 = ULong.constructor-impl((long)by8);
        long l16 = 255L;
        bl4 = false;
        l15 = ULong.constructor-impl((long)(l15 & l16));
        int n7 = 56;
        bl5 = false;
        l15 = ULong.constructor-impl((long)(l15 << n7));
        n7 = 0;
        return ULong.constructor-impl((long)(l | l15));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IcCacheInfo checkCaches(@NotNull KotlinLibraryResolveResult allDependencies, @NotNull List<String> cachePaths, @Nullable String skipLib) {
        void $this$mapTo$iv$iv;
        String $this$map$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        Collection collection;
        Object object2;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)allDependencies, (String)"allDependencies");
        Intrinsics.checkNotNullParameter(cachePaths, (String)"cachePaths");
        Iterable $this$map$iv2 = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(allDependencies, null, 1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            object2 = (KotlinLibrary)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getLibraryFile().getAbsolutePath();
            collection.add(object);
        }
        Set allLibs = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (Object)skipLib);
        Iterable $this$map$iv3 = cachePaths;
        boolean $i$f$map22 = false;
        destination$iv$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            CacheInfo cacheInfo = CacheInfo.Companion.load((String)it);
            if (cacheInfo == null) {
                String string2 = Intrinsics.stringPlus((String)"Cannot load IC cache from ", (Object)it);
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            object = cacheInfo;
            collection.add(object);
        }
        List caches = (List)destination$iv$iv2;
        Iterable $i$f$map22 = caches;
        collection = allLibs;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CacheInfo bl2 = (CacheInfo)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            String string3 = it.getLibPath();
            object.add(string3);
        }
        object = (List)destination$iv$iv3;
        Set missedLibs = SetsKt.minus((Set)collection, (Iterable)((Iterable)object));
        if (!missedLibs.isEmpty()) {
            $this$map$iv = Intrinsics.stringPlus((String)"Missing caches for libraries: ", (Object)missedLibs);
            $i$f$map3 = false;
            throw (Throwable)new IllegalStateException($this$map$iv.toString());
        }
        $i$f$map3 = false;
        Map result2 = new LinkedHashMap();
        boolean bl = false;
        Map md5 = new LinkedHashMap();
        for (CacheInfo c : caches) {
            if (!allLibs.contains(c.getLibPath())) {
                String string4 = Intrinsics.stringPlus((String)"Missing library: ", (Object)c.getLibPath());
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            Map map = result2;
            object2 = c.getLibPath();
            SerializedIcData serializedIcData = DataKt.readIcData(new File(c.getPath()));
            boolean bl5 = false;
            map.put(object2, serializedIcData);
            map = md5;
            object2 = c.getLibPath();
            serializedIcData = ULong.box-impl((long)c.getMd5-s-VKNKU());
            bl5 = false;
            map.put(object2, serializedIcData);
        }
        return new IcCacheInfo(result2, md5);
    }

    public static /* synthetic */ IcCacheInfo checkCaches$default(KotlinLibraryResolveResult kotlinLibraryResolveResult, List list2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return FileUtilKt.checkCaches(kotlinLibraryResolveResult, list2, string2);
    }

    private static final void md5$process(File $this$md5_u24process, MessageDigest md5, String prefix) {
        if ($this$md5_u24process.isDirectory()) {
            Object[] objectArray = $this$md5_u24process.listFiles();
            Intrinsics.checkNotNull((Object)objectArray);
            Object[] $this$sortedBy$iv = objectArray;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            Iterable $this$forEach$iv = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    File it = (File)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                String string2 = Intrinsics.stringPlus((String)prefix, (Object)it.getName());
                Charset charset = Charsets.UTF_8;
                boolean bl3 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                md5.update(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                FileUtilKt.md5$process(it, md5, prefix + it.getName() + '/');
            }
        } else {
            md5.update(FilesKt.readBytes((File)$this$md5_u24process));
        }
    }

    static /* synthetic */ void md5$process$default(File file2, MessageDigest messageDigest, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        FileUtilKt.md5$process(file2, messageDigest, string2);
    }
}

