/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;

public class DefaultResolvedComponentResult
implements ResolvedComponentResultInternal {
    private final ModuleVersionIdentifier moduleVersion;
    private final Set<DependencyResult> dependencies = new LinkedHashSet<DependencyResult>();
    private final Set<ResolvedDependencyResult> dependents = new LinkedHashSet<ResolvedDependencyResult>();
    private final ComponentSelectionReason selectionReason;
    private final ComponentIdentifier componentId;
    private final List<ResolvedVariantResult> selectedVariants;
    private final List<ResolvedVariantResult> allVariants;
    private final String repositoryName;
    private final Multimap<ResolvedVariantResult, DependencyResult> variantDependencies = ArrayListMultimap.create();

    public DefaultResolvedComponentResult(ModuleVersionIdentifier moduleVersion, ComponentSelectionReason selectionReason, ComponentIdentifier componentId, List<ResolvedVariantResult> selectedVariants, List<ResolvedVariantResult> allVariants, String repositoryName) {
        this.moduleVersion = moduleVersion;
        this.selectionReason = selectionReason;
        this.componentId = componentId;
        this.selectedVariants = selectedVariants;
        this.allVariants = allVariants;
        this.repositoryName = repositoryName;
    }

    public ComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    @Nullable
    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Set<DependencyResult> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public Set<ResolvedDependencyResult> getDependents() {
        return Collections.unmodifiableSet(this.dependents);
    }

    public DefaultResolvedComponentResult addDependency(DependencyResult dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public DefaultResolvedComponentResult addDependent(ResolvedDependencyResult dependent) {
        this.dependents.add(dependent);
        return this;
    }

    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    @Nullable
    public ModuleVersionIdentifier getModuleVersion() {
        return this.moduleVersion;
    }

    public String toString() {
        return this.getId().getDisplayName();
    }

    public List<ResolvedVariantResult> getVariants() {
        return this.selectedVariants;
    }

    @Override
    public List<ResolvedVariantResult> getAllVariants() {
        return this.allVariants;
    }

    public List<DependencyResult> getDependenciesForVariant(ResolvedVariantResult variant) {
        if (!this.selectedVariants.contains(variant)) {
            this.reportInvalidVariant(variant);
        }
        return ImmutableList.copyOf((Collection)this.variantDependencies.get((Object)variant));
    }

    private void reportInvalidVariant(ResolvedVariantResult variant) {
        Optional<ResolvedVariantResult> sameName = this.selectedVariants.stream().filter(v -> v.getDisplayName().equals(variant.getDisplayName())).findFirst();
        String moreInfo = sameName.isPresent() ? "A variant with the same name exists but is not the same instance." : "There's no resolved variant with the same name.";
        throw new InvalidUserCodeException("Variant '" + variant.getDisplayName() + "' doesn't belong to resolved component '" + this + "'. " + moreInfo + " Most likely you are using a variant from another component to get the dependencies of this component.");
    }

    public void associateDependencyToVariant(DependencyResult dependencyResult, ResolvedVariantResult fromVariant) {
        this.variantDependencies.put((Object)fromVariant, (Object)dependencyResult);
    }
}

