/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.Problem;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.DefaultPluginId;
import org.gradle.util.internal.TextUtil;

public class TypeValidationProblemRenderer {
    public static String renderMinimalInformationAbout(Problem problem) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, true);
    }

    public static String renderMinimalInformationAbout(Problem problem, boolean renderDocLink) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, renderDocLink, true);
    }

    public static String renderMinimalInformationAbout(Problem problem, boolean renderDocLink, boolean renderSolutions) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(TypeValidationProblemRenderer.introductionFor(problem.getAdditionalData()) + TextUtil.endLineWithDot((String)problem.getLabel()));
        Optional.ofNullable(problem.getDetails()).ifPresent(reason -> {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)problem.getDetails())));
        });
        if (renderSolutions) {
            TypeValidationProblemRenderer.renderNewSolutions(formatter, problem.getSolutions());
        }
        if (renderDocLink) {
            Optional.ofNullable(problem.getDocumentationLink()).ifPresent(docLink -> {
                formatter.blankLine();
                formatter.node(new DocumentationRegistry().getDocumentationRecommendationFor("information", docLink));
            });
        }
        return formatter.toString();
    }

    private static void renderNewSolutions(TreeFormatter formatter, List<String> possibleSolutions) {
        int solutionCount = possibleSolutions.size();
        if (solutionCount > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)possibleSolutions.get(0))));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize((String)TextUtil.endLineWithDot((String)solution))));
                formatter.endChildren();
            }
        }
    }

    public static void renderSolutionsWithNewProblemsApi(TreeFormatter formatter, List<String> possibleSolutions) {
        int solutionCount = possibleSolutions.size();
        if (solutionCount > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)possibleSolutions.get(0))));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize((String)TextUtil.endLineWithDot((String)solution))));
                formatter.endChildren();
            }
        }
    }

    public static String convertToSingleLine(String message) {
        return message.replaceAll("(\\r?\\n *)+", ". ").replaceAll("[.]+", ".").replaceAll("[ ]+", " ").replaceAll(": ?[. ]", ": ");
    }

    public static String introductionFor(Map<String, String> additionalMetadata) {
        String property;
        boolean typeRelevant;
        StringBuilder builder = new StringBuilder();
        String rootType = Optional.ofNullable(additionalMetadata.get("typeName")).filter(TypeValidationProblemRenderer::shouldRenderType).orElse(null);
        DefaultPluginId pluginId = Optional.ofNullable(additionalMetadata.get("pluginId")).map(DefaultPluginId::new).orElse(null);
        boolean bl = typeRelevant = rootType != null && !Boolean.parseBoolean(additionalMetadata.get("typeIsIrrelevantInErrorMessage"));
        if (typeRelevant) {
            if (pluginId != null) {
                builder.append("In plugin '").append(pluginId).append("' type '");
            } else {
                builder.append("Type '");
            }
            builder.append(rootType).append("' ");
        }
        if ((property = additionalMetadata.get("propertyName")) != null) {
            if (typeRelevant) {
                builder.append("property '");
            } else if (pluginId != null) {
                builder.append("In plugin '").append(pluginId).append("' property '");
            } else {
                builder.append("Property '");
            }
            Optional.ofNullable(additionalMetadata.get("parentPropertyName")).ifPresent(parentProperty -> {
                builder.append((String)parentProperty);
                builder.append('.');
            });
            builder.append(property).append("' ");
        }
        return builder.toString();
    }

    private static boolean shouldRenderType(String className) {
        return !"org.gradle.api.DefaultTask".equals(className);
    }
}

