/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestFrameworkDistributionModule;
import org.gradle.api.internal.tasks.testing.worker.ForkedTestClasspath;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.internal.CollectionUtils;

public class ForkedTestClasspathFactory {
    private static final Logger LOGGER = Logging.getLogger(ForkedTestClasspathFactory.class);
    private final ModuleRegistry moduleRegistry;
    private final ClassDetectorFactory classDetectorFactory;

    public ForkedTestClasspathFactory(ModuleRegistry moduleRegistry) {
        this(moduleRegistry, ClassLoadingClassDetector::new);
    }

    @VisibleForTesting
    public ForkedTestClasspathFactory(ModuleRegistry moduleRegistry, ClassDetectorFactory classDetectorFactory) {
        this.moduleRegistry = moduleRegistry;
        this.classDetectorFactory = classDetectorFactory;
    }

    public ForkedTestClasspath create(Iterable<? extends File> classpath, Iterable<? extends File> modulepath, TestFramework testFramework, boolean isModule) {
        if (!testFramework.getUseDistributionDependencies()) {
            return new ForkedTestClasspath(ImmutableList.copyOf(classpath), ImmutableList.copyOf(modulepath), this.withImplementation((List<URL>)ImmutableList.of()), ImmutableList.of());
        }
        AdditionalClasspath unfiltered = new AdditionalClasspath(testFramework.getWorkerApplicationClasspathModules(), testFramework.getWorkerApplicationModulepathModules(), testFramework.getWorkerImplementationClasspathModules(), testFramework.getWorkerImplementationModulepathModules());
        AdditionalClasspath filtered = this.filterAdditionalClasspath(classpath, modulepath, unfiltered);
        if (filtered.isEmpty()) {
            return new ForkedTestClasspath(ImmutableList.copyOf(classpath), ImmutableList.copyOf(modulepath), this.withImplementation((List<URL>)ImmutableList.of()), ImmutableList.of());
        }
        return this.getClasspathWithAdditionalModules(classpath, modulepath, unfiltered, isModule);
    }

    private ForkedTestClasspath getClasspathWithAdditionalModules(Iterable<? extends File> classpath, Iterable<? extends File> modulepath, AdditionalClasspath additional, boolean isModule) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateIndirectUsage((String)"The automatic loading of test framework implementation dependencies").withAdvice("Declare the desired test framework directly on the test suite or explicitly declare the test framework implementation dependencies on the test's runtime classpath.").willBeRemovedInGradle9().withUpgradeGuideSection(8, "test_framework_implementation_dependencies")).nagUser();
        if (isModule) {
            return new ForkedTestClasspath(this.pathWithAdditionalModules(classpath, additional.applicationClasspath), this.pathWithAdditionalModules(modulepath, additional.applicationModulepath), this.withImplementation((List<URL>)this.loadDistributionUrls(additional.implementationClasspath)), this.loadDistributionUrls(additional.implementationModulepath));
        }
        ImmutableList additionalApplicationClasspath = ImmutableList.builder().addAll(additional.applicationClasspath).addAll(additional.applicationModulepath).build();
        ImmutableList additionalImplementationClasspath = ImmutableList.builder().addAll(additional.implementationClasspath).addAll(additional.implementationModulepath).build();
        return new ForkedTestClasspath(this.pathWithAdditionalModules(classpath, (List<TestFrameworkDistributionModule>)additionalApplicationClasspath), ImmutableList.copyOf(modulepath), this.withImplementation((List<URL>)this.loadDistributionUrls((List<TestFrameworkDistributionModule>)additionalImplementationClasspath)), ImmutableList.of());
    }

    private ImmutableList<URL> withImplementation(List<URL> additionalImplementationClasspath) {
        return ImmutableList.copyOf((Collection)CollectionUtils.flattenCollections(URL.class, (Object[])new Object[]{this.moduleRegistry.getModule("gradle-core-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-worker-processes").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-core").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-logging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-logging-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-messaging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-files").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-file-temp").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-hashing").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-base-services").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-enterprise-logging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-enterprise-workers").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-cli").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-native").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-base").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-jvm-infrastructure").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-junit-platform").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-process-services").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-build-operations").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("slf4j-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("jul-to-slf4j").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("native-platform").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("kryo").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("commons-lang").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("javax.inject").getImplementationClasspath().getAsURLs(), additionalImplementationClasspath}));
    }

    private ImmutableList<File> pathWithAdditionalModules(Iterable<? extends File> testFiles, List<TestFrameworkDistributionModule> additionalModules) {
        return ImmutableList.builder().addAll(testFiles).addAll(this.loadDistributionFiles(additionalModules)).build();
    }

    private ImmutableList<File> loadDistributionFiles(List<TestFrameworkDistributionModule> moduleNames) {
        return this.loadFromDistribution(moduleNames, ClassPath::getAsFiles);
    }

    private ImmutableList<URL> loadDistributionUrls(List<TestFrameworkDistributionModule> moduleNames) {
        return this.loadFromDistribution(moduleNames, ClassPath::getAsURLs);
    }

    private <T> ImmutableList<T> loadFromDistribution(List<TestFrameworkDistributionModule> moduleNames, Function<ClassPath, List<T>> extractor) {
        ImmutableList.Builder outputFiles = ImmutableList.builder();
        if (LOGGER.isDebugEnabled() && !moduleNames.isEmpty()) {
            LOGGER.debug("Loaded additional modules from the Gradle distribution: " + Joiner.on((String)",").join(moduleNames));
        }
        for (TestFrameworkDistributionModule module : moduleNames) {
            ClassPath cp = this.moduleRegistry.getExternalModule(module.getModuleName()).getImplementationClasspath();
            outputFiles.addAll((Iterable)extractor.apply(cp));
        }
        return outputFiles.build();
    }

    private AdditionalClasspath filterAdditionalClasspath(Iterable<? extends File> classpath, Iterable<? extends File> modulepath, AdditionalClasspath unfiltered) {
        AdditionalClasspath fastFiltered = this.filterFast(classpath, modulepath, unfiltered);
        if (fastFiltered.isEmpty()) {
            return fastFiltered;
        }
        return this.filterSlow(classpath, modulepath, fastFiltered);
    }

    private AdditionalClasspath filterFast(Iterable<? extends File> classpath, Iterable<? extends File> modulepath, AdditionalClasspath unfiltered) {
        String name;
        AdditionalClasspath mutable = new AdditionalClasspath(new ArrayList<TestFrameworkDistributionModule>(unfiltered.applicationClasspath), new ArrayList<TestFrameworkDistributionModule>(unfiltered.applicationModulepath), new ArrayList<TestFrameworkDistributionModule>(unfiltered.implementationClasspath), new ArrayList<TestFrameworkDistributionModule>(unfiltered.implementationModulepath));
        Iterator<? extends File> it = classpath.iterator();
        while (it.hasNext() && !mutable.isEmpty()) {
            name = it.next().getName();
            mutable.applicationClasspath.removeIf(module -> module.getJarFilePattern().matcher(name).matches());
            mutable.applicationModulepath.removeIf(module -> module.getJarFilePattern().matcher(name).matches());
            mutable.implementationClasspath.removeIf(module -> module.getJarFilePattern().matcher(name).matches());
            mutable.implementationModulepath.removeIf(module -> module.getJarFilePattern().matcher(name).matches());
        }
        it = modulepath.iterator();
        while (it.hasNext() && !mutable.isEmpty()) {
            name = it.next().getName();
            mutable.applicationClasspath.removeIf(module -> module.getJarFilePattern().matcher(name).matches());
            mutable.applicationModulepath.removeIf(module -> module.getJarFilePattern().matcher(name).matches());
            mutable.implementationClasspath.removeIf(module -> module.getJarFilePattern().matcher(name).matches());
            mutable.implementationModulepath.removeIf(module -> module.getJarFilePattern().matcher(name).matches());
        }
        return mutable;
    }

    private AdditionalClasspath filterSlow(Iterable<? extends File> classpath, Iterable<? extends File> modulepath, AdditionalClasspath unfiltered) {
        AdditionalClasspath additionalClasspath;
        block8: {
            ClassDetector classDetector = this.classDetectorFactory.create(classpath, modulepath);
            try {
                additionalClasspath = new AdditionalClasspath(classDetector.withoutDetectedModules(unfiltered.applicationClasspath), classDetector.withoutDetectedModules(unfiltered.applicationModulepath), classDetector.withoutDetectedModules(unfiltered.implementationClasspath), classDetector.withoutDetectedModules(unfiltered.implementationModulepath));
                if (classDetector == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (classDetector != null) {
                        try {
                            classDetector.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            classDetector.close();
        }
        return additionalClasspath;
    }

    public static class ClassLoadingClassDetector
    implements ClassDetector {
        private final URLClassLoader classLoader;

        public ClassLoadingClassDetector(Iterable<? extends File> classpath, Iterable<? extends File> modulepath) {
            ClassPath cp = DefaultClassPath.of((Iterable)Iterables.concat(classpath, modulepath));
            this.classLoader = new URLClassLoader(cp.getAsURLArray());
        }

        @Override
        public boolean hasClass(String className) {
            String path = className.replace('.', '/').concat(".class");
            return this.classLoader.findResource(path) != null;
        }

        @Override
        public void close() throws IOException {
            this.classLoader.close();
        }
    }

    public static interface ClassDetectorFactory {
        public ClassDetector create(Iterable<? extends File> var1, Iterable<? extends File> var2);
    }

    public static interface ClassDetector
    extends Closeable {
        public boolean hasClass(String var1);

        default public List<TestFrameworkDistributionModule> withoutDetectedModules(List<TestFrameworkDistributionModule> modules) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (TestFrameworkDistributionModule module : modules) {
                if (this.hasClass(module.getExampleClassName())) continue;
                builder.add((Object)module);
            }
            return builder.build();
        }
    }

    private static class AdditionalClasspath {
        public final List<TestFrameworkDistributionModule> applicationClasspath;
        public final List<TestFrameworkDistributionModule> applicationModulepath;
        public final List<TestFrameworkDistributionModule> implementationClasspath;
        public final List<TestFrameworkDistributionModule> implementationModulepath;

        public AdditionalClasspath(List<TestFrameworkDistributionModule> applicationClasspath, List<TestFrameworkDistributionModule> applicationModulepath, List<TestFrameworkDistributionModule> implementationClasspath, List<TestFrameworkDistributionModule> implementationModulepath) {
            this.applicationClasspath = applicationClasspath;
            this.applicationModulepath = applicationModulepath;
            this.implementationClasspath = implementationClasspath;
            this.implementationModulepath = implementationModulepath;
        }

        public boolean isEmpty() {
            return this.applicationClasspath.isEmpty() && this.applicationModulepath.isEmpty() && this.implementationClasspath.isEmpty() && this.implementationModulepath.isEmpty();
        }
    }
}

