/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeLanguage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;

public class DefaultNativeToolChainRegistry
extends DefaultPolymorphicDomainObjectContainer<NativeToolChain>
implements NativeToolChainRegistryInternal {
    private final Map<String, Class<? extends NativeToolChain>> registeredDefaults = new LinkedHashMap<String, Class<? extends NativeToolChain>>();
    private final List<NativeToolChainInternal> searchOrder = new ArrayList<NativeToolChainInternal>();

    public DefaultNativeToolChainRegistry(Instantiator instantiator, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        super(NativeToolChain.class, instantiator, instantiator, collectionCallbackActionDecorator);
        this.whenObjectAdded((Action)new Action<NativeToolChain>(){

            public void execute(NativeToolChain toolChain) {
                DefaultNativeToolChainRegistry.this.searchOrder.add((NativeToolChainInternal)toolChain);
            }
        });
        this.whenObjectRemoved((Action)new Action<NativeToolChain>(){

            public void execute(NativeToolChain toolChain) {
                DefaultNativeToolChainRegistry.this.searchOrder.remove(toolChain);
            }
        });
    }

    protected void handleAttemptToAddItemWithNonUniqueName(NativeToolChain toolChain) {
        throw new InvalidUserDataException(String.format("ToolChain with name '%s' added multiple times", toolChain.getName()));
    }

    @Override
    public void registerDefaultToolChain(String name, Class<? extends NativeToolChain> type) {
        this.registeredDefaults.put(name, type);
    }

    @Override
    public void addDefaultToolChains() {
        for (String name : this.registeredDefaults.keySet()) {
            this.create(name, this.registeredDefaults.get(name));
        }
    }

    public NativeToolChain getForPlatform(NativePlatform targetPlatform) {
        return this.getForPlatform(NativeLanguage.ANY, (NativePlatformInternal)targetPlatform);
    }

    @Override
    public NativeToolChainInternal getForPlatform(NativeLanguage sourceLanguage, NativePlatformInternal targetMachine) {
        for (NativeToolChainInternal toolChain : this.searchOrder) {
            if (!toolChain.select(sourceLanguage, targetMachine).isAvailable()) continue;
            return toolChain;
        }
        LinkedHashMap<String, PlatformToolProvider> candidates = new LinkedHashMap<String, PlatformToolProvider>();
        for (NativeToolChainInternal toolChain : this.searchOrder) {
            candidates.put(toolChain.getDisplayName(), toolChain.select(sourceLanguage, targetMachine));
        }
        if (!NativeLanguage.ANY.equals((Object)sourceLanguage) && candidates.values().stream().allMatch(it -> !it.isSupported())) {
            return new UnsupportedNativeToolChain(new UnsupportedToolChainDescription(sourceLanguage, targetMachine, candidates));
        }
        return new UnavailableNativeToolChain(new UnavailableToolChainDescription(sourceLanguage, targetMachine, candidates));
    }

    public static class UnsupportedNativeToolChain
    implements NativeToolChainInternal {
        private final ToolSearchResult failure;

        UnsupportedNativeToolChain(ToolSearchResult failure) {
            this.failure = failure;
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return "unsupported";
        }

        @Override
        public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), this.failure);
        }

        @Override
        public PlatformToolProvider select(NativeLanguage sourceLanguage, NativePlatformInternal targetMachine) {
            return this.select(targetMachine);
        }

        @Override
        public String getOutputType() {
            return "unsupported";
        }

        @Override
        public void assertSupported() {
            TreeFormatter formatter = new TreeFormatter();
            this.failure.explain((DiagnosticsVisitor)formatter);
            throw new GradleException(formatter.toString());
        }
    }

    private static class UnsupportedToolChainDescription
    extends AbstractUnavailabilityToolChainSearchDescription {
        public UnsupportedToolChainDescription(NativeLanguage sourceLanguage, NativePlatform targetPlatform, Map<String, PlatformToolProvider> candidates) {
            super(sourceLanguage, targetPlatform, candidates);
        }

        @Override
        protected String getUnavailabilityReason() {
            return "has support";
        }
    }

    private static class UnavailableNativeToolChain
    implements NativeToolChainInternal {
        private final ToolSearchResult failure;

        UnavailableNativeToolChain(ToolSearchResult failure) {
            this.failure = failure;
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return "unavailable";
        }

        @Override
        public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), this.failure);
        }

        @Override
        public PlatformToolProvider select(NativeLanguage sourceLanguage, NativePlatformInternal targetMachine) {
            return this.select(targetMachine);
        }

        @Override
        public String getOutputType() {
            return "unavailable";
        }

        @Override
        public void assertSupported() {
        }
    }

    private static class UnavailableToolChainDescription
    extends AbstractUnavailabilityToolChainSearchDescription {
        public UnavailableToolChainDescription(NativeLanguage sourceLanguage, NativePlatform targetPlatform, Map<String, PlatformToolProvider> candidates) {
            super(sourceLanguage, targetPlatform, candidates);
        }

        @Override
        protected String getUnavailabilityReason() {
            return "is available";
        }
    }

    private static abstract class AbstractUnavailabilityToolChainSearchDescription
    implements ToolSearchResult {
        private final NativeLanguage sourceLanguage;
        private final NativePlatform targetPlatform;
        private final Map<String, PlatformToolProvider> candidates;

        private AbstractUnavailabilityToolChainSearchDescription(NativeLanguage sourceLanguage, NativePlatform targetPlatform, Map<String, PlatformToolProvider> candidates) {
            this.sourceLanguage = sourceLanguage;
            this.targetPlatform = targetPlatform;
            this.candidates = candidates;
        }

        public boolean isAvailable() {
            return false;
        }

        public void explain(DiagnosticsVisitor visitor) {
            String verb = this.sourceLanguage == NativeLanguage.ANY ? "build" : "build " + (Object)((Object)this.sourceLanguage);
            visitor.node(String.format("No tool chain %s to %s for %s", this.getUnavailabilityReason(), verb, this.targetPlatform.getDisplayName()));
            visitor.startChildren();
            for (Map.Entry<String, PlatformToolProvider> entry : this.candidates.entrySet()) {
                visitor.node(entry.getKey());
                visitor.startChildren();
                entry.getValue().explain(visitor);
                visitor.endChildren();
            }
            if (this.candidates.isEmpty()) {
                visitor.node("No tool chain plugin applied.");
            }
            visitor.endChildren();
        }

        protected abstract String getUnavailabilityReason();
    }
}

