/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.resolution.failure.exception.ConfigurationSelectionException;
import org.gradle.internal.component.resolution.failure.type.ConfigurationNotConsumableFailure;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

public abstract class AbstractComponentGraphResolveState<T extends ComponentGraphResolveMetadata, S extends ComponentResolveMetadata>
implements ComponentGraphResolveState,
ComponentArtifactResolveState {
    private final long instanceId;
    private final T graphMetadata;
    private final S artifactMetadata;
    private final AttributeDesugaring attributeDesugaring;

    public AbstractComponentGraphResolveState(long instanceId, T graphMetadata, S artifactMetadata, AttributeDesugaring attributeDesugaring) {
        this.instanceId = instanceId;
        this.graphMetadata = graphMetadata;
        this.artifactMetadata = artifactMetadata;
        this.attributeDesugaring = attributeDesugaring;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public long getInstanceId() {
        return this.instanceId;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.graphMetadata.getId();
    }

    public T getMetadata() {
        return this.graphMetadata;
    }

    public S getArtifactMetadata() {
        return this.artifactMetadata;
    }

    @Override
    public GraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        return new DefaultGraphSelectionCandidates(this);
    }

    @Override
    public boolean isAdHoc() {
        return false;
    }

    protected abstract Optional<List<? extends VariantGraphResolveState>> getVariantsForGraphTraversal();

    @Override
    @Nullable
    public ComponentGraphResolveState maybeAsLenientPlatform(ModuleComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier) {
        return null;
    }

    @Override
    public ComponentArtifactResolveState prepareForArtifactResolution() {
        return this;
    }

    @Override
    public void resolveArtifactsWithType(ArtifactResolver artifactResolver, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        artifactResolver.resolveArtifactsWithType(this.getResolveMetadata(), artifactType, result);
    }

    protected ImmutableCapabilities capabilitiesFor(ImmutableCapabilities capabilities) {
        if (capabilities.asSet().isEmpty()) {
            return ImmutableCapabilities.of((Capability)DefaultImmutableCapability.defaultCapabilityForComponent(this.getMetadata().getModuleVersionId()));
        }
        return capabilities;
    }

    private static class DefaultGraphSelectionCandidates
    implements GraphSelectionCandidates {
        private final List<? extends VariantGraphResolveState> variants;
        private final AbstractComponentGraphResolveState<?, ?> component;

        public DefaultGraphSelectionCandidates(AbstractComponentGraphResolveState<?, ?> component) {
            this.variants = component.getVariantsForGraphTraversal().orElse(Collections.emptyList());
            this.component = component;
        }

        @Override
        public boolean isUseVariants() {
            return !this.variants.isEmpty();
        }

        @Override
        public List<? extends VariantGraphResolveState> getVariants() {
            if (this.variants.isEmpty()) {
                throw new IllegalStateException("No variants available for selection");
            }
            return this.variants;
        }

        @Override
        @Nullable
        public VariantGraphResolveState getVariantByConfigurationName(String name) {
            ConfigurationGraphResolveState conf = this.component.getConfiguration(name);
            if (conf == null) {
                return null;
            }
            ConfigurationGraphResolveMetadata metadata = conf.getMetadata();
            if (!metadata.isCanBeConsumed()) {
                ConfigurationNotConsumableFailure failure = new ConfigurationNotConsumableFailure(name, this.component.getId().getDisplayName());
                String message = String.format("Selected configuration '" + failure.getRequestedName() + "' on '" + failure.getRequestedComponentDisplayName() + "' but it can't be used as a project dependency because it isn't intended for consumption by other components.", new Object[0]);
                throw new ConfigurationSelectionException(message, failure, Collections.emptyList());
            }
            return conf.asVariant();
        }
    }

    protected static abstract class AbstractVariantGraphResolveState
    implements VariantGraphResolveState {
        private final Lazy<ResolvedVariantResult> publicView = Lazy.locking().of(() -> this.createVariantResult(null));
        private final AbstractComponentGraphResolveState<?, ?> component;

        public AbstractVariantGraphResolveState(AbstractComponentGraphResolveState<?, ?> component) {
            this.component = component;
        }

        @Override
        public boolean isAdHoc() {
            return this.component.isAdHoc();
        }

        @Override
        public ResolvedVariantResult getVariantResult(@Nullable ResolvedVariantResult externalVariant) {
            if (externalVariant != null) {
                return this.createVariantResult(externalVariant);
            }
            return (ResolvedVariantResult)this.publicView.get();
        }

        private DefaultResolvedVariantResult createVariantResult(@Nullable ResolvedVariantResult externalVariant) {
            VariantGraphResolveMetadata metadata = this.getMetadata();
            return new DefaultResolvedVariantResult(this.component.getId(), Describables.of((Object)metadata.getName()), (AttributeContainer)((AbstractComponentGraphResolveState)this.component).attributeDesugaring.desugar(metadata.getAttributes()), this.component.capabilitiesFor(metadata.getCapabilities()), externalVariant);
        }
    }
}

