/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util;

import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.AntBuilderAware;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.internal.IntersectionPatternSet;
import org.gradle.api.tasks.util.internal.PatternSetAntBuilderDelegate;
import org.gradle.api.tasks.util.internal.PatternSpecFactory;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.util.internal.CollectionUtils;

public class PatternSet
implements AntBuilderAware,
PatternFilterable {
    private static final NotationParser<Object, String> PARSER = NotationParserBuilder.toType(String.class).fromCharSequence().toComposite();
    private final PatternSpecFactory patternSpecFactory;
    private Set<String> includes;
    private Set<String> excludes;
    private Set<Spec<FileTreeElement>> includeSpecs;
    private Set<Spec<FileTreeElement>> excludeSpecs;
    private boolean caseSensitive = true;

    public PatternSet() {
        this(PatternSpecFactory.INSTANCE);
    }

    protected PatternSet(PatternSet patternSet) {
        this(patternSet.patternSpecFactory);
    }

    protected PatternSet(PatternSpecFactory patternSpecFactory) {
        this.patternSpecFactory = patternSpecFactory;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatternSet)) {
            return false;
        }
        PatternSet that = (PatternSet)o;
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        if (!PatternSet.nullToEmpty(this.excludeSpecs).equals(PatternSet.nullToEmpty(that.excludeSpecs))) {
            return false;
        }
        if (!PatternSet.nullToEmpty(this.excludes).equals(PatternSet.nullToEmpty(that.excludes))) {
            return false;
        }
        if (!PatternSet.nullToEmpty(this.includeSpecs).equals(PatternSet.nullToEmpty(that.includeSpecs))) {
            return false;
        }
        return PatternSet.nullToEmpty(this.includes).equals(PatternSet.nullToEmpty(that.includes));
    }

    public int hashCode() {
        int result = PatternSet.nullToEmpty(this.includes).hashCode();
        result = 31 * result + PatternSet.nullToEmpty(this.excludes).hashCode();
        result = 31 * result + PatternSet.nullToEmpty(this.includeSpecs).hashCode();
        result = 31 * result + PatternSet.nullToEmpty(this.excludeSpecs).hashCode();
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        return result;
    }

    private static <T> Set<T> nullToEmptyAndUnmodifiableSet(@Nullable Set<T> set) {
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    private static Set<?> nullToEmpty(@Nullable Set<?> set) {
        return set == null ? Collections.emptySet() : set;
    }

    public PatternSet copyFrom(PatternFilterable sourcePattern) {
        return this.doCopyFrom((PatternSet)sourcePattern);
    }

    protected PatternSet doCopyFrom(PatternSet from) {
        this.caseSensitive = from.caseSensitive;
        if (from instanceof IntersectionPatternSet) {
            PatternSet other = ((IntersectionPatternSet)from).getOther();
            PatternSet otherCopy = new PatternSet(other).copyFrom(other);
            IntersectionPatternSet intersectCopy = new IntersectionPatternSet(otherCopy);
            this.copyIncludesAndExcludes(intersectCopy, from);
            this.includes = null;
            this.excludes = null;
            this.includeSpecs = new LinkedHashSet<Spec<FileTreeElement>>();
            this.includeSpecs.add(((PatternSet)intersectCopy).getAsSpec());
            this.excludeSpecs = null;
        } else {
            this.copyIncludesAndExcludes(this, from);
        }
        return this;
    }

    private void copyIncludesAndExcludes(PatternSet target, PatternSet from) {
        target.includes = from.includes == null ? null : Sets.newLinkedHashSet(from.includes);
        target.excludes = from.excludes == null ? null : Sets.newLinkedHashSet(from.excludes);
        target.includeSpecs = from.includeSpecs == null ? null : Sets.newLinkedHashSet(from.includeSpecs);
        target.excludeSpecs = from.excludeSpecs == null ? null : Sets.newLinkedHashSet(from.excludeSpecs);
    }

    public PatternSet intersect() {
        if (this.isEmpty()) {
            return new PatternSet(this.patternSpecFactory);
        }
        return new IntersectionPatternSet(this);
    }

    public boolean isEmpty() {
        return !(this.includes != null && !this.includes.isEmpty() || this.excludes != null && !this.excludes.isEmpty() || this.includeSpecs != null && !this.includeSpecs.isEmpty() || this.excludeSpecs != null && !this.excludeSpecs.isEmpty());
    }

    public Spec<FileTreeElement> getAsSpec() {
        return this.patternSpecFactory.createSpec(this);
    }

    public Spec<FileTreeElement> getAsIncludeSpec() {
        return this.patternSpecFactory.createIncludeSpec(this);
    }

    public Spec<FileTreeElement> getAsExcludeSpec() {
        return this.patternSpecFactory.createExcludeSpec(this);
    }

    @Incubating
    public Set<String> getIncludesView() {
        return PatternSet.nullToEmptyAndUnmodifiableSet(this.includes);
    }

    @Override
    public Set<String> getIncludes() {
        if (this.includes == null) {
            this.includes = new LinkedHashSet<String>();
        }
        return this.includes;
    }

    @Incubating
    public Set<Spec<FileTreeElement>> getIncludeSpecsView() {
        return PatternSet.nullToEmptyAndUnmodifiableSet(this.includeSpecs);
    }

    public Set<Spec<FileTreeElement>> getIncludeSpecs() {
        if (this.includeSpecs == null) {
            this.includeSpecs = new LinkedHashSet<Spec<FileTreeElement>>();
        }
        return this.includeSpecs;
    }

    @Override
    public PatternSet setIncludes(Iterable<String> includes) {
        this.includes = null;
        return this.include((Iterable)includes);
    }

    @Override
    public PatternSet include(String ... includes) {
        Collections.addAll(this.getIncludes(), includes);
        return this;
    }

    public PatternSet include(Iterable includes) {
        for (Object include : includes) {
            this.getIncludes().add(PARSER.parseNotation(include));
        }
        return this;
    }

    @Override
    public PatternSet include(Spec<FileTreeElement> spec) {
        this.getIncludeSpecs().add(spec);
        return this;
    }

    @Incubating
    public Set<String> getExcludesView() {
        return PatternSet.nullToEmptyAndUnmodifiableSet(this.excludes);
    }

    @Override
    public Set<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new LinkedHashSet<String>();
        }
        return this.excludes;
    }

    @Incubating
    public Set<Spec<FileTreeElement>> getExcludeSpecsView() {
        return PatternSet.nullToEmptyAndUnmodifiableSet(this.excludeSpecs);
    }

    public Set<Spec<FileTreeElement>> getExcludeSpecs() {
        if (this.excludeSpecs == null) {
            this.excludeSpecs = new LinkedHashSet<Spec<FileTreeElement>>();
        }
        return this.excludeSpecs;
    }

    @Override
    public PatternSet setExcludes(Iterable<String> excludes) {
        this.excludes = null;
        return this.exclude((Iterable)excludes);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public PatternSet includeSpecs(Iterable<Spec<FileTreeElement>> includeSpecs) {
        CollectionUtils.addAll(this.getIncludeSpecs(), includeSpecs);
        return this;
    }

    @Override
    public PatternSet include(Closure closure) {
        this.include(Specs.convertClosureToSpec((Closure)closure));
        return this;
    }

    @Override
    public PatternSet exclude(String ... excludes) {
        Collections.addAll(this.getExcludes(), excludes);
        return this;
    }

    public PatternSet exclude(Iterable excludes) {
        for (Object exclude : excludes) {
            this.getExcludes().add(PARSER.parseNotation(exclude));
        }
        return this;
    }

    @Override
    public PatternSet exclude(Spec<FileTreeElement> spec) {
        this.getExcludeSpecs().add(spec);
        return this;
    }

    public PatternSet excludeSpecs(Iterable<Spec<FileTreeElement>> excludes) {
        CollectionUtils.addAll(this.getExcludeSpecs(), excludes);
        return this;
    }

    @Override
    public PatternSet exclude(Closure closure) {
        this.exclude(Specs.convertClosureToSpec((Closure)closure));
        return this;
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        if (!PatternSet.nullToEmpty(this.includeSpecs).isEmpty() || !PatternSet.nullToEmpty(this.excludeSpecs).isEmpty()) {
            throw new UnsupportedOperationException("Cannot add include/exclude specs to Ant node. Only include/exclude patterns are currently supported.");
        }
        return new PatternSetAntBuilderDelegate(this.getIncludesView(), this.getExcludesView(), this.isCaseSensitive()).addToAntBuilder(node, childNodeName);
    }
}

