/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface BeanIntrospection<T>
extends AnnotationMetadataDelegate {
    @Nonnull
    public Collection<BeanProperty<T, Object>> getBeanProperties();

    @Nonnull
    public Collection<BeanProperty<T, Object>> getIndexedProperties(@Nonnull Class<? extends Annotation> var1);

    @Nonnull
    public T instantiate() throws InstantiationException;

    @Nonnull
    default public T instantiate(Object ... arguments) throws InstantiationException {
        return this.instantiate(true, arguments);
    }

    @Nonnull
    public T instantiate(boolean var1, Object ... var2) throws InstantiationException;

    @Nonnull
    public Class<T> getBeanType();

    @Nonnull
    public Optional<BeanProperty<T, Object>> getIndexedProperty(@Nonnull Class<? extends Annotation> var1, @Nonnull String var2);

    @Nonnull
    default public Optional<BeanProperty<T, Object>> getIndexedProperty(@Nonnull Class<? extends Annotation> annotationType) {
        return this.getIndexedProperties(annotationType).stream().findFirst();
    }

    @Nonnull
    default public Argument<?>[] getConstructorArguments() {
        return Argument.ZERO_ARGUMENTS;
    }

    @Nonnull
    default public Optional<BeanProperty<T, Object>> getProperty(@Nonnull String name) {
        return Optional.empty();
    }

    @Nonnull
    default public <P> BeanProperty<T, P> getRequiredProperty(@Nonnull String name, @Nonnull Class<P> type) {
        return this.getProperty(name, type).orElseThrow(() -> new IntrospectionException("No property [" + name + "] of type [" + type + "] present"));
    }

    @Nonnull
    default public <P> Optional<BeanProperty<T, P>> getProperty(@Nonnull String name, @Nonnull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        BeanProperty prop = this.getProperty(name).orElse(null);
        if (prop != null && type.isAssignableFrom(prop.getType())) {
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    @Nonnull
    default public String[] getPropertyNames() {
        return (String[])this.getBeanProperties().stream().map(Named::getName).toArray(String[]::new);
    }

    public static <T2> BeanIntrospection<T2> getIntrospection(Class<T2> type) {
        return BeanIntrospector.SHARED.getIntrospection(type);
    }
}

