/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.socket;

import io.micronaut.core.util.ArgumentUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Random;

public class SocketUtils {
    public static final String LOCALHOST = "localhost";
    public static final int MIN_PORT_RANGE = 1024;
    public static final int MAX_PORT_RANGE = 65535;
    private static final Random random = new Random(System.currentTimeMillis());

    public static int findAvailableTcpPort() {
        return SocketUtils.findAvailableTcpPort(1025, 65535);
    }

    public static int findAvailableTcpPort(int minPortRange, int maxPortRange) {
        ArgumentUtils.check(() -> minPortRange > 1024).orElseFail("Port minimum value must be greater than 1024");
        ArgumentUtils.check(() -> maxPortRange >= minPortRange).orElseFail("Max port range must be greater than minimum port range");
        ArgumentUtils.check(() -> maxPortRange <= 65535).orElseFail("Port maximum value must be less than 65535");
        int currentPort = SocketUtils.nextPort(minPortRange, maxPortRange);
        while (!SocketUtils.isTcpPortAvailable(currentPort)) {
            currentPort = SocketUtils.nextPort(minPortRange, maxPortRange);
        }
        return currentPort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTcpPortAvailable(int currentPort) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(InetAddress.getLocalHost(), currentPort), 20);
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            return true;
        }
    }

    private static int nextPort(int minPortRange, int maxPortRange) {
        int seed = maxPortRange - minPortRange;
        return random.nextInt(seed) + minPortRange;
    }
}

