/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.AsyncCacheErrorHandler;
import io.micronaut.cache.CacheErrorHandler;
import io.micronaut.cache.CacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.annotation.CacheAnnotation;
import io.micronaut.cache.annotation.CacheConfig;
import io.micronaut.cache.annotation.CacheInvalidate;
import io.micronaut.cache.annotation.CachePut;
import io.micronaut.cache.annotation.Cacheable;
import io.micronaut.cache.interceptor.CacheKeyGenerator;
import io.micronaut.cache.interceptor.DefaultCacheKeyGenerator;
import io.micronaut.cache.interceptor.KotlinSuspendFunCacheKeyGenerator;
import io.micronaut.cache.interceptor.ValueSupplierException;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueResolver;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ExecutableMethod;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@InterceptorBean(value={CacheAnnotation.class})
public class CacheInterceptor
implements MethodInterceptor<Object, Object> {
    public static final int POSITION = InterceptPhase.CACHE.getPosition();
    private static final String MEMBER_CACHE_NAMES = "cacheNames";
    private static final String MEMBER_ASYNC = "async";
    private static final Logger LOG = LoggerFactory.getLogger(CacheInterceptor.class);
    private static final String MEMBER_ATOMIC = "atomic";
    private static final String MEMBER_PARAMETERS = "parameters";
    private static final String MEMBER_ALL = "all";
    private static final String MEMBER_KEY_GENERATOR = "keyGenerator";
    private final CacheManager cacheManager;
    private final Map<Class<? extends CacheKeyGenerator>, CacheKeyGenerator> keyGenerators = new ConcurrentHashMap<Class<? extends CacheKeyGenerator>, CacheKeyGenerator>();
    private final Map<ExecutableMethod<?, ?>, CacheOperation> cacheOperations = new ConcurrentHashMap(30);
    private final BeanContext beanContext;
    private final ExecutorService ioExecutor;
    private final CacheErrorHandler errorHandler;
    private final AsyncCacheErrorHandler asyncCacheErrorHandler;

    public CacheInterceptor(CacheManager cacheManager, CacheErrorHandler errorHandler, AsyncCacheErrorHandler asyncCacheErrorHandler, @Named(value="io") ExecutorService ioExecutor, BeanContext beanContext) {
        this.cacheManager = cacheManager;
        this.errorHandler = errorHandler;
        this.asyncCacheErrorHandler = asyncCacheErrorHandler;
        this.beanContext = beanContext;
        this.ioExecutor = ioExecutor;
    }

    public int getOrder() {
        return POSITION;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (context.hasStereotype(CacheAnnotation.class)) {
            InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
            try {
                ReturnType returnType = context.getReturnType();
                Argument returnTypeValue = interceptedMethod.returnTypeValue();
                switch (interceptedMethod.resultType()) {
                    case COMPLETION_STAGE: {
                        CompletionStage<?> completionStage = this.interceptAsCompletableFuture(context, () -> ((InterceptedMethod)interceptedMethod).interceptResultAsCompletionStage(), returnType, returnTypeValue);
                        return interceptedMethod.handleResult(completionStage);
                    }
                    case PUBLISHER: {
                        CacheOperation cacheOperation = this.getCacheOperation(context, returnType.isVoid() || returnTypeValue.equalsType(Argument.VOID_OBJECT));
                        if (cacheOperation.cacheable) {
                            if (returnType.isSingleResult()) {
                                return this.interceptSingle(context, interceptedMethod, returnTypeValue, cacheOperation);
                            }
                            return this.interceptMulti(context, interceptedMethod, returnTypeValue, cacheOperation);
                        }
                        if (cacheOperation.hasWriteOperations()) {
                            Mono<Object> cachingPublisher;
                            if (returnType.isSingleResult()) {
                                Mono cachingMono = Mono.from((Publisher)interceptedMethod.interceptResultAsPublisher());
                                cachingPublisher = this.handleSingleWriteOperations(context, cacheOperation, (Mono<Object>)cachingMono);
                            } else {
                                Flux cachingMono = Flux.from((Publisher)interceptedMethod.interceptResultAsPublisher());
                                cachingPublisher = this.handleMultiWriteOperations(context, cacheOperation, (Flux<Object>)cachingMono);
                            }
                            return interceptedMethod.handleResult(cachingPublisher);
                        }
                        return interceptedMethod.handleResult((Object)interceptedMethod.interceptResultAsPublisher());
                    }
                    case SYNCHRONOUS: {
                        return this.interceptSync(context, returnType);
                    }
                }
                return interceptedMethod.unsupported();
            }
            catch (Exception e) {
                return interceptedMethod.handleException(e);
            }
        }
        return context.proceed();
    }

    private Object interceptSingle(MethodInvocationContext<Object, Object> context, InterceptedMethod interceptedMethod, Argument<?> returnTypeValue, CacheOperation cacheOperation) {
        AsyncCache asyncCache = this.cacheManager.getCache(cacheOperation.cacheableCacheName).async();
        Object key = this.getCacheableKey(context, cacheOperation);
        Mono<Object> cachingMono = Mono.defer(() -> Mono.fromCompletionStage(this.asyncCacheGet(asyncCache, key, returnTypeValue, this.errorHandler))).flatMap(result -> {
            if (result.isPresent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value found in cache [" + cacheOperation.cacheableCacheName + "] for invocation: " + context);
                }
                return Mono.just(result.get());
            }
            return Mono.from((Publisher)interceptedMethod.interceptResultAsPublisher()).flatMap(object -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Storing in the cache [{}] with key [{}] the result of invocation [{}]: {}", new Object[]{asyncCache.getName(), key, context, object});
                }
                return Mono.fromCompletionStage(this.asyncCachePut(asyncCache, key, object, this.errorHandler)).thenReturn(object);
            }).switchIfEmpty(Mono.defer(() -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Invalidating the key [{}] of the cache [{}] since the result of invocation [{}] was null", new Object[]{key, asyncCache.getName(), context});
                }
                return Mono.fromCompletionStage(this.asyncCacheInvalidate(asyncCache, key, this.errorHandler)).then(Mono.empty());
            }));
        });
        cachingMono = this.handleSingleWriteOperations(context, cacheOperation, cachingMono);
        return interceptedMethod.handleResult(cachingMono);
    }

    private Mono<Object> handleSingleWriteOperations(MethodInvocationContext<Object, Object> context, CacheOperation cacheOperation, Mono<Object> cachingMono) {
        if (cacheOperation.hasWriteOperations()) {
            List<AnnotationValue<CacheInvalidate>> invalidateOperations;
            List<AnnotationValue<CachePut>> putOperations = cacheOperation.putOperations;
            if (CollectionUtils.isNotEmpty(putOperations)) {
                for (AnnotationValue<CachePut> putOperation : putOperations) {
                    Object[] cacheNames = cacheOperation.getCachePutNames(putOperation);
                    if (!ArrayUtils.isNotEmpty((Object[])cacheNames)) continue;
                    boolean isAsync = putOperation.isTrue(MEMBER_ASYNC);
                    if (isAsync) {
                        cachingMono = cachingMono.doOnNext(arg_0 -> this.lambda$handleSingleWriteOperations$4(context, cacheOperation, putOperation, (String[])cacheNames, arg_0));
                        continue;
                    }
                    cachingMono = cachingMono.flatMap(arg_0 -> this.lambda$handleSingleWriteOperations$5(context, cacheOperation, putOperation, (String[])cacheNames, arg_0));
                }
            }
            if (CollectionUtils.isNotEmpty(invalidateOperations = cacheOperation.invalidateOperations)) {
                for (AnnotationValue<CacheInvalidate> invalidateOperation : invalidateOperations) {
                    Object[] cacheNames = cacheOperation.getCacheInvalidateNames(invalidateOperation);
                    if (!ArrayUtils.isNotEmpty((Object[])cacheNames)) continue;
                    boolean isAsync = invalidateOperation.isTrue(MEMBER_ASYNC);
                    if (isAsync) {
                        cachingMono = cachingMono.doOnNext(arg_0 -> this.lambda$handleSingleWriteOperations$6(context, cacheOperation, invalidateOperation, (String[])cacheNames, arg_0));
                        continue;
                    }
                    cachingMono = cachingMono.flatMap(arg_0 -> this.lambda$handleSingleWriteOperations$7(context, cacheOperation, invalidateOperation, (String[])cacheNames, arg_0));
                }
            }
        }
        return cachingMono;
    }

    private Object interceptMulti(MethodInvocationContext<Object, Object> context, InterceptedMethod interceptedMethod, Argument<?> returnTypeValue, CacheOperation cacheOperation) {
        AsyncCache asyncCache = this.cacheManager.getCache(cacheOperation.cacheableCacheName).async();
        Object key = this.getCacheableKey(context, cacheOperation);
        Flux<Object> cachingFlux = Mono.defer(() -> Mono.fromCompletionStage(this.asyncCacheGet(asyncCache, key, returnTypeValue, this.errorHandler))).flatMapMany(result -> {
            if (result.isPresent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value found in cache [" + cacheOperation.cacheableCacheName + "] for invocation: " + context);
                }
                return Mono.just(result.get());
            }
            return Flux.from((Publisher)interceptedMethod.interceptResultAsPublisher()).collectList().flatMap(object -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Storing in the cache [{}] with key [{}] the result of invocation [{}]: {}", new Object[]{asyncCache.getName(), key, context, object});
                }
                return Mono.fromCompletionStage(this.asyncCachePut(asyncCache, key, object, this.errorHandler)).thenReturn(object);
            }).switchIfEmpty(Mono.defer(() -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Invalidating the key [{}] of the cache [{}] since the result of invocation [{}] was null", new Object[]{key, asyncCache.getName(), context});
                }
                return Mono.fromCompletionStage(this.asyncCacheInvalidate(asyncCache, key, this.errorHandler)).then(Mono.empty());
            }));
        });
        cachingFlux = this.handleMultiWriteOperations(context, cacheOperation, cachingFlux);
        return interceptedMethod.handleResult(cachingFlux);
    }

    private Flux<Object> handleMultiWriteOperations(MethodInvocationContext<Object, Object> context, CacheOperation cacheOperation, Flux<Object> cachingFlux) {
        if (cacheOperation.hasWriteOperations()) {
            List<AnnotationValue<CacheInvalidate>> invalidateOperations;
            List<AnnotationValue<CachePut>> putOperations = cacheOperation.putOperations;
            if (CollectionUtils.isNotEmpty(putOperations)) {
                for (AnnotationValue<CachePut> putOperation : putOperations) {
                    Object[] cacheNames = cacheOperation.getCachePutNames(putOperation);
                    if (!ArrayUtils.isNotEmpty((Object[])cacheNames)) continue;
                    boolean isAsync = putOperation.isTrue(MEMBER_ASYNC);
                    if (isAsync) {
                        cachingFlux = cachingFlux.collectList().doOnNext(arg_0 -> this.lambda$handleMultiWriteOperations$12(context, cacheOperation, putOperation, (String[])cacheNames, arg_0)).flatMapIterable(objects -> objects);
                        continue;
                    }
                    cachingFlux = cachingFlux.collectList().flatMap(arg_0 -> this.lambda$handleMultiWriteOperations$14(context, cacheOperation, putOperation, (String[])cacheNames, arg_0)).flatMapIterable(objects -> objects);
                }
            }
            if (CollectionUtils.isNotEmpty(invalidateOperations = cacheOperation.invalidateOperations)) {
                for (AnnotationValue<CacheInvalidate> invalidateOperation : invalidateOperations) {
                    String[] cacheNames = cacheOperation.getCacheInvalidateNames(invalidateOperation);
                    cachingFlux = cachingFlux.doOnComplete(() -> Mono.fromCompletionStage(this.invalidateAsync(context, cacheOperation, invalidateOperation, cacheNames, this.asyncCacheErrorHandler)));
                }
            }
        }
        return cachingFlux;
    }

    protected Object interceptSync(MethodInvocationContext context, ReturnType<?> returnType) {
        List<AnnotationValue<CacheInvalidate>> cacheInvalidates;
        ValueWrapper wrapper = new ValueWrapper();
        CacheOperation cacheOperation = this.getCacheOperation((MethodInvocationContext<Object, Object>)context, returnType.isVoid());
        if (cacheOperation.cacheable) {
            Object key = this.getCacheableKey(context, cacheOperation);
            Argument returnArgument = returnType.asArgument();
            if (context.isTrue(Cacheable.class, MEMBER_ATOMIC)) {
                SyncCache syncCache = this.cacheManager.getCache(cacheOperation.cacheableCacheName);
                try {
                    wrapper.value = syncCache.get(key, returnArgument, () -> {
                        try {
                            this.doProceed(context, wrapper);
                            return wrapper.value;
                        }
                        catch (RuntimeException e) {
                            throw new ValueSupplierException(key, e);
                        }
                    });
                }
                catch (ValueSupplierException e) {
                    throw e.getCause();
                }
                catch (RuntimeException e) {
                    this.errorHandler.handleLoadError(syncCache, key, e);
                    throw e;
                }
            } else {
                String[] stringArray = this.resolveCacheNames(cacheOperation.defaultCacheNames, context.stringValues(Cacheable.class, MEMBER_CACHE_NAMES));
                boolean cacheHit = false;
                for (String cacheName : stringArray) {
                    SyncCache syncCache = this.cacheManager.getCache(cacheName);
                    try {
                        Optional optional = syncCache.get(key, returnArgument);
                        if (!optional.isPresent()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Value found in cache [" + cacheName + "] for invocation: " + context);
                        }
                        cacheHit = true;
                        wrapper.value = optional.get();
                        break;
                    }
                    catch (RuntimeException e) {
                        if (!this.errorHandler.handleLoadError(syncCache, key, e)) continue;
                        throw e;
                    }
                }
                if (!cacheHit) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Value not found in cache for invocation: " + context);
                    }
                    this.doProceed(context, wrapper);
                    this.syncPut(stringArray, key, wrapper.value);
                }
            }
        } else {
            if (!cacheOperation.hasWriteOperations()) {
                return context.proceed();
            }
            this.doProceed(context, wrapper);
        }
        List<AnnotationValue<CachePut>> cachePuts = cacheOperation.putOperations;
        if (CollectionUtils.isNotEmpty(cachePuts)) {
            for (AnnotationValue annotationValue : cachePuts) {
                this.processCachePut(context, wrapper, (AnnotationValue<CachePut>)annotationValue, cacheOperation);
            }
        }
        if (CollectionUtils.isNotEmpty(cacheInvalidates = cacheOperation.invalidateOperations)) {
            for (AnnotationValue<CacheInvalidate> cacheInvalidate : cacheInvalidates) {
                this.processCacheEvict(context, cacheOperation, cacheInvalidate);
            }
        }
        return wrapper.optional ? Optional.ofNullable(wrapper.value) : wrapper.value;
    }

    protected CompletionStage<?> interceptAsCompletableFuture(MethodInvocationContext<Object, Object> context, Supplier<CompletionStage<?>> intercept, ReturnType<?> returnTypeObject, Argument<?> requiredType) {
        CompletionStage<?> returnFuture;
        CacheOperation cacheOperation = this.getCacheOperation(context, returnTypeObject.isVoid() || requiredType.equalsType(Argument.VOID_OBJECT));
        if (cacheOperation.cacheable) {
            AsyncCache asyncCache = this.cacheManager.getCache(cacheOperation.cacheableCacheName).async();
            Object key = this.getCacheableKey(context, cacheOperation);
            returnFuture = ((CompletableFuture)this.asyncCacheGet(asyncCache, key, requiredType, this.errorHandler).thenCompose(o -> {
                if (o.isPresent()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Value found in cache [" + asyncCache.getName() + "] for invocation: " + context);
                    }
                    return CompletableFuture.completedFuture(o.get());
                }
                CompletionStage completableFuture = (CompletionStage)intercept.get();
                if (completableFuture == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return completableFuture.thenCompose(o1 -> {
                    if (o1 == null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Invalidating the key [{}] of the cache [{}] since the result of invocation [{}] was null", new Object[]{key, asyncCache.getName(), context});
                        }
                        return this.asyncCacheInvalidate(asyncCache, key, this.errorHandler).thenApply(ignore -> null);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Storing in the cache [{}] with key [{}] the result of invocation [{}]: {}", new Object[]{asyncCache.getName(), key, context, o1});
                    }
                    return this.asyncCachePut(asyncCache, key, o1, this.errorHandler).thenApply(ignore -> o1);
                });
            })).toCompletableFuture();
        } else {
            returnFuture = intercept.get();
        }
        if (cacheOperation.hasWriteOperations()) {
            returnFuture = this.processFuturePutOperations(context, cacheOperation, returnFuture);
            returnFuture = this.processFutureInvalidateOperations(context, cacheOperation, returnFuture);
        }
        return returnFuture;
    }

    protected List<AnnotationValue<CachePut>> putOperations(ExecutableMethod<?, ?> method) {
        return method.getAnnotationValuesByType(CachePut.class);
    }

    protected List<AnnotationValue<CacheInvalidate>> invalidateOperations(ExecutableMethod<?, ?> method) {
        return method.getAnnotationValuesByType(CacheInvalidate.class);
    }

    private CacheOperation getCacheOperation(MethodInvocationContext<Object, Object> context, boolean isVoid) {
        ExecutableMethod method = context.getExecutableMethod();
        CacheOperation cacheOperation = this.cacheOperations.get(method);
        if (cacheOperation == null) {
            cacheOperation = new CacheOperation(method, isVoid);
            this.cacheOperations.put(method, cacheOperation);
        }
        return cacheOperation;
    }

    private CompletionStage<?> processFuturePutOperations(MethodInvocationContext<Object, Object> context, CacheOperation cacheOperation, CompletionStage<?> value) {
        List<AnnotationValue<CachePut>> putOperations = cacheOperation.putOperations;
        if (CollectionUtils.isNotEmpty(putOperations)) {
            for (AnnotationValue<CachePut> putOperation : putOperations) {
                Object[] cacheNames = cacheOperation.getCachePutNames(putOperation);
                if (!ArrayUtils.isNotEmpty((Object[])cacheNames)) continue;
                boolean isAsync = putOperation.isTrue(MEMBER_ASYNC);
                if (isAsync) {
                    value.whenCompleteAsync((arg_0, arg_1) -> this.lambda$processFuturePutOperations$22(context, cacheOperation, putOperation, (String[])cacheNames, arg_0, arg_1), this.ioExecutor);
                    continue;
                }
                return value.thenCompose(arg_0 -> this.lambda$processFuturePutOperations$23(context, cacheOperation, putOperation, (String[])cacheNames, arg_0));
            }
        }
        return value;
    }

    private CompletionStage<?> processFutureInvalidateOperations(MethodInvocationContext<Object, Object> context, CacheOperation cacheOperation, CompletionStage<?> value) {
        List<AnnotationValue<CacheInvalidate>> invalidateOperations = cacheOperation.invalidateOperations;
        if (CollectionUtils.isNotEmpty(invalidateOperations)) {
            for (AnnotationValue<CacheInvalidate> invalidateOperation : invalidateOperations) {
                Object[] cacheNames = cacheOperation.getCacheInvalidateNames(invalidateOperation);
                if (!ArrayUtils.isNotEmpty((Object[])cacheNames)) continue;
                boolean isAsync = invalidateOperation.isTrue(MEMBER_ASYNC);
                if (isAsync) {
                    value.whenCompleteAsync((arg_0, arg_1) -> this.lambda$processFutureInvalidateOperations$24(context, cacheOperation, invalidateOperation, (String[])cacheNames, arg_0, arg_1), this.ioExecutor);
                    continue;
                }
                return value.thenCompose(arg_0 -> this.lambda$processFutureInvalidateOperations$26(context, cacheOperation, invalidateOperation, (String[])cacheNames, arg_0));
            }
        }
        return value;
    }

    private CompletableFuture<Object> putAsync(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue<CachePut> putOperation, String[] cacheNames, Object value, CacheErrorHandler errorHandler) {
        Object key = this.getOperationKey(context, (AnnotationValueResolver)putOperation, cacheOperation.getCachePutKeyGenerator(putOperation));
        if (value == null) {
            return this.buildInvalidateFutures(cacheNames, key, errorHandler).thenApply(ignore -> null);
        }
        return this.buildPutFutures(cacheNames, key, value, errorHandler).thenApply(ignore -> value);
    }

    private CompletableFuture<Boolean> invalidateAsync(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue<CacheInvalidate> invalidateOperation, String[] cacheNames, CacheErrorHandler errorHandler) {
        boolean invalidateAll = invalidateOperation.isTrue(MEMBER_ALL);
        if (invalidateAll) {
            return this.buildInvalidateAllFutures(cacheNames, errorHandler);
        }
        CacheKeyGenerator keyGenerator = cacheOperation.getCacheInvalidateKeyGenerator(invalidateOperation);
        Object key = this.getOperationKey(context, (AnnotationValueResolver)invalidateOperation, keyGenerator);
        return this.buildInvalidateFutures(cacheNames, key, errorHandler);
    }

    private Object getCacheableKey(MethodInvocationContext context, CacheOperation cacheOperation) {
        CacheKeyGenerator keyGenerator = this.resolveKeyGenerator(cacheOperation.defaultKeyGenerator, context.classValue(Cacheable.class, MEMBER_KEY_GENERATOR).orElse(null));
        Object[] parameterValues = this.resolveParams(context, context.stringValues(Cacheable.class, MEMBER_PARAMETERS));
        return keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
    }

    private Object getOperationKey(MethodInvocationContext context, AnnotationValueResolver annotationValueResolver, CacheKeyGenerator keyGenerator) {
        String[] parameterNames = annotationValueResolver.stringValues(MEMBER_PARAMETERS);
        Object[] parameterValues = this.resolveParams(context, parameterNames);
        return keyGenerator.generateKey((AnnotationMetadata)context, parameterValues);
    }

    protected CacheKeyGenerator resolveKeyGenerator(Class<? extends CacheKeyGenerator> type) {
        if (type == null) {
            type = DefaultCacheKeyGenerator.class;
        }
        return this.keyGenerators.computeIfAbsent(type, aClass -> {
            Optional cacheKeyGenerator = this.beanContext.findBean(aClass);
            if (cacheKeyGenerator.isPresent()) {
                return (CacheKeyGenerator)cacheKeyGenerator.get();
            }
            return (CacheKeyGenerator)InstantiationUtils.instantiate((Class)aClass);
        });
    }

    private CompletableFuture<Boolean> buildPutFutures(String[] cacheNames, Object key, Object value, CacheErrorHandler errorHandler) {
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        for (String cacheName : cacheNames) {
            AsyncCache asyncCache = this.cacheManager.getCache(cacheName).async();
            futures.add(this.asyncCachePut(asyncCache, key, value, errorHandler));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(ignore -> true);
    }

    private CompletableFuture<Boolean> buildInvalidateFutures(String[] cacheNames, Object key, CacheErrorHandler errorHandler) {
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>(cacheNames.length);
        for (String cacheName : cacheNames) {
            AsyncCache asyncCache = this.cacheManager.getCache(cacheName).async();
            futures.add(this.asyncCacheInvalidate(asyncCache, key, errorHandler));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(ignore -> true);
    }

    private CompletableFuture<Boolean> buildInvalidateAllFutures(String[] cacheNames, CacheErrorHandler errorHandler) {
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>(cacheNames.length);
        for (String cacheName : cacheNames) {
            AsyncCache asyncCache = this.cacheManager.getCache(cacheName).async();
            futures.add(this.asyncCacheInvalidateAll(asyncCache, errorHandler));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(ignore -> true);
    }

    private CacheKeyGenerator resolveKeyGenerator(CacheKeyGenerator defaultKeyGenerator, Class type) {
        Class alternateKeyGen;
        CacheKeyGenerator keyGenerator = defaultKeyGenerator;
        Class clazz = alternateKeyGen = type != null && CacheKeyGenerator.class.isAssignableFrom(type) ? type : null;
        if (alternateKeyGen != null && keyGenerator.getClass() != alternateKeyGen) {
            keyGenerator = this.resolveKeyGenerator(alternateKeyGen);
        }
        if (keyGenerator == null) {
            return new DefaultCacheKeyGenerator();
        }
        return keyGenerator;
    }

    private String[] resolveCacheNames(String[] defaultCacheNames, String[] cacheNames) {
        if (ArrayUtils.isEmpty((Object[])cacheNames)) {
            cacheNames = defaultCacheNames;
        }
        return cacheNames;
    }

    protected Object doContextProceed(MethodInvocationContext context) {
        return context.proceed();
    }

    private void doProceed(MethodInvocationContext context, ValueWrapper wrapper) {
        Object result = this.doContextProceed(context);
        if (result instanceof Optional) {
            Optional optional = (Optional)result;
            wrapper.optional = true;
            if (optional.isPresent()) {
                wrapper.value = optional.get();
            }
        } else {
            wrapper.value = result;
        }
    }

    private void processCachePut(MethodInvocationContext<?, ?> context, ValueWrapper wrapper, AnnotationValue<CachePut> cacheConfig, CacheOperation cacheOperation) {
        Object[] cacheNames = cacheOperation.getCachePutNames(cacheConfig);
        if (!ArrayUtils.isEmpty((Object[])cacheNames)) {
            boolean isAsync = cacheConfig.isTrue(MEMBER_ASYNC);
            Object value = wrapper.value;
            if (isAsync) {
                this.ioExecutor.submit(() -> this.lambda$processCachePut$33(cacheOperation, cacheConfig, context, value, (String[])cacheNames));
            } else {
                CacheKeyGenerator keyGenerator = cacheOperation.getCachePutKeyGenerator(cacheConfig);
                Object key = this.getOperationKey((MethodInvocationContext)context, (AnnotationValueResolver)cacheConfig, keyGenerator);
                this.syncPut((String[])cacheNames, key, value);
            }
        }
    }

    private void syncPut(String[] cacheNames, Object key, Object value) {
        for (String cacheName : cacheNames) {
            SyncCache syncCache = this.cacheManager.getCache(cacheName);
            try {
                if (value == null) {
                    syncCache.invalidate(key);
                    continue;
                }
                syncCache.put(key, value);
            }
            catch (RuntimeException e) {
                if (!this.errorHandler.handlePutError(syncCache, key, value, e)) continue;
                throw e;
            }
        }
    }

    private void processCacheEvict(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue<CacheInvalidate> cacheInvalidate) {
        Object[] cacheNames = cacheOperation.getCacheInvalidateNames(cacheInvalidate);
        if (!ArrayUtils.isEmpty((Object[])cacheNames)) {
            boolean isAsync = cacheInvalidate.isTrue(MEMBER_ASYNC);
            if (isAsync) {
                this.ioExecutor.submit(() -> this.lambda$processCacheEvict$34(context, cacheOperation, cacheInvalidate, (String[])cacheNames));
            } else {
                this.invalidateSync(context, cacheOperation, cacheInvalidate, (String[])cacheNames);
            }
        }
    }

    private void invalidateSync(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue<CacheInvalidate> cacheConfig, String[] cacheNames) {
        boolean invalidateAll = cacheConfig.isTrue(MEMBER_ALL);
        for (String cacheName : cacheNames) {
            SyncCache syncCache = this.cacheManager.getCache(cacheName);
            if (invalidateAll) {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Invalidating all the entries of the cache [{}]", (Object)syncCache.getName());
                    }
                    syncCache.invalidateAll();
                    continue;
                }
                catch (RuntimeException e) {
                    if (!this.errorHandler.handleInvalidateError(syncCache, e)) continue;
                    throw e;
                }
            }
            CacheKeyGenerator keyGenerator = cacheOperation.getCacheInvalidateKeyGenerator(cacheConfig);
            Object key = this.getOperationKey(context, (AnnotationValueResolver)cacheConfig, keyGenerator);
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Invalidating the key [{}] of the cache [{}]", key, (Object)syncCache.getName());
                }
                syncCache.invalidate(key);
            }
            catch (RuntimeException e) {
                if (!this.errorHandler.handleInvalidateError(syncCache, key, e)) continue;
                throw e;
            }
        }
    }

    private CompletableFuture<? extends Optional<?>> asyncCacheGet(AsyncCache<?> asyncCache, Object key, Argument<?> requiredType, CacheErrorHandler errorHandler) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting the value for the key [{}] of the cache [{}]", key, (Object)asyncCache.getName());
        }
        return asyncCache.get(key, requiredType).exceptionally(throwable -> this.exceptionallyAsync((Throwable)throwable, () -> errorHandler.handleLoadError(asyncCache, key, this.asRuntimeException((Throwable)throwable)), null));
    }

    private CompletableFuture<Boolean> asyncCachePut(AsyncCache<?> asyncCache, Object key, Object value, CacheErrorHandler errorHandler) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Putting the value [{}] for the key [{}] of the cache [{}]", new Object[]{value, key, asyncCache.getName()});
        }
        return asyncCache.put(key, value).exceptionally(throwable -> this.exceptionallyAsync((Throwable)throwable, () -> errorHandler.handlePutError(asyncCache, key, value, this.asRuntimeException((Throwable)throwable)), true));
    }

    private CompletableFuture<Boolean> asyncCacheInvalidate(AsyncCache<?> asyncCache, Object key, CacheErrorHandler errorHandler) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Invalidating the key [{}] of the cache [{}]", key, (Object)asyncCache.getName());
        }
        return asyncCache.invalidate(key).exceptionally(throwable -> this.exceptionallyAsync((Throwable)throwable, () -> errorHandler.handleInvalidateError(asyncCache, key, this.asRuntimeException((Throwable)throwable)), true));
    }

    private CompletableFuture<Boolean> asyncCacheInvalidateAll(AsyncCache<?> asyncCache, CacheErrorHandler errorHandler) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Invalidating all the entries of the cache [{}]", (Object)asyncCache.getName());
        }
        return asyncCache.invalidateAll().exceptionally(throwable -> this.exceptionallyAsync((Throwable)throwable, () -> errorHandler.handleInvalidateError(asyncCache, this.asRuntimeException((Throwable)throwable)), true));
    }

    private <T> T exceptionallyAsync(Throwable throwable, Supplier<Boolean> handleInvalidateErrorSupplier, T def) {
        boolean handleInvalidateError = true;
        try {
            handleInvalidateError = this.ioExecutor.submit(handleInvalidateErrorSupplier::get).get();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        if (handleInvalidateError) {
            Throwable rethrow = throwable;
            if (rethrow instanceof CompletionException) {
                rethrow = throwable.getCause();
            }
            throw new CompletionException(rethrow);
        }
        return def;
    }

    private RuntimeException asRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    private Object[] resolveParams(MethodInvocationContext<?, ?> context, String[] parameterNames) {
        Object[] parameterValues;
        Object[] methodParameterValues = context.getParameterValues();
        if (ArrayUtils.isEmpty((Object[])parameterNames)) {
            parameterValues = methodParameterValues;
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            Set names = CollectionUtils.setOf((Object[])parameterNames);
            Argument[] arguments = context.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                Argument argument = arguments[i];
                if (!names.contains(argument.getName())) continue;
                list.add(methodParameterValues[i]);
            }
            parameterValues = list.toArray();
        }
        return parameterValues;
    }

    private /* synthetic */ CompletableFuture lambda$processCacheEvict$34(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue cacheInvalidate, String[] cacheNames) throws Exception {
        return this.invalidateAsync(context, cacheOperation, (AnnotationValue<CacheInvalidate>)cacheInvalidate, cacheNames, this.asyncCacheErrorHandler);
    }

    private /* synthetic */ void lambda$processCachePut$33(CacheOperation cacheOperation, AnnotationValue cacheConfig, MethodInvocationContext context, Object value, String[] cacheNames) {
        CacheKeyGenerator keyGenerator = cacheOperation.getCachePutKeyGenerator((AnnotationValue<CachePut>)cacheConfig);
        Object key = this.getOperationKey(context, (AnnotationValueResolver)cacheConfig, keyGenerator);
        if (value == null) {
            this.buildInvalidateFutures(cacheNames, key, this.asyncCacheErrorHandler);
        } else {
            this.buildPutFutures(cacheNames, key, value, this.asyncCacheErrorHandler);
        }
    }

    private /* synthetic */ CompletionStage lambda$processFutureInvalidateOperations$26(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue invalidateOperation, String[] cacheNames, Object result) {
        return this.invalidateAsync(context, cacheOperation, (AnnotationValue<CacheInvalidate>)invalidateOperation, cacheNames, this.errorHandler).thenApply(ignore -> result);
    }

    private /* synthetic */ void lambda$processFutureInvalidateOperations$24(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue invalidateOperation, String[] cacheNames, Object result, Throwable throwable) {
        if (throwable == null) {
            this.invalidateAsync(context, cacheOperation, (AnnotationValue<CacheInvalidate>)invalidateOperation, cacheNames, this.asyncCacheErrorHandler);
        }
    }

    private /* synthetic */ CompletionStage lambda$processFuturePutOperations$23(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue putOperation, String[] cacheNames, Object result) {
        return this.putAsync(context, cacheOperation, (AnnotationValue<CachePut>)putOperation, cacheNames, result, this.errorHandler);
    }

    private /* synthetic */ void lambda$processFuturePutOperations$22(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue putOperation, String[] cacheNames, Object result, Throwable throwable) {
        if (throwable == null) {
            this.putAsync(context, cacheOperation, (AnnotationValue<CachePut>)putOperation, cacheNames, result, this.asyncCacheErrorHandler);
        }
    }

    private /* synthetic */ Mono lambda$handleMultiWriteOperations$14(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue putOperation, String[] cacheNames, List result) {
        return Mono.fromCompletionStage(this.putAsync(context, cacheOperation, (AnnotationValue<CachePut>)putOperation, cacheNames, result, this.asyncCacheErrorHandler)).thenReturn((Object)result);
    }

    private /* synthetic */ void lambda$handleMultiWriteOperations$12(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue putOperation, String[] cacheNames, List result) {
        Mono.fromCompletionStage(this.putAsync(context, cacheOperation, (AnnotationValue<CachePut>)putOperation, cacheNames, result, this.asyncCacheErrorHandler));
    }

    private /* synthetic */ Mono lambda$handleSingleWriteOperations$7(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue invalidateOperation, String[] cacheNames, Object result) {
        return Mono.fromCompletionStage(this.invalidateAsync(context, cacheOperation, (AnnotationValue<CacheInvalidate>)invalidateOperation, cacheNames, this.asyncCacheErrorHandler)).thenReturn(result);
    }

    private /* synthetic */ void lambda$handleSingleWriteOperations$6(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue invalidateOperation, String[] cacheNames, Object result) {
        Mono.fromCompletionStage(this.invalidateAsync(context, cacheOperation, (AnnotationValue<CacheInvalidate>)invalidateOperation, cacheNames, this.asyncCacheErrorHandler));
    }

    private /* synthetic */ Mono lambda$handleSingleWriteOperations$5(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue putOperation, String[] cacheNames, Object result) {
        return Mono.fromCompletionStage(this.putAsync(context, cacheOperation, (AnnotationValue<CachePut>)putOperation, cacheNames, result, this.asyncCacheErrorHandler)).thenReturn(result);
    }

    private /* synthetic */ void lambda$handleSingleWriteOperations$4(MethodInvocationContext context, CacheOperation cacheOperation, AnnotationValue putOperation, String[] cacheNames, Object result) {
        Mono.fromCompletionStage(this.putAsync(context, cacheOperation, (AnnotationValue<CachePut>)putOperation, cacheNames, result, this.asyncCacheErrorHandler));
    }

    private static class ValueWrapper {
        Object value;
        boolean optional;

        private ValueWrapper() {
        }
    }

    private class CacheOperation {
        final CacheKeyGenerator defaultKeyGenerator;
        final String[] defaultCacheNames;
        final boolean cacheable;
        String cacheableCacheName;
        List<AnnotationValue<CachePut>> putOperations;
        List<AnnotationValue<CacheInvalidate>> invalidateOperations;

        CacheOperation(ExecutableMethod<?, ?> method, boolean isVoid) {
            this.defaultKeyGenerator = CacheInterceptor.this.resolveKeyGenerator(method.classValue(CacheConfig.class, CacheInterceptor.MEMBER_KEY_GENERATOR).orElse(this.getDefaultKeyGenerator(method)));
            this.putOperations = isVoid ? null : CacheInterceptor.this.putOperations(method);
            this.invalidateOperations = CacheInterceptor.this.invalidateOperations(method);
            this.defaultCacheNames = method.stringValues(CacheConfig.class, CacheInterceptor.MEMBER_CACHE_NAMES);
            this.cacheable = method.hasStereotype(Cacheable.class);
            if (!isVoid && this.cacheable) {
                Object[] names = CacheInterceptor.this.resolveCacheNames(this.defaultCacheNames, method.stringValues(Cacheable.class, CacheInterceptor.MEMBER_CACHE_NAMES));
                if (ArrayUtils.isNotEmpty((Object[])names)) {
                    this.cacheableCacheName = names[0];
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("No cache names defined for invocation [{}]. Skipping cache read operations.", method);
                }
            }
        }

        private Class<? extends CacheKeyGenerator> getDefaultKeyGenerator(ExecutableMethod<?, ?> method) {
            if (method.isSuspend()) {
                return KotlinSuspendFunCacheKeyGenerator.class;
            }
            return DefaultCacheKeyGenerator.class;
        }

        boolean hasWriteOperations() {
            return CollectionUtils.isNotEmpty(this.putOperations) || CollectionUtils.isNotEmpty(this.invalidateOperations);
        }

        String[] getCachePutNames(AnnotationValue<CachePut> cacheConfig) {
            return this.getCacheNames(cacheConfig.stringValues(CacheInterceptor.MEMBER_CACHE_NAMES));
        }

        String[] getCacheInvalidateNames(AnnotationValue<CacheInvalidate> cacheConfig) {
            return this.getCacheNames(cacheConfig.stringValues(CacheInterceptor.MEMBER_CACHE_NAMES));
        }

        CacheKeyGenerator getCacheInvalidateKeyGenerator(AnnotationValue<CacheInvalidate> cacheConfig) {
            return cacheConfig.get((CharSequence)CacheInterceptor.MEMBER_KEY_GENERATOR, CacheKeyGenerator.class).orElseGet(() -> this.getKeyGenerator(cacheConfig.classValue(CacheInterceptor.MEMBER_KEY_GENERATOR).orElse(null)));
        }

        CacheKeyGenerator getCachePutKeyGenerator(AnnotationValue<CachePut> cacheConfig) {
            return cacheConfig.get((CharSequence)CacheInterceptor.MEMBER_KEY_GENERATOR, CacheKeyGenerator.class).orElseGet(() -> this.getKeyGenerator(cacheConfig.classValue(CacheInterceptor.MEMBER_KEY_GENERATOR).orElse(null)));
        }

        private String[] getCacheNames(String[] cacheNames) {
            if (ArrayUtils.isEmpty((Object[])cacheNames)) {
                return this.defaultCacheNames;
            }
            return cacheNames;
        }

        private CacheKeyGenerator getKeyGenerator(Class<?> alternateKeyGen) {
            CacheKeyGenerator keyGenerator = this.defaultKeyGenerator;
            if (alternateKeyGen != null && this.defaultKeyGenerator.getClass() != alternateKeyGen && CacheKeyGenerator.class.isAssignableFrom(alternateKeyGen)) {
                keyGenerator = CacheInterceptor.this.resolveKeyGenerator(alternateKeyGen);
            }
            return keyGenerator;
        }
    }
}

