/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.JavaConfigurationMetadataBuilder;
import io.micronaut.annotation.processing.visitor.JavaAnnotationElement;
import io.micronaut.annotation.processing.visitor.JavaBeanDefinitionBuilder;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaConstructorElement;
import io.micronaut.annotation.processing.visitor.JavaEnumElement;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaParameterElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementFactory;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class JavaElementFactory
implements ElementFactory<Element, TypeElement, ExecutableElement, VariableElement> {
    private final JavaVisitorContext visitorContext;

    public JavaElementFactory(JavaVisitorContext visitorContext) {
        this.visitorContext = Objects.requireNonNull(visitorContext, "Visitor context cannot be null");
    }

    @NonNull
    public JavaClassElement newClassElement(@NonNull TypeElement type, @NonNull AnnotationMetadata annotationMetadata) {
        ElementKind kind = type.getKind();
        switch (kind) {
            case ENUM: {
                return new JavaEnumElement(type, annotationMetadata, this.visitorContext);
            }
            case ANNOTATION_TYPE: {
                return new JavaAnnotationElement(type, annotationMetadata, this.visitorContext);
            }
        }
        return new JavaClassElement(type, annotationMetadata, this.visitorContext);
    }

    @NonNull
    public ClassElement newClassElement(@NonNull TypeElement type, @NonNull AnnotationMetadata annotationMetadata, final @NonNull Map<String, ClassElement> resolvedGenerics) {
        ElementKind kind = type.getKind();
        switch (kind) {
            case ENUM: {
                return new JavaEnumElement(type, annotationMetadata, this.visitorContext){

                    @Override
                    @NonNull
                    public Map<String, ClassElement> getTypeArguments() {
                        if (resolvedGenerics != null) {
                            return resolvedGenerics;
                        }
                        return super.getTypeArguments();
                    }
                };
            }
            case ANNOTATION_TYPE: {
                return new JavaAnnotationElement(type, annotationMetadata, this.visitorContext);
            }
        }
        return new JavaClassElement(type, annotationMetadata, this.visitorContext){

            @Override
            @NonNull
            public Map<String, ClassElement> getTypeArguments() {
                if (resolvedGenerics != null) {
                    return resolvedGenerics;
                }
                return super.getTypeArguments();
            }
        };
    }

    @NonNull
    public JavaClassElement newSourceClassElement(@NonNull TypeElement type, @NonNull AnnotationMetadata annotationMetadata) {
        ElementKind kind = type.getKind();
        if (kind == ElementKind.ENUM) {
            return new JavaEnumElement(type, annotationMetadata, this.visitorContext){

                @NonNull
                public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                    return new JavaBeanDefinitionBuilder(this, type, new JavaConfigurationMetadataBuilder(this.visitorContext.getElements(), this.visitorContext.getTypes(), this.visitorContext.getAnnotationUtils()), this.visitorContext);
                }
            };
        }
        return new JavaClassElement(type, annotationMetadata, this.visitorContext){

            @NonNull
            public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                return new JavaBeanDefinitionBuilder(this, type, new JavaConfigurationMetadataBuilder(this.visitorContext.getElements(), this.visitorContext.getTypes(), this.visitorContext.getAnnotationUtils()), this.visitorContext);
            }
        };
    }

    @NonNull
    public JavaMethodElement newSourceMethodElement(ClassElement declaringClass, @NonNull ExecutableElement method, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(declaringClass instanceof JavaClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a JavaClassElement");
        }
        return new JavaMethodElement((JavaClassElement)declaringClass, method, annotationMetadata, this.visitorContext){

            @NonNull
            public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                return new JavaBeanDefinitionBuilder(this, type, new JavaConfigurationMetadataBuilder(this.visitorContext.getElements(), this.visitorContext.getTypes(), this.visitorContext.getAnnotationUtils()), this.visitorContext);
            }
        };
    }

    @NonNull
    public JavaMethodElement newMethodElement(ClassElement declaringClass, @NonNull ExecutableElement method, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(declaringClass instanceof JavaClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a JavaClassElement");
        }
        return new JavaMethodElement((JavaClassElement)declaringClass, method, annotationMetadata, this.visitorContext);
    }

    public JavaMethodElement newMethodElement(ClassElement declaringClass, @NonNull ExecutableElement method, @NonNull AnnotationMetadata annotationMetadata, final @Nullable Map<String, Map<String, TypeMirror>> genericTypes) {
        if (!(declaringClass instanceof JavaClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a JavaClassElement");
        }
        final JavaClassElement javaDeclaringClass = (JavaClassElement)declaringClass;
        final JavaVisitorContext javaVisitorContext = this.visitorContext;
        return new JavaMethodElement(javaDeclaringClass, method, annotationMetadata, javaVisitorContext){

            @Override
            @NonNull
            protected JavaParameterElement newParameterElement(@NonNull VariableElement variableElement, @NonNull AnnotationMetadata annotationMetadata1) {
                return new JavaParameterElement(javaDeclaringClass, variableElement, annotationMetadata1, javaVisitorContext){

                    @Override
                    @NonNull
                    public ClassElement getGenericType() {
                        if (genericTypes != null) {
                            return this.parameterizedClassElement(this.getNativeType().asType(), javaVisitorContext, genericTypes);
                        }
                        return super.getGenericType();
                    }
                };
            }

            @Override
            @NonNull
            public ClassElement getGenericReturnType() {
                if (genericTypes != null) {
                    return super.returnType(genericTypes);
                }
                return super.getGenericReturnType();
            }
        };
    }

    @NonNull
    public JavaConstructorElement newConstructorElement(ClassElement declaringClass, @NonNull ExecutableElement constructor, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(declaringClass instanceof JavaClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a JavaClassElement");
        }
        return new JavaConstructorElement((JavaClassElement)declaringClass, constructor, annotationMetadata, this.visitorContext);
    }

    @NonNull
    public JavaFieldElement newFieldElement(ClassElement declaringClass, @NonNull VariableElement field, @NonNull AnnotationMetadata annotationMetadata) {
        return new JavaFieldElement((JavaClassElement)declaringClass, field, annotationMetadata, this.visitorContext);
    }

    @NonNull
    public JavaFieldElement newFieldElement(@NonNull VariableElement field, @NonNull AnnotationMetadata annotationMetadata) {
        return new JavaFieldElement(field, annotationMetadata, this.visitorContext);
    }

    @NonNull
    public JavaParameterElement newParameterElement(ClassElement declaringClass, @NonNull VariableElement field, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(declaringClass instanceof JavaClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a JavaClassElement");
        }
        return new JavaParameterElement((JavaClassElement)declaringClass, field, annotationMetadata, this.visitorContext);
    }
}

