/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder.impl;

import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.grails.encoder.AbstractCharReplacementEncoder;
import org.grails.encoder.CodecIdentifier;
import org.grails.encoder.DefaultCodecIdentifier;
import org.grails.encoder.impl.JavaScriptEncoder;
import org.springframework.util.ClassUtils;

public class BasicJSONEncoder
extends AbstractCharReplacementEncoder {
    public static final CodecIdentifier JSON_CODEC_IDENTIFIER = new DefaultCodecIdentifier("JSON", new String[]{"Json"}){

        @Override
        public boolean isEquivalent(CodecIdentifier other) {
            return super.isEquivalent(other) || JavaScriptEncoder.JAVASCRIPT_CODEC_IDENTIFIER.getCodecName().equals(other.getCodecName());
        }
    };

    public BasicJSONEncoder() {
        super(JSON_CODEC_IDENTIFIER);
    }

    @Override
    protected String escapeCharacter(char ch, char previousChar) {
        switch (ch) {
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\b': {
                return "\\b";
            }
            case '\u000b': {
                return "\\u000B";
            }
            case '\u2028': {
                return "\\u2028";
            }
            case '\u2029': {
                return "\\u2029";
            }
            case '/': {
                if (previousChar != '<') break;
                return "\\u002f";
            }
        }
        if (ch < ' ') {
            return "\\u" + StringGroovyMethods.padLeft((CharSequence)Integer.toHexString(ch), (Number)4, (CharSequence)"0");
        }
        return null;
    }

    @Override
    public boolean isApplyToSafelyEncoded() {
        return true;
    }

    @Override
    public final Object encode(Object o) {
        return this.doEncode(o);
    }

    protected Object doEncode(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence || ClassUtils.isPrimitiveOrWrapper(o.getClass())) {
            return super.encode(o);
        }
        return this.encodeAsJsonObject(o);
    }

    protected Object encodeAsJsonObject(Object o) {
        return o;
    }
}

