/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.logging.impl;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.classic.util.EnvUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.logging.LoggingSystemException;
import java.net.URL;
import java.util.function.Supplier;

public final class LogbackUtils {
    private LogbackUtils() {
    }

    public static void configure(@NonNull ClassLoader classLoader, @NonNull LoggerContext context, @NonNull String logbackXmlLocation) {
        LogbackUtils.configure(context, logbackXmlLocation, () -> classLoader.getResource(logbackXmlLocation));
    }

    private static void configure(@NonNull LoggerContext context, @NonNull String logbackXmlLocation, Supplier<URL> resourceSupplier) {
        Configurator configurator = (Configurator)EnvUtil.loadFromServiceLoader(Configurator.class);
        if (configurator != null) {
            context.getStatusManager().add((Status)new InfoStatus("Using " + configurator.getClass().getName(), (Object)context));
            LogbackUtils.programmaticConfiguration(context, configurator);
        } else {
            URL resource = resourceSupplier.get();
            if (resource != null) {
                try {
                    new ContextInitializer(context).configureByResource(resource);
                }
                catch (JoranException e) {
                    throw new LoggingSystemException("Error while refreshing Logback", e);
                }
            } else {
                throw new LoggingSystemException("Resource " + logbackXmlLocation + " not found");
            }
        }
    }

    private static void programmaticConfiguration(@NonNull LoggerContext context, @NonNull Configurator configurator) {
        try {
            configurator.setContext((Context)context);
            configurator.configure(context);
        }
        catch (Exception e) {
            throw new LoggingSystemException(String.format("Failed to initialize Configurator: %s using ServiceLoader", configurator.getClass().getCanonicalName()), e);
        }
    }
}

