/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.internal.Colorizer;
import org.kordamp.jarviz.core.model.BytecodeVersion;
import org.kordamp.jarviz.core.model.BytecodeVersions;
import org.kordamp.jarviz.core.processors.BytecodeShowJarProcessor;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;

public class BytecodeShowCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        BytecodeShowJarProcessor processor = new BytecodeShowJarProcessor(jarFileResolver);
        Set<JarProcessor.JarFileResult<BytecodeVersions>> results = processor.getResult();
        if (results.isEmpty()) {
            return 1;
        }
        this.output(configuration, results);
        this.report(configuration, results);
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<BytecodeVersions>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<BytecodeVersions> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(configuration, outputFormat, root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<BytecodeVersions> result) {
        Set<BytecodeVersion> manifestBytecode;
        configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
        BytecodeVersions bytecodeVersions = result.getResult();
        BytecodeVersion bc = BytecodeVersion.of(configuration.getBytecodeVersion() != null && configuration.getBytecodeVersion() > 43 ? configuration.getBytecodeVersion() : 0);
        Integer jv = configuration.getJavaVersion() != null && configuration.getJavaVersion() > 8 ? configuration.getJavaVersion() : 0;
        if (bc.isEmpty() && 0 == jv && (manifestBytecode = bytecodeVersions.getManifestBytecode()).size() > 0) {
            configuration.getOut().println(this.$$("bytecode.version.attribute", manifestBytecode.stream().map(String::valueOf).map(Colorizer::cyan).collect(Collectors.joining(","))));
        }
        if (0 == jv) {
            Map<BytecodeVersion, List<String>> unversionedClasses = bytecodeVersions.getUnversionedClasses();
            if (bc.isEmpty()) {
                unversionedClasses.keySet().stream().sorted().forEach(bytecodeVersion -> this.printUnversioned(configuration, unversionedClasses, (BytecodeVersion)bytecodeVersion));
            } else {
                this.printUnversioned(configuration, unversionedClasses, bc);
            }
        }
        Set<Integer> javaVersions = bytecodeVersions.getJavaVersionOfVersionedClasses();
        if (0 == jv) {
            for (Integer javaVersion : javaVersions) {
                Map<BytecodeVersion, List<String>> versionedClasses = bytecodeVersions.getVersionedClasses(javaVersion);
                if (bc.isEmpty()) {
                    for (Map.Entry<BytecodeVersion, List<String>> entry : versionedClasses.entrySet()) {
                        this.printVersioned(configuration, versionedClasses, javaVersion, entry.getKey());
                    }
                    continue;
                }
                this.printVersioned(configuration, versionedClasses, javaVersion, bc);
            }
        } else {
            Map<BytecodeVersion, List<String>> versionedClasses = bytecodeVersions.getVersionedClasses(jv);
            if (bc.isEmpty()) {
                for (Map.Entry<BytecodeVersion, List<String>> entry : versionedClasses.entrySet()) {
                    this.printVersioned(configuration, versionedClasses, jv, entry.getKey());
                }
            } else {
                this.printVersioned(configuration, versionedClasses, jv, bc);
            }
        }
    }

    private void printUnversioned(Configuration configuration, Map<BytecodeVersion, List<String>> unversionedClasses, BytecodeVersion bytecodeVersion) {
        if (!unversionedClasses.containsKey(bytecodeVersion)) {
            return;
        }
        List<String> classes = unversionedClasses.get(bytecodeVersion);
        configuration.getOut().println(this.$$("bytecode.unversioned.classes.total", bytecodeVersion, classes.size()));
        if (configuration.isDetails()) {
            classes.forEach(configuration.getOut()::println);
        }
    }

    private void printVersioned(Configuration configuration, Map<BytecodeVersion, List<String>> versionedClasses, Integer javaVersion, BytecodeVersion bytecodeVersion) {
        if (!versionedClasses.containsKey(bytecodeVersion)) {
            return;
        }
        List<String> classes = versionedClasses.get(bytecodeVersion);
        configuration.getOut().println(this.$$("bytecode.versioned.classes.total", javaVersion, bytecodeVersion, classes.size()));
        if (configuration.isDetails()) {
            classes.forEach(configuration.getOut()::println);
        }
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<BytecodeVersions>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<BytecodeVersions> result : results) {
                this.buildReport(configuration, format, root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Configuration configuration, Format format, Node root, JarProcessor.JarFileResult<BytecodeVersions> result) {
        this.appendSubject(root, result.getJarPath(), "bytecode show", resultNode -> {
            Set<BytecodeVersion> manifestBytecode;
            BytecodeVersions bytecodeVersions = (BytecodeVersions)result.getResult();
            BytecodeVersion bc = BytecodeVersion.of(configuration.getBytecodeVersion() != null && configuration.getBytecodeVersion() > 43 ? configuration.getBytecodeVersion() : 0);
            Integer jv = configuration.getJavaVersion() != null && configuration.getBytecodeVersion() > 8 ? configuration.getBytecodeVersion() : 0;
            if (bc.isEmpty() && 0 == jv && (manifestBytecode = bytecodeVersions.getManifestBytecode()).size() > 0) {
                Node bytecode = resultNode.array(RB.$("report.key.bytecode", new Object[0]));
                manifestBytecode.stream().map(String::valueOf).forEach(v -> {
                    if (format == Format.TXT) {
                        bytecode.node((String)v).end();
                    } else {
                        bytecode.collapsable(RB.$("report.key.version", new Object[0])).value(v).end();
                    }
                });
            }
            if (0 == jv) {
                Map<BytecodeVersion, List<String>> unversionedClasses = bytecodeVersions.getUnversionedClasses();
                if (bc.isEmpty()) {
                    unversionedClasses.keySet().stream().sorted().forEach(bytecodeVersion -> this.reportUnversioned(configuration, (Node)resultNode, unversionedClasses, (BytecodeVersion)bytecodeVersion));
                } else {
                    this.reportUnversioned(configuration, (Node)resultNode, unversionedClasses, bc);
                }
            }
            Set<Integer> javaVersions = bytecodeVersions.getJavaVersionOfVersionedClasses();
            if (0 == jv) {
                for (Integer javaVersion : javaVersions) {
                    Map<BytecodeVersion, List<String>> versionedClasses = bytecodeVersions.getVersionedClasses(javaVersion);
                    if (bc.isEmpty()) {
                        for (Map.Entry<BytecodeVersion, List<String>> entry : versionedClasses.entrySet()) {
                            this.reportVersioned(configuration, (Node)resultNode, versionedClasses, javaVersion, entry.getKey());
                        }
                        continue;
                    }
                    this.reportVersioned(configuration, (Node)resultNode, versionedClasses, javaVersion, bc);
                }
            } else {
                Map<BytecodeVersion, List<String>> versionedClasses = bytecodeVersions.getVersionedClasses(jv);
                if (bc.isEmpty()) {
                    for (Map.Entry<BytecodeVersion, List<String>> entry : versionedClasses.entrySet()) {
                        this.reportVersioned(configuration, (Node)resultNode, versionedClasses, jv, entry.getKey());
                    }
                } else {
                    this.reportVersioned(configuration, (Node)resultNode, versionedClasses, jv, bc);
                }
            }
        });
    }

    private void reportUnversioned(Configuration configuration, Node resultNode, Map<BytecodeVersion, List<String>> unversionedClasses, BytecodeVersion bytecodeVersion) {
        if (!unversionedClasses.containsKey(bytecodeVersion)) {
            return;
        }
        List<String> classes = unversionedClasses.get(bytecodeVersion);
        Node unversioned = resultNode.node(RB.$("report.key.unversioned", new Object[0])).node(RB.$("report.key.bytecode", new Object[0])).value(bytecodeVersion).end().node(RB.$("report.key.total", new Object[0])).value(classes.size()).end();
        if (configuration.isDetails()) {
            unversioned.array(RB.$("report.key.classes", new Object[0])).collapsableChildren(RB.$("report.key.class", new Object[0]), classes);
        }
    }

    private void reportVersioned(Configuration configuration, Node resultNode, Map<BytecodeVersion, List<String>> versionedClasses, Integer javaVersion, BytecodeVersion bytecodeVersion) {
        if (!versionedClasses.containsKey(bytecodeVersion)) {
            return;
        }
        List<String> classes = versionedClasses.get(bytecodeVersion);
        Node versioned = resultNode.node(RB.$("report.key.versioned", new Object[0])).node(RB.$("report.key.java.version", new Object[0])).value(javaVersion).end().node(RB.$("report.key.bytecode", new Object[0])).value(bytecodeVersion).end().node(RB.$("report.key.total", new Object[0])).value(classes.size()).end();
        if (configuration.isDetails()) {
            versioned.array(RB.$("report.key.classes", new Object[0])).collapsableChildren(RB.$("report.key.class", new Object[0]), classes);
        }
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
        private boolean details;
        private Integer bytecodeVersion;
        private Integer javaVersion;

        public boolean isDetails() {
            return this.details;
        }

        public Configuration withDetails(boolean details) {
            this.details = details;
            return this;
        }

        public Integer getBytecodeVersion() {
            return this.bytecodeVersion;
        }

        public Configuration withBytecodeVersion(Integer bytecodeVersion) {
            this.bytecodeVersion = bytecodeVersion;
            return this;
        }

        public Integer getJavaVersion() {
            return this.javaVersion;
        }

        public Configuration withJavaVersion(Integer javaVersion) {
            this.javaVersion = javaVersion;
            return this;
        }
    }
}

