/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.analyzers.QueryJarManifestAnalyzer;
import org.kordamp.jarviz.core.model.BytecodeVersion;
import org.kordamp.jarviz.core.model.BytecodeVersions;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.JarUtils;

public class BytecodeShowJarProcessor
implements JarProcessor<BytecodeVersions> {
    private static final Pattern MULTIRELEASE = Pattern.compile("META-INF/versions/(\\d+)/(.*\\.class)");
    private final JarFileResolver jarFileResolver;

    public BytecodeShowJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    @Override
    public Set<JarProcessor.JarFileResult<BytecodeVersions>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<BytecodeVersions>> set = new TreeSet<JarProcessor.JarFileResult<BytecodeVersions>>();
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            set.add(this.processJarFile(jarFile));
        }
        return set;
    }

    private JarProcessor.JarFileResult<BytecodeVersions> processJarFile(JarFile jarFile) {
        BytecodeVersions bytecodeVersions = new BytecodeVersions();
        Optional<Manifest> manifest = JarUtils.getManifest(jarFile);
        if (manifest.isPresent()) {
            QueryJarManifestAnalyzer analyzer = new QueryJarManifestAnalyzer("Bytecode-Version");
            analyzer.handle(jarFile, manifest.get());
            ((Optional)analyzer.getResult()).ifPresent(v -> {
                TreeSet<BytecodeVersion> set = new TreeSet<BytecodeVersion>();
                Arrays.stream(v.split(",")).map(Integer::parseInt).map(BytecodeVersion::of).forEach(set::add);
                bytecodeVersions.setManifestBytecode(set);
            });
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class")) continue;
            BytecodeVersion bytecodeVersion = JarUtils.readBytecodeVersion(jarFile, entry);
            Matcher matcher = MULTIRELEASE.matcher(entryName);
            if (matcher.matches()) {
                if (!jarFile.isMultiRelease()) continue;
                Integer javaVersion = Integer.parseInt(matcher.group(1));
                String className = matcher.group(2).replace('/', '.').replace('\\', '.').replace('$', '.');
                className = className.substring(0, className.length() - 6);
                bytecodeVersions.addVersionedClass(javaVersion, bytecodeVersion, className);
                continue;
            }
            String className = entryName.replace('/', '.').replace('\\', '.').replace('$', '.');
            className = className.substring(0, className.length() - 6);
            bytecodeVersions.addUnversionedClass(bytecodeVersion, className);
        }
        return JarProcessor.JarFileResult.of(jarFile, bytecodeVersions);
    }
}

