/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

abstract class BaseBusConnection
implements MessageBusImpl.MessageHandlerHolder {
    protected MessageBusImpl bus;
    protected final AtomicReference<Object[]> subscriptions;

    BaseBusConnection(@NotNull MessageBusImpl bus) {
        if (bus == null) {
            BaseBusConnection.$$$reportNull$$$0(0);
        }
        this.subscriptions = new AtomicReference<Object[]>(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        this.bus = bus;
    }

    public final <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler2) {
        Object[] newList;
        Object[] list2;
        if (topic == null) {
            BaseBusConnection.$$$reportNull$$$0(1);
        }
        if (handler2 == null) {
            BaseBusConnection.$$$reportNull$$$0(2);
        }
        do {
            if ((list2 = this.subscriptions.get()).length == 0) {
                newList = new Object[]{topic, handler2};
                continue;
            }
            int size = list2.length;
            newList = Arrays.copyOf(list2, size + 2);
            newList[size] = topic;
            newList[size + 1] = handler2;
        } while (!this.subscriptions.compareAndSet(list2, newList));
        this.bus.notifyOnSubscription(topic);
    }

    @Override
    public final <L> void collectHandlers(@NotNull Topic<L> topic, @NotNull List<? super L> result2) {
        if (topic == null) {
            BaseBusConnection.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            BaseBusConnection.$$$reportNull$$$0(4);
        }
        Object[] list2 = this.subscriptions.get();
        int n = list2.length;
        for (int i = 0; i < n; i += 2) {
            if (list2[i] != topic) continue;
            result2.add(list2[i + 1]);
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.bus == null;
    }

    public final String toString() {
        return Arrays.toString(this.subscriptions.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/messages/impl/BaseBusConnection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribe";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectHandlers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "disconnectIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

