/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016JW\u0010$\u001a8\u0012(\u0012&\u0012\u0004\u0012\u00020&\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(`)0%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\n0\f2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0+\"\u00020&H\u0016\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/H\u0016J(\u00100\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003H\u0014J\u0018\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0016J3\u00107\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0\n0\f2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0+\"\u00020&H\u0016\u00a2\u0006\u0002\u0010,J\u0016\u00108\u001a\u0002092\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0\nH\u0014J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002J\u001a\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\fH\u0002J\b\u0010<\u001a\u00020\u0003H\u0016J\"\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u000209H\u0016J\b\u0010B\u001a\u000209H\u0016J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J3\u0010F\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020G0\n0\f2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0+\"\u00020&H\u0016\u00a2\u0006\u0002\u0010,J\u0010\u0010H\u001a\u00020\u001d2\u0006\u00101\u001a\u00020&H\u0016J\u0014\u0010I\u001a\u00020\u0003*\u00020\u00032\u0006\u0010J\u001a\u00020KH\u0004R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010 \u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b!\u0010\u001f\u00a8\u0006L"}, d2={"Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "name", "", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;)V", "_allSchemaNames", "", "_allTableNames", "", "allTablesNames", "getAllTablesNames", "()Ljava/util/List;", "columnConstraintsCache", "", "", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "getColumnConstraintsCache", "()Ljava/util/Map;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getName", "()Ljava/lang/String;", "supportsMultipleGeneratedKeys", "", "getSupportsMultipleGeneratedKeys", "()Z", "supportsSelectForUpdate", "getSupportsSelectForUpdate", "supportsSelectForUpdate$delegate", "Lkotlin/Lazy;", "columnConstraints", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Table;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/Column;", "Lkotlin/collections/LinkedHashSet;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createIndexWithType", "table", "columns", "type", "dropIndex", "tableName", "indexName", "existingIndices", "fillConstraintCacheForTables", "", "getAllSchemaNamesCache", "getAllTableNamesCache", "getDatabase", "modifyColumn", "column", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "resetCaches", "resetSchemaCaches", "schemaExists", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "tableColumns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableExists", "quoteIdentifierWhenWrongCaseOrNecessary", "tr", "Lorg/jetbrains/exposed/sql/Transaction;", "exposed-core"})
public abstract class VendorDialect
implements DatabaseDialect {
    @NotNull
    private final String name;
    @NotNull
    private final DataTypeProvider dataTypeProvider;
    @NotNull
    private final FunctionProvider functionProvider;
    @Nullable
    private Map<String, ? extends List<String>> _allTableNames;
    @Nullable
    private List<String> _allSchemaNames;
    private final boolean supportsMultipleGeneratedKeys;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Map<String, Collection<ForeignKeyConstraint>> columnConstraintsCache;

    public VendorDialect(@NotNull String name, @NotNull DataTypeProvider dataTypeProvider, @NotNull FunctionProvider functionProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dataTypeProvider, (String)"dataTypeProvider");
        Intrinsics.checkNotNullParameter((Object)functionProvider, (String)"functionProvider");
        this.name = name;
        this.dataTypeProvider = dataTypeProvider;
        this.functionProvider = functionProvider;
        this.supportsMultipleGeneratedKeys = true;
        this.supportsSelectForUpdate$delegate = LazyKt.lazy((Function0)supportsSelectForUpdate.2.INSTANCE);
        this.columnConstraintsCache = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DataTypeProvider getDataTypeProvider() {
        return this.dataTypeProvider;
    }

    @Override
    @NotNull
    public FunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    @NotNull
    public final List<String> getAllTablesNames() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        return (List)MapsKt.getValue(this.getAllTableNamesCache(), connection.metadata(allTablesNames.1.INSTANCE));
    }

    private final Map<String, List<String>> getAllTableNamesCache() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        if (this._allTableNames == null) {
            this._allTableNames = (Map)connection.metadata(getAllTableNamesCache.1.INSTANCE);
        }
        Map<String, List<String>> map = this._allTableNames;
        Intrinsics.checkNotNull(map);
        return map;
    }

    private final List<String> getAllSchemaNamesCache() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        if (this._allSchemaNames == null) {
            this._allSchemaNames = (List)connection.metadata(getAllSchemaNamesCache.1.INSTANCE);
        }
        List<String> list = this._allSchemaNames;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    @NotNull
    public String getDatabase() {
        return this.catalog(TransactionManager.Companion.current());
    }

    @Override
    @NotNull
    public List<String> allTablesNames() {
        return (List)TransactionManager.Companion.current().getConnection().metadata(allTablesNames.2.INSTANCE);
    }

    @Override
    public boolean tableExists(@NotNull Table table) {
        boolean bl;
        block4: {
            String tableScheme;
            String string;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            String it = string = StringsKt.substringBefore((String)table.getTableName(), (char)'.', (String)"");
            boolean bl2 = false;
            String string2 = tableScheme = ((CharSequence)it).length() > 0 ? string : null;
            String string3 = string2 == null ? null : DefaultKt.inProperCase(string2);
            if (string3 == null) {
                string3 = (String)TransactionManager.Companion.current().getConnection().metadata(tableExists.scheme.1.INSTANCE);
            }
            String scheme2 = string3;
            List allTables = (List)MapsKt.getValue(this.getAllTableNamesCache(), (Object)scheme2);
            Iterable $this$any$iv = allTables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl3 = false;
                    boolean bl4 = tableScheme != null ? Intrinsics.areEqual((Object)it2, (Object)table.nameInDatabaseCase()) : (((CharSequence)scheme2).length() == 0 ? Intrinsics.areEqual((Object)it2, (Object)table.nameInDatabaseCase()) : Intrinsics.areEqual((Object)it2, (Object)DefaultKt.inProperCase(scheme2 + '.' + table.getTableNameWithoutScheme$exposed_core())));
                    if (!bl4) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean schemaExists(@NotNull Schema schema) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            List<String> allSchemas = this.getAllSchemaNamesCache();
            Iterable $this$any$iv = allSchemas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)DefaultKt.inProperCase(schema.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getConnection().metadata((Function1)new Function1<ExposedDatabaseMetadata, Map<Table, ? extends List<? extends ColumnMetadata>>>(tables){
            final /* synthetic */ Table[] $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<Table, List<ColumnMetadata>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
                return $this$metadata.columns(Arrays.copyOf(this.$tables, this.$tables.length));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... tables) {
        Iterable it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        HashMap constraints = new HashMap();
        Table[] $this$filter$iv = tables;
        boolean $i$f$filter = false;
        Table[] tableArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            boolean bl = false;
            if (!(!this.getColumnConstraintsCache().containsKey(((Table)((Object)it)).nameInDatabaseCase()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesToLoad = (List)destination$iv$iv;
        this.fillConstraintCacheForTables(tablesToLoad);
        Table[] $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        tableArray = $this$forEach$iv;
        int n = 0;
        int n2 = tableArray.length;
        while (n < n2) {
            void $this$forEach$iv2;
            Table element$iv = tableArray[n];
            ++n;
            Table table = element$iv;
            boolean bl = false;
            Collection collection = this.getColumnConstraintsCache().get(table.nameInDatabaseCase());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            it = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void $this$getOrPut$iv;
                ForeignKeyConstraint it2 = (ForeignKeyConstraint)element$iv2;
                boolean bl2 = false;
                Map map = constraints;
                Pair key$iv = TuplesKt.to((Object)table, it2.getFrom());
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(it2);
            }
        }
        return constraints;
    }

    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_core((Function1)new Function1<ExposedDatabaseMetadata, Map<Table, ? extends List<? extends Index>>>(tables){
            final /* synthetic */ Table[] $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<Table, List<Index>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
                return $this$metadata.existingIndices(Arrays.copyOf(this.$tables, this.$tables.length));
            }
        });
    }

    private final boolean getSupportsSelectForUpdate() {
        Lazy lazy = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return this.getSupportsSelectForUpdate();
    }

    @NotNull
    protected final String quoteIdentifierWhenWrongCaseOrNecessary(@NotNull String $this$quoteIdentifierWhenWrongCaseOrNecessary, @NotNull Transaction tr) {
        Intrinsics.checkNotNullParameter((Object)$this$quoteIdentifierWhenWrongCaseOrNecessary, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        return tr.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary($this$quoteIdentifierWhenWrongCaseOrNecessary);
    }

    @NotNull
    protected final Map<String, Collection<ForeignKeyConstraint>> getColumnConstraintsCache() {
        return this.columnConstraintsCache;
    }

    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        this.columnConstraintsCache.putAll((Map)TransactionManager.Companion.current().getDb().metadata$exposed_core((Function1)new Function1<ExposedDatabaseMetadata, Map<String, ? extends List<? extends ForeignKeyConstraint>>>(tables){
            final /* synthetic */ List<Table> $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<String, List<ForeignKeyConstraint>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
                return $this$metadata.tableConstraints(this.$tables);
            }
        }));
    }

    @Override
    public void resetCaches() {
        this._allTableNames = null;
        this.columnConstraintsCache.clear();
        TransactionManager.Companion.current().getDb().metadata$exposed_core(resetCaches.1.INSTANCE);
    }

    @Override
    public void resetSchemaCaches() {
        this._allSchemaNames = null;
        this.resetCaches();
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Transaction t = TransactionManager.Companion.current();
        String quotedTableName = t.identity(index.getTable());
        String quotedIndexName = t.getDb().getIdentifierManager().cutIfNecessaryAndQuote(index.getIndexName());
        String columnsList2 = CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(t){
            final /* synthetic */ Transaction $t;
            {
                this.$t = $t;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Column<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$t.identity(it);
            }
        }, (int)25, null);
        return index.getUnique() ? "ALTER TABLE " + quotedTableName + " ADD CONSTRAINT " + quotedIndexName + " UNIQUE " + columnsList2 : (index.getIndexType() != null ? this.createIndexWithType(quotedIndexName, quotedTableName, columnsList2, index.getIndexType()) : "CREATE INDEX " + quotedIndexName + " ON " + quotedTableName + ' ' + columnsList2);
    }

    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns2, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return "CREATE INDEX " + name + " ON " + table + ' ' + columns2 + " USING " + type;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName2, (String)"indexName");
        IdentifierManagerApi identifierManager2 = TransactionManager.Companion.current().getDb().getIdentifierManager();
        return "ALTER TABLE " + identifierManager2.quoteIfNecessary(tableName) + " DROP CONSTRAINT " + identifierManager2.quoteIfNecessary(indexName2);
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        return CollectionsKt.listOf((Object)("ALTER TABLE " + TransactionManager.Companion.current().identity(column.getTable()) + " MODIFY COLUMN " + column.descriptionDdl(true)));
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return DatabaseDialect.DefaultImpls.getSupportsIfNotExists(this);
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSequence(this);
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return DatabaseDialect.DefaultImpls.getNeedsSequenceToAutoInc(this);
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return DatabaseDialect.DefaultImpls.getDefaultReferenceOption(this);
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return DatabaseDialect.DefaultImpls.getNeedsQuotesWhenSymbolsInNames(this);
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsSequenceAsGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsOnlyIdentifiersInGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSchema(this);
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return DatabaseDialect.DefaultImpls.getSupportsSubqueryUnions(this);
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return DatabaseDialect.DefaultImpls.getSupportsDualTableConcept(this);
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return DatabaseDialect.DefaultImpls.getSupportsOrderByNullsFirstLast(this);
    }

    @Override
    public boolean checkTableMapping(@NotNull Table table) {
        return DatabaseDialect.DefaultImpls.checkTableMapping(this, table);
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        return DatabaseDialect.DefaultImpls.isAllowedAsColumnDefault(this, e);
    }

    @Override
    @NotNull
    public String catalog(@NotNull Transaction transaction2) {
        return DatabaseDialect.DefaultImpls.catalog(this, transaction2);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        return DatabaseDialect.DefaultImpls.createDatabase(this, name);
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        return DatabaseDialect.DefaultImpls.dropDatabase(this, name);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.setSchema(this, schema);
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.createSchema(this, schema);
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        return DatabaseDialect.DefaultImpls.dropSchema(this, schema, cascade);
    }
}

