/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarHandler;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarVirtualFileKt;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001bH\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020,H\u0016J\b\u0010.\u001a\u00020,H\u0016J\"\u0010/\u001a\u00020*2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020,2\b\u00102\u001a\u0004\u0018\u000103H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a(\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00010\u0001 \u000e*\u0014\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "handler", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler;", "name", "", "length", "", "parent", "entryDescription", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipEntryDescription;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler;Ljava/lang/CharSequence;ILorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarVirtualFile;Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipEntryDescription;)V", "myChildrenArray", "", "kotlin.jvm.PlatformType", "[Lcom/intellij/openapi/vfs/VirtualFile;", "myChildrenList", "", "contentsToByteArray", "", "getChildren", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getInputStream", "Ljava/io/InputStream;", "getLength", "", "getModificationStamp", "getName", "", "getNameSequence", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "newTimeStamp", "getParent", "getPath", "getTimeStamp", "initChildrenArrayFromList", "", "isDirectory", "", "isValid", "isWritable", "refresh", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "cli-base"})
@SourceDebugExtension(value={"SMAP\nFastJarVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastJarVirtualFile.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarVirtualFile\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,109:1\n37#2,2:110\n*E\n*S KotlinDebug\n*F\n+ 1 FastJarVirtualFile.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarVirtualFile\n*L\n31#1,2:110\n*E\n"})
public final class FastJarVirtualFile
extends VirtualFile {
    private VirtualFile[] myChildrenArray;
    private final List<VirtualFile> myChildrenList;
    private final FastJarHandler handler;
    private final CharSequence name;
    private final int length;
    private final FastJarVirtualFile parent;
    private final ZipEntryDescription entryDescription;

    public final void initChildrenArrayFromList() {
        Collection $this$toTypedArray$iv = this.myChildrenList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.myChildrenArray = thisCollection$iv.toArray(new VirtualFile[0]);
        this.myChildrenList.clear();
    }

    @Override
    @NotNull
    public String getName() {
        return ((Object)this.name).toString();
    }

    @Override
    @NotNull
    public CharSequence getNameSequence() {
        return this.name;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.handler.getFileSystem();
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.parent == null) {
            return FileUtil.toSystemIndependentName(this.handler.getFile$cli_base().getPath()) + "!/";
        }
        String parentPath = this.parent.getPath();
        StringBuilder answer = new StringBuilder(parentPath.length() + 1 + this.name.length());
        answer.append(parentPath);
        if (answer.charAt(answer.length() - 1) != '/') {
            answer.append('/');
        }
        answer.append(this.name);
        String string2 = answer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"answer.toString()");
        return string2;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.length < 0;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        Intrinsics.checkNotNullExpressionValue((Object)this.myChildrenArray, (String)"myChildrenArray");
        return this.myChildrenArray;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        throw (Throwable)new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.entryDescription == null) {
            return FastJarVirtualFileKt.access$getEMPTY_BYTE_ARRAY$p();
        }
        return this.handler.contentsToByteArray(this.entryDescription);
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray());
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    public FastJarVirtualFile(@NotNull FastJarHandler handler2, @NotNull CharSequence name2, int length, @Nullable FastJarVirtualFile parent2, @Nullable ZipEntryDescription entryDescription) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.handler = handler2;
            this.name = name2;
            this.length = length;
            this.parent = parent2;
            this.entryDescription = entryDescription;
            this.myChildrenArray = VirtualFile.EMPTY_ARRAY;
            this.myChildrenList = new ArrayList();
            Object object = this.parent;
            if (object == null || (object = ((FastJarVirtualFile)object).myChildrenList) == null) break block0;
            object.add(this);
        }
    }
}

