/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DataObjectContentChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isDeclaredInAny", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nDataObjectContentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataObjectContentChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DataObjectContentChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1747#2,3:40\n*S KotlinDebug\n*F\n+ 1 DataObjectContentChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DataObjectContentChecker\n*L\n28#1:40,3\n*E\n"})
public final class DataObjectContentChecker
implements DeclarationChecker {
    @NotNull
    public static final DataObjectContentChecker INSTANCE = new DataObjectContentChecker();

    private DataObjectContentChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(descriptor2 instanceof FunctionDescriptor)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName(), (Object)OperatorNameConventions.EQUALS) && !Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName(), (Object)OperatorNameConventions.HASH_CODE)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            DeclarationDescriptor container = declarationDescriptor;
            if (!(container instanceof ClassDescriptor)) {
                return;
            }
            if (!((ClassDescriptor)container).isData() || ((ClassDescriptor)container).getKind() != ClassKind.OBJECT) {
                return;
            }
            Set<CallableDescriptor> set = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)descriptor2);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAllOverriddenDescriptors(descriptor)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FunctionDescriptor p0 = (FunctionDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!this.isDeclaredInAny(p0)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            PsiElement psiElement = declaration.getModifierList();
            if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.OVERRIDE_KEYWORD)) == null) {
                psiElement = declaration;
            }
            PsiElement target = psiElement;
            context.getTrace().report(Errors.DATA_OBJECT_CUSTOM_EQUALS_OR_HASH_CODE.on(target));
        }
    }

    private final boolean isDeclaredInAny(FunctionDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor container = declarationDescriptor;
        return container instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)container);
    }
}

