/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getElementTextWithContext", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "util"})
public final class PsiUtilsKt {
    @NotNull
    public static final String getElementTextWithContext(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!psiElement.isValid()) {
            return "<invalid element " + psiElement + '>';
        }
        if (psiElement instanceof PsiFile) {
            String string2 = ((PsiFile)psiElement).getContainingFile().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiElement.containingFile.text");
            return string2;
        }
        PsiElement psiElement2 = PsiTreeUtil.findFirstParent(psiElement, arg_0 -> PsiUtilsKt.getElementTextWithContext$lambda$0(getElementTextWithContext.topLevelElement.1.INSTANCE, arg_0));
        if (psiElement2 == null) {
            throw new AssertionError((Object)"For non-file element we should always be able to find parent in file children");
        }
        PsiElement topLevelElement2 = psiElement2;
        int startContextOffset = topLevelElement2.getTextRange().getStartOffset();
        int elementContextOffset = psiElement.getTextRange().getStartOffset();
        int inFileParentOffset = elementContextOffset - startContextOffset;
        PsiFile containingFile = psiElement.getContainingFile();
        boolean isInjected = containingFile instanceof VirtualFileWindow;
        String string3 = new StringBuilder(topLevelElement2.getText()).insert(inFileParentOffset, "<caret>").insert(0, "File name: " + containingFile.getName() + " Physical: " + containingFile.isPhysical() + " Injected: " + isInjected + '\n').toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder(topLevelEl\u2026d\\n\")\n        .toString()");
        return string3;
    }

    private static final boolean getElementTextWithContext$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

