%define nightly %{nil}
%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc
%define release 1

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

Name: lal
Version: 6.19.1
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRequires: python2-rpm-macros
BuildRequires: bc
BuildRequires: fftw-devel
BuildRequires: python2-ligo-segments
BuildRequires: glue >= 1.54.1
BuildRequires: gsl-devel
BuildRequires: hdf5-devel
BuildRequires: less
BuildRequires: python-dateutil
BuildRequires: numpy
BuildRequires: scipy
BuildRequires: octave-devel
BuildRequires: python
BuildRequires: python-devel
BuildRequires: python-six
BuildRequires: swig >= 3.0.7
Requires: fftw
Requires: gsl
Requires: hdf5
Requires: less
Obsoletes: python-pylal < 0.13.2-1
Provides: python-pylal = 0.13.2-1
Prefix: %{_prefix}

%description
The LSC Algorithm Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL
Group: LAL
Requires: %{name} = %{version}
Requires: fftw-devel
Requires: gsl-devel
Requires: hdf5-devel
%description devel
The LSC Algorithm Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL library
as well as the documentation for the library.

%package -n python2-%{name}
Summary: Python %{python2_version} bindings for LAL
Group: LAL
Requires: %{name} = %{version}
Requires: python
Requires: python-dateutil
Requires: numpy
Requires: scipy
Requires: python-six
Requires: python2-ligo-segments
Requires: glue >= 1.54.1
Obsoletes: %{name}-python
Provides: %{name}-python
%description -n python2-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python2_version} bindings.

%package octave
Summary: Octave bindings for LAL
Group: LAL
Requires: %{name} = %{version}
Requires: octave
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings.

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure --disable-gcc-flags --enable-swig
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lal_simd_detect
%{_bindir}/lal_version
%{_libdir}/*.so.*
%{_sysconfdir}/lal-user-env.*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{python2_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lal.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jan 07 2019 Adam Mercer <adam.mercer@ligo.org> 6.19.1-1
- Intel FFT complilation fixes

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 6.19.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 6.18.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@lgio.org> 6.17.0-1
- ER10 Release

* Tue Jun 21 2016 Adam Mercer <adam.mercer@ligo.org> 6.16.1-1
- ER9 Release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 6.16.0-1
- Pre O2 packaging test release
