%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts %{nil}

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lal
Version: 7.6.0
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
License: GPLv2+
Source0: https://software.igwn.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: bc
BuildRequires: fftw-devel
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: hdf5-devel
BuildRequires: help2man >= 1.37
BuildRequires: less
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.11

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-dateutil
BuildRequires: python%{python3_pkgversion}-freezegun
BuildRequires: python%{python3_pkgversion}-ligo-lw
BuildRequires: python%{python3_pkgversion}-ligo-segments
BuildRequires: python%{python3_pkgversion}-numpy >= 1.7
BuildRequires: python%{python3_pkgversion}-pytest
BuildRequires: python%{python3_pkgversion}-scipy

# octave
BuildRequires: octave-devel

# -- packages ---------------

# lal
Summary: LVK Algorithm Library - runtime tools
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}-%{name} = %{version}-%{release}
Obsoletes: python2-%{name} <= 7.1.2-1
%description
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the runtime tools.

# liblal
%package -n lib%{name}
Summary: LVK Algorithm Library -- library package
Requires: less
Conflicts: lal <= 7.1.0-1
Obsoletes: python-pylal < 0.13.2-1
%description -n lib%{name}
The LVK Algorithm Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL library.

# liblal-devel
%package -n lib%{name}-devel
Summary: Files and documentation needed for compiling programs that use LAL
Requires: lib%{name} = %{version}-%{release}
Requires: fftw-devel
Requires: gsl-devel
Requires: hdf5-devel
Provides: %{name}-devel = %{version}-%{release}
Obsoletes: %{name}-devel < 7.1.1-1
%description -n lib%{name}-devel
The LVK Algorithm Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL library
as well as the documentation for the library.

# python3x-lal
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} bindings for LAL
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-dateutil
Requires: python%{python3_pkgversion}-ligo-lw
Requires: python%{python3_pkgversion}-ligo-segments
Requires: python%{python3_pkgversion}-numpy >= 1.7
Requires: python%{python3_pkgversion}-scipy
Obsoletes: python2-%{name} <= 7.1.3-1
# temporariliy commented out.  if it was said to be a requirement it would
# create a dependency loop, but it's an optional runtime dependency.
# unfortunately the "Recommends" key-word is not yet available in the
# package management system of LDG clusters.  uncomment when the feature
# becomes available.
#Recommends: python%{python3_pkgversion}-ligo-lw
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python3_version} bindings.

# lal-octave
%package octave
Summary: Octave bindings for LAL
Requires: %{name} = %{version}-%{release}
Requires: octave
%description octave
The LVK Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python3}
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install

find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post -n lib%{name} -p /sbin/ldconfig

%postun -n lib%{name} -p /sbin/ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files -n lib%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_libdir}/*.so.*

%files -n lib%{name}-devel
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lal.oct*

%files
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_bindir}/*
%{_mandir}/man1/*
%{_mandir}/man7/*
%{_sysconfdir}/*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jul 29 2024 Adam Mercer <adam.mercer@ligo.org> 7.6.0-1
- Update gfor 7.6.0

* Mon Mar 11 2024 Duncan Macleod <duncan.macleod@ligo.org> 7.5.0-1
- Update for 7.5.0

* Fri Oct 20 2023 Adam Mercer <adam.mercer@ligo.org> 7.4.1-1
- Update for 7.4.1

* Fri Oct 06 2023 Adam Mercer <adam.mercer@ligo.org> 7.4.0-1
- Update for 7.4.0

* Thu Apr 06 2023 Adam Mercer <adam.mercer@ligo.org> 7.3.1-1
- Update for 7.3.1

* Mon Feb 06 2023 Adam Mercer <adam.mercer@ligo.org> 7.3.0-1
- Update for 7.3.0

* Fri Sep 30 2022 Adam Mercer <adam.mercer@ligo.org> 7.2.4-1
- Update for 7.2.4

* Wed Sep 28 2022 Adam Mercer <adam.mercer@ligo.org> 7.2.3-1
- Update for 7.2.3

* Tue Sep 06 2022 Adam Mercer <adam.mercer@ligo.org> 7.2.2-1
- Update for 7.2.2

* Thu Aug 18 2022 Adam Mercer <adam.mercer@ligo.org> 7.2.1-1
- Update for 7.2.1

* Tue Aug 02 2022 Adam Mercer <adam.mercer@ligo.org> 7.2.0-1
- Update for 7.2.0

* Thu Mar 03 2022 Adam Mercer <adam.mercer@ligo.org> 7.1.7-1
- Update for 7.1.7

* Mon Jan 10 2022 Adam Mercer <adam.mercer@ligo.org> 7.1.6-1
- Update for 7.1.6

* Fri Dec 03 2021 Adam Mercer <adam.mercer@ligo.org> 7.1.5-1
- Update for 7.1.5

* Wed Nov 17 2021 Adam Mercer <adam.mercer@ligo.org> 7.1.4-1
- Update for 7.1.4

* Mon May 17 2021 Adam Mercer <adam.mercer@ligo.org> 7.1.3-1
- Update for 7.1.3

* Fri Feb 05 2021 Adam Mercer <adam.mercer@ligo.org> 7.1.2-1
- Update for 7.1.2

* Mon Jan 11 2021 Adam Mercer <adam.mercer@ligo.org> 7.1.1-1
- Update for 7.1.1

* Tue Oct 27 2020 Adam Mercer <adam.mercer@ligo.org> 7.1.0-1
- Update for 7.1.0

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 7.0.0-1
- Update for 7.0.0

* Wed Mar 25 2020 Duncan Macleod <duncan.macleod@ligo.org> 6.22.0-1
- Update for 6.22.0

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 6.21.0-3
- Packaging updates

* Wed Dec 04 2019 Adam Mercer <adam.mercer@ligo.org> 6.21.0-2
- Packaging updates

* Fri Nov 22 2019 Adam Mercer <adam.mercer@ligo.org> 6.21.0-1
- O3b release

* Wed Jun 26 2019 Adam Mercer <adam.mercer@ligo.org> 6.20.2-1
- MKL FFT fixes

* Fri May 24 2019 Adam Mercer <adam.mercer@ligo.org> 6.20.1-1
- O3 point release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 6.20.0-1
- O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 6.19.2-1
- ER13 release

* Mon Jan 07 2019 Adam Mercer <adam.mercer@ligo.org> 6.19.1-1
- Intel FFT complilation fixes

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 6.19.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 6.18.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@lgio.org> 6.17.0-1
- ER10 Release

* Tue Jun 21 2016 Adam Mercer <adam.mercer@ligo.org> 6.16.1-1
- ER9 Release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 6.16.0-1
- Pre O2 packaging test release
