/*
 * LALDetCharVCSInfo.h - LALDetChar VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALDETCHARVCSINFO_H
#define _LALDETCHARVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \defgroup LALDetCharVCSInfo_h Header LALDetCharVCSInfo.h
 * \ingroup laldetchar_general
 * \brief VCS information for LALDetChar
 */
/*@{*/

/** \name Global variables for LALDetChar VCS information */
/*@{*/
extern const char *const lalDetCharVCSVersion;
extern const char *const lalDetCharVCSId;
extern const char *const lalDetCharVCSDate;
extern const char *const lalDetCharVCSBranch;
extern const char *const lalDetCharVCSTag;
extern const char *const lalDetCharVCSAuthor;
extern const char *const lalDetCharVCSCommitter;
extern const char *const lalDetCharVCSStatus;
/*@}*/

/** \name Identable global variables for LALDetChar VCS information */
/*@{*/
extern const char *const lalDetCharVCSIdentId;
extern const char *const lalDetCharVCSIdentDate;
extern const char *const lalDetCharVCSIdentBranch;
extern const char *const lalDetCharVCSIdentTag;
extern const char *const lalDetCharVCSIdentAuthor;
extern const char *const lalDetCharVCSIdentCommitter;
extern const char *const lalDetCharVCSIdentStatus;
/*@}*/

/** LALDetChar VCS information */
extern const LALVCSInfo lalDetCharVCSInfo;

/** List of VCS information for LALDetChar and its LALSuite dependencies (<tt>NULL</tt>-terminated) */
extern const LALVCSInfo *const lalDetCharVCSInfoList[32];

/** LALDetChar <tt>configure</tt> arguments */
extern const char *const lalDetCharConfigureArgs;

/** LALDetChar <tt>configure</tt> date */
extern const char *const lalDetCharConfigureDate;

/** LALDetChar build date */
extern const char *const lalDetCharBuildDate;

/** Check LALDetChar VCS information for compile-time/run-time version mismatch */
#ifndef SWIG /* exclude from SWIG interface */
int XLALDetCharVCSInfoCheck(void);
#endif /* SWIG */


/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LALDETCHARVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
