/*
 * Copyright (C) 2014, 2016 Karl Wette
 * Copyright (C) 2009-2013 Adam Mercer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * LALDetCharVCSInfo.h - LALDetChar VCS Information Header
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALDETCHARVCSINFOHEADER_H
#define _LALDETCHARVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALDetCharVCSInfo.h>
#include <lal/LALDetCharConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information */
#define LALDETCHAR_VCS_ID "b2ecf41f30505146ab6d0ec98bfc09f13bca58bc"
#define LALDETCHAR_VCS_DATE "2017-02-6 18:16:00 +0000"
#define LALDETCHAR_VCS_BRANCH "None"
#define LALDETCHAR_VCS_TAG "laldetchar-v0.3.5"
#define LALDETCHAR_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALDETCHAR_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALDETCHAR_VCS_CLEAN "CLEAN"
#define LALDETCHAR_VCS_STATUS "CLEAN: All modifications committed"

/* VCS header/library mismatch link check function */
#define LALDETCHAR_VCS_LINK_CHECK LALDETCHAR_CLEAN_b2ecf41f30505146ab6d0ec98bfc09f13bca58bc_VCS_HEADER_LIBRARY_MISMATCH
void LALDETCHAR_VCS_LINK_CHECK(void);

#ifdef __cplusplus
}
#endif

#endif /* _LALDETCHARVCSINFOHEADER_H */

/** \endcond */
